/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.Unsafe;
import java.util.concurrent.locks.ReentrantLock;

public abstract class ForkJoinTask<V>
implements Future<V>,
Serializable {
    volatile int status;
    private static final int NORMAL = -1;
    private static final int CANCELLED = -2;
    static final int EXCEPTIONAL = -3;
    private static final int SIGNAL = 1;
    private static final ExceptionNode[] exceptionTable;
    private static final ReentrantLock exceptionTableLock;
    private static final ReferenceQueue<Object> exceptionTableRefQueue;
    private static final int EXCEPTION_MAP_CAPACITY = 32;
    private static final long serialVersionUID = -7721805057305804111L;
    private static final Unsafe UNSAFE;
    private static final long statusOffset;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setCompletion(int completion) {
        int s;
        do {
            if ((s = this.status) >= 0) continue;
            return s;
        } while (!UNSAFE.compareAndSwapInt(this, statusOffset, s, completion));
        if (s != 0) {
            ForkJoinTask forkJoinTask = this;
            synchronized (forkJoinTask) {
                this.notifyAll();
            }
        }
        return completion;
    }

    public final void quietlyComplete() {
        this.setCompletion(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void tryAwaitDone(long millis) {
        block6: {
            try {
                int s = this.status;
                if (s <= 0 && (s != 0 || !UNSAFE.compareAndSwapInt(this, statusOffset, 0, 1)) || this.status <= 0) break block6;
                ForkJoinTask forkJoinTask = this;
                synchronized (forkJoinTask) {
                    if (this.status > 0) {
                        this.wait(millis);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int externalAwaitDone() {
        int s = this.status;
        if (s >= 0) {
            boolean interrupted = false;
            ForkJoinTask forkJoinTask = this;
            synchronized (forkJoinTask) {
                while ((s = this.status) >= 0) {
                    if (s == 0) {
                        UNSAFE.compareAndSwapInt(this, statusOffset, 0, 1);
                        continue;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ie) {
                        interrupted = true;
                    }
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int externalInterruptibleAwaitDone(long millis) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        int s = this.status;
        if (s >= 0) {
            ForkJoinTask forkJoinTask = this;
            synchronized (forkJoinTask) {
                while ((s = this.status) >= 0) {
                    if (s == 0) {
                        UNSAFE.compareAndSwapInt(this, statusOffset, 0, 1);
                        continue;
                    }
                    this.wait(millis);
                    if (millis <= 0L) continue;
                }
            }
        }
        return s;
    }

    final void doExec() {
        if (this.status >= 0) {
            boolean completed;
            try {
                completed = this.exec();
            }
            catch (Throwable rex) {
                this.setExceptionalCompletion(rex);
                return;
            }
            if (completed) {
                this.setCompletion(-1);
            }
        }
    }

    private int doJoin() {
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            int s = this.status;
            if (s < 0) {
                return s;
            }
            ForkJoinWorkerThread w = (ForkJoinWorkerThread)t;
            if (w.unpushTask(this)) {
                boolean completed;
                try {
                    completed = this.exec();
                }
                catch (Throwable rex) {
                    return this.setExceptionalCompletion(rex);
                }
                if (completed) {
                    return this.setCompletion(-1);
                }
            }
            return w.joinTask(this);
        }
        return this.externalAwaitDone();
    }

    private int doInvoke() {
        boolean completed;
        int s = this.status;
        if (s < 0) {
            return s;
        }
        try {
            completed = this.exec();
        }
        catch (Throwable rex) {
            return this.setExceptionalCompletion(rex);
        }
        if (completed) {
            return this.setCompletion(-1);
        }
        return this.doJoin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setExceptionalCompletion(Throwable ex) {
        int h = System.identityHashCode(this);
        ReentrantLock lock = exceptionTableLock;
        lock.lock();
        try {
            ForkJoinTask.expungeStaleExceptions();
            ExceptionNode[] t = exceptionTable;
            int i = h & t.length - 1;
            ExceptionNode e = t[i];
            while (true) {
                if (e == null) {
                    t[i] = new ExceptionNode(this, ex, t[i]);
                    break;
                }
                if (e.get() == this) {
                    break;
                }
                e = e.next;
            }
        }
        finally {
            lock.unlock();
        }
        return this.setCompletion(-3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearExceptionalCompletion() {
        int h = System.identityHashCode(this);
        ReentrantLock lock = exceptionTableLock;
        lock.lock();
        try {
            ExceptionNode[] t = exceptionTable;
            int i = h & t.length - 1;
            ExceptionNode e = t[i];
            ExceptionNode pred = null;
            while (e != null) {
                ExceptionNode next = e.next;
                if (e.get() == this) {
                    if (pred == null) {
                        t[i] = next;
                        break;
                    }
                    pred.next = next;
                    break;
                }
                pred = e;
                e = next;
            }
            ForkJoinTask.expungeStaleExceptions();
            this.status = 0;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Throwable getThrowableException() {
        Throwable ex;
        ExceptionNode e;
        if (this.status != -3) {
            return null;
        }
        int h = System.identityHashCode(this);
        ReentrantLock lock = exceptionTableLock;
        lock.lock();
        try {
            ForkJoinTask.expungeStaleExceptions();
            ExceptionNode[] t = exceptionTable;
            e = t[h & t.length - 1];
            while (e != null && e.get() != this) {
                e = e.next;
            }
        }
        finally {
            lock.unlock();
        }
        if (e == null || (ex = e.ex) == null) {
            return null;
        }
        if (e.thrower != Thread.currentThread().getId()) {
            Class<?> ec = ex.getClass();
            try {
                Constructor<?> noArgCtor = null;
                Constructor<?>[] cs = ec.getConstructors();
                for (int i = 0; i < cs.length; ++i) {
                    Constructor<?> c = cs[i];
                    Class<?>[] ps = c.getParameterTypes();
                    if (ps.length == 0) {
                        noArgCtor = c;
                        continue;
                    }
                    if (ps.length != 1 || ps[0] != Throwable.class) continue;
                    return (Throwable)c.newInstance(ex);
                }
                if (noArgCtor != null) {
                    Throwable wx = (Throwable)noArgCtor.newInstance(new Object[0]);
                    wx.initCause(ex);
                    return wx;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ex;
    }

    private static void expungeStaleExceptions() {
        Reference<Object> x;
        block0: while ((x = exceptionTableRefQueue.poll()) != null) {
            if (!(x instanceof ExceptionNode)) continue;
            ForkJoinTask key = (ForkJoinTask)((ExceptionNode)x).get();
            ExceptionNode[] t = exceptionTable;
            int i = System.identityHashCode(key) & t.length - 1;
            ExceptionNode e = t[i];
            ExceptionNode pred = null;
            while (e != null) {
                ExceptionNode next = e.next;
                if (e == x) {
                    if (pred == null) {
                        t[i] = next;
                        continue block0;
                    }
                    pred.next = next;
                    continue block0;
                }
                pred = e;
                e = next;
            }
        }
    }

    static final void helpExpungeStaleExceptions() {
        ReentrantLock lock = exceptionTableLock;
        if (lock.tryLock()) {
            try {
                ForkJoinTask.expungeStaleExceptions();
            }
            finally {
                lock.unlock();
            }
        }
    }

    private V reportResult() {
        Throwable ex;
        int s = this.status;
        if (s == -2) {
            throw new CancellationException();
        }
        if (s == -3 && (ex = this.getThrowableException()) != null) {
            UNSAFE.throwException(ex);
        }
        return this.getRawResult();
    }

    public final ForkJoinTask<V> fork() {
        ((ForkJoinWorkerThread)Thread.currentThread()).pushTask(this);
        return this;
    }

    public final V join() {
        if (this.doJoin() != -1) {
            return this.reportResult();
        }
        return this.getRawResult();
    }

    public final V invoke() {
        if (this.doInvoke() != -1) {
            return this.reportResult();
        }
        return this.getRawResult();
    }

    public static void invokeAll(ForkJoinTask<?> t1, ForkJoinTask<?> t2) {
        t2.fork();
        t1.invoke();
        t2.join();
    }

    public static void invokeAll(ForkJoinTask<?> ... tasks) {
        ForkJoinTask<?> t;
        int last;
        int i;
        Throwable ex = null;
        for (i = last = tasks.length - 1; i >= 0; --i) {
            t = tasks[i];
            if (t == null) {
                if (ex != null) continue;
                ex = new NullPointerException();
                continue;
            }
            if (i != 0) {
                t.fork();
                continue;
            }
            if (super.doInvoke() >= -1 || ex != null) continue;
            ex = t.getException();
        }
        for (i = 1; i <= last; ++i) {
            t = tasks[i];
            if (t == null) continue;
            if (ex != null) {
                t.cancel(false);
                continue;
            }
            if (super.doJoin() >= -1 || ex != null) continue;
            ex = t.getException();
        }
        if (ex != null) {
            UNSAFE.throwException(ex);
        }
    }

    public static <T extends ForkJoinTask<?>> Collection<T> invokeAll(Collection<T> tasks) {
        ForkJoinTask t;
        int last;
        int i;
        if (!(tasks instanceof RandomAccess) || !(tasks instanceof List)) {
            ForkJoinTask.invokeAll(tasks.toArray(new ForkJoinTask[tasks.size()]));
            return tasks;
        }
        List ts = (List)tasks;
        Throwable ex = null;
        for (i = last = ts.size() - 1; i >= 0; --i) {
            t = (ForkJoinTask)ts.get(i);
            if (t == null) {
                if (ex != null) continue;
                ex = new NullPointerException();
                continue;
            }
            if (i != 0) {
                t.fork();
                continue;
            }
            if (t.doInvoke() >= -1 || ex != null) continue;
            ex = t.getException();
        }
        for (i = 1; i <= last; ++i) {
            t = (ForkJoinTask)ts.get(i);
            if (t == null) continue;
            if (ex != null) {
                t.cancel(false);
                continue;
            }
            if (t.doJoin() >= -1 || ex != null) continue;
            ex = t.getException();
        }
        if (ex != null) {
            UNSAFE.throwException(ex);
        }
        return tasks;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.setCompletion(-2) == -2;
    }

    final void cancelIgnoringExceptions() {
        try {
            this.cancel(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public final boolean isDone() {
        return this.status < 0;
    }

    @Override
    public final boolean isCancelled() {
        return this.status == -2;
    }

    public final boolean isCompletedAbnormally() {
        return this.status < -1;
    }

    public final boolean isCompletedNormally() {
        return this.status == -1;
    }

    public final Throwable getException() {
        int s = this.status;
        return s >= -1 ? null : (s == -2 ? new CancellationException() : this.getThrowableException());
    }

    public void completeExceptionally(Throwable ex) {
        this.setExceptionalCompletion(ex instanceof RuntimeException || ex instanceof Error ? ex : new RuntimeException(ex));
    }

    public void complete(V value) {
        try {
            this.setRawResult(value);
        }
        catch (Throwable rex) {
            this.setExceptionalCompletion(rex);
            return;
        }
        this.setCompletion(-1);
    }

    @Override
    public final V get() throws InterruptedException, ExecutionException {
        Throwable ex;
        int s;
        int n = s = Thread.currentThread() instanceof ForkJoinWorkerThread ? this.doJoin() : this.externalInterruptibleAwaitDone(0L);
        if (s == -2) {
            throw new CancellationException();
        }
        if (s == -3 && (ex = this.getThrowableException()) != null) {
            throw new ExecutionException(ex);
        }
        return this.getRawResult();
    }

    @Override
    public final V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread w = (ForkJoinWorkerThread)t;
            long nanos = unit.toNanos(timeout);
            if (this.status >= 0) {
                boolean completed = false;
                if (w.unpushTask(this)) {
                    try {
                        completed = this.exec();
                    }
                    catch (Throwable rex) {
                        this.setExceptionalCompletion(rex);
                    }
                }
                if (completed) {
                    this.setCompletion(-1);
                } else if (this.status >= 0 && nanos > 0L) {
                    w.pool.timedAwaitJoin(this, nanos);
                }
            }
        } else {
            long millis = unit.toMillis(timeout);
            if (millis > 0L) {
                this.externalInterruptibleAwaitDone(millis);
            }
        }
        int s = this.status;
        if (s != -1) {
            if (s == -2) {
                throw new CancellationException();
            }
            if (s != -3) {
                throw new TimeoutException();
            }
            Throwable ex = this.getThrowableException();
            if (ex != null) {
                throw new ExecutionException(ex);
            }
        }
        return this.getRawResult();
    }

    public final void quietlyJoin() {
        this.doJoin();
    }

    public final void quietlyInvoke() {
        this.doInvoke();
    }

    public static void helpQuiesce() {
        ((ForkJoinWorkerThread)Thread.currentThread()).helpQuiescePool();
    }

    public void reinitialize() {
        if (this.status == -3) {
            this.clearExceptionalCompletion();
        } else {
            this.status = 0;
        }
    }

    public static ForkJoinPool getPool() {
        Thread t = Thread.currentThread();
        return t instanceof ForkJoinWorkerThread ? ((ForkJoinWorkerThread)t).pool : null;
    }

    public static boolean inForkJoinPool() {
        return Thread.currentThread() instanceof ForkJoinWorkerThread;
    }

    public boolean tryUnfork() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).unpushTask(this);
    }

    public static int getQueuedTaskCount() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).getQueueSize();
    }

    public static int getSurplusQueuedTaskCount() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).getEstimatedSurplusTaskCount();
    }

    public abstract V getRawResult();

    protected abstract void setRawResult(V var1);

    protected abstract boolean exec();

    protected static ForkJoinTask<?> peekNextLocalTask() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).peekTask();
    }

    protected static ForkJoinTask<?> pollNextLocalTask() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).pollLocalTask();
    }

    protected static ForkJoinTask<?> pollTask() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).pollTask();
    }

    public static ForkJoinTask<?> adapt(Runnable runnable) {
        return new AdaptedRunnable<Object>(runnable, null);
    }

    public static <T> ForkJoinTask<T> adapt(Runnable runnable, T result) {
        return new AdaptedRunnable<T>(runnable, result);
    }

    public static <T> ForkJoinTask<T> adapt(Callable<? extends T> callable) {
        return new AdaptedCallable<T>(callable);
    }

    final int recordExceptionalCompletion(Throwable ex) {
        return 0;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.getException());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Object ex = s.readObject();
        if (ex != null) {
            this.setExceptionalCompletion((Throwable)ex);
        }
    }

    static {
        exceptionTableLock = new ReentrantLock();
        exceptionTableRefQueue = new ReferenceQueue();
        exceptionTable = new ExceptionNode[32];
        try {
            UNSAFE = Unsafe.getUnsafe();
            statusOffset = UNSAFE.objectFieldOffset(ForkJoinTask.class.getDeclaredField("status"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    static final class ExceptionNode
    extends WeakReference<ForkJoinTask<?>> {
        final Throwable ex;
        ExceptionNode next;
        final long thrower;

        ExceptionNode(ForkJoinTask<?> task, Throwable ex, ExceptionNode next) {
            super(task, exceptionTableRefQueue);
            this.ex = ex;
            this.next = next;
            this.thrower = Thread.currentThread().getId();
        }
    }

    static final class AdaptedRunnable<T>
    extends ForkJoinTask<T>
    implements RunnableFuture<T> {
        final Runnable runnable;
        final T resultOnCompletion;
        T result;
        private static final long serialVersionUID = 5232453952276885070L;

        AdaptedRunnable(Runnable runnable, T result) {
            if (runnable == null) {
                throw new NullPointerException();
            }
            this.runnable = runnable;
            this.resultOnCompletion = result;
        }

        @Override
        public T getRawResult() {
            return this.result;
        }

        @Override
        public void setRawResult(T v) {
            this.result = v;
        }

        @Override
        public boolean exec() {
            this.runnable.run();
            this.result = this.resultOnCompletion;
            return true;
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    static final class AdaptedCallable<T>
    extends ForkJoinTask<T>
    implements RunnableFuture<T> {
        final Callable<? extends T> callable;
        T result;
        private static final long serialVersionUID = 2838392045355241008L;

        AdaptedCallable(Callable<? extends T> callable) {
            if (callable == null) {
                throw new NullPointerException();
            }
            this.callable = callable;
        }

        @Override
        public T getRawResult() {
            return this.result;
        }

        @Override
        public void setRawResult(T v) {
            this.result = v;
        }

        @Override
        public boolean exec() {
            try {
                this.result = this.callable.call();
                return true;
            }
            catch (Error err) {
                throw err;
            }
            catch (RuntimeException rex) {
                throw rex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void run() {
            this.invoke();
        }
    }
}

