/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Currency
implements Serializable {
    private static final long serialVersionUID = -158308464356906721L;
    private final String currencyCode;
    private final transient int defaultFractionDigits;
    private final transient int numericCode;
    private static HashMap<String, Currency> instances = new HashMap(7);
    private static HashSet<Currency> available;
    static int formatVersion;
    static int dataVersion;
    static int[] mainTable;
    static long[] scCutOverTimes;
    static String[] scOldCurrencies;
    static String[] scNewCurrencies;
    static int[] scOldCurrenciesDFD;
    static int[] scNewCurrenciesDFD;
    static int[] scOldCurrenciesNumericCode;
    static int[] scNewCurrenciesNumericCode;
    static String otherCurrencies;
    static int[] otherCurrenciesDFD;
    static int[] otherCurrenciesNumericCode;
    private static final int MAGIC_NUMBER = 1131770436;
    private static final int A_TO_Z = 26;
    private static final int INVALID_COUNTRY_ENTRY = 127;
    private static final int COUNTRY_WITHOUT_CURRENCY_ENTRY = 128;
    private static final int SIMPLE_CASE_COUNTRY_MASK = 0;
    private static final int SIMPLE_CASE_COUNTRY_FINAL_CHAR_MASK = 31;
    private static final int SIMPLE_CASE_COUNTRY_DEFAULT_DIGITS_MASK = 96;
    private static final int SIMPLE_CASE_COUNTRY_DEFAULT_DIGITS_SHIFT = 5;
    private static final int SPECIAL_CASE_COUNTRY_MASK = 128;
    private static final int SPECIAL_CASE_COUNTRY_INDEX_MASK = 31;
    private static final int SPECIAL_CASE_COUNTRY_INDEX_DELTA = 1;
    private static final int COUNTRY_TYPE_MASK = 128;
    private static final int NUMERIC_CODE_MASK = 261888;
    private static final int NUMERIC_CODE_SHIFT = 8;
    private static final int VALID_FORMAT_VERSION = 1;
    private static final int SYMBOL = 0;
    private static final int DISPLAYNAME = 1;

    private Currency(String currencyCode, int defaultFractionDigits, int numericCode) {
        this.currencyCode = currencyCode;
        this.defaultFractionDigits = defaultFractionDigits;
        this.numericCode = numericCode;
    }

    public static Currency getInstance(String currencyCode) {
        return Currency.getInstance(currencyCode, Integer.MIN_VALUE, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Currency getInstance(String currencyCode, int defaultFractionDigits, int numericCode) {
        HashMap<String, Currency> hashMap = instances;
        synchronized (hashMap) {
            Currency instance = instances.get(currencyCode);
            if (instance != null) {
                return instance;
            }
            if (defaultFractionDigits == Integer.MIN_VALUE) {
                defaultFractionDigits = 2;
                numericCode = 840;
            }
            instance = new Currency(currencyCode, defaultFractionDigits, numericCode);
            instances.put(currencyCode, instance);
            return instance;
        }
    }

    public static Currency getInstance(Locale locale) {
        return Currency.getInstance("USD");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Currency> getAvailableCurrencies() {
        Class<Currency> clazz = Currency.class;
        synchronized (Currency.class) {
            if (available == null) {
                available = new HashSet(256);
                available.add(Currency.getInstance("USD"));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return (Set)available.clone();
        }
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getSymbol() {
        return this.getSymbol(Locale.getDefault(Locale.Category.DISPLAY));
    }

    public String getSymbol(Locale locale) {
        return "$";
    }

    public int getDefaultFractionDigits() {
        return this.defaultFractionDigits;
    }

    public int getNumericCode() {
        return this.numericCode;
    }

    public String getDisplayName() {
        return this.getDisplayName(Locale.getDefault(Locale.Category.DISPLAY));
    }

    public String getDisplayName(Locale locale) {
        return this.currencyCode;
    }

    public String toString() {
        return this.currencyCode;
    }

    private Object readResolve() {
        return Currency.getInstance(this.currencyCode);
    }

    private static int getMainTableEntry(char char1, char char2) {
        if (char1 < 'A' || char1 > 'Z' || char2 < 'A' || char2 > 'Z') {
            throw new IllegalArgumentException();
        }
        return mainTable[(char1 - 65) * 26 + (char2 - 65)];
    }

    private static void setMainTableEntry(char char1, char char2, int entry) {
        if (char1 < 'A' || char1 > 'Z' || char2 < 'A' || char2 > 'Z') {
            throw new IllegalArgumentException();
        }
        Currency.mainTable[(char1 - 65) * 26 + (char2 - 65)] = entry;
    }

    private static int[] readIntArray(DataInputStream dis, int count) throws IOException {
        int[] ret = new int[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = dis.readInt();
        }
        return ret;
    }

    private static long[] readLongArray(DataInputStream dis, int count) throws IOException {
        long[] ret = new long[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = dis.readLong();
        }
        return ret;
    }

    private static String[] readStringArray(DataInputStream dis, int count) throws IOException {
        String[] ret = new String[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = dis.readUTF();
        }
        return ret;
    }

    private static void info(String message, Throwable t) {
        Logger logger = Logger.getLogger("java.util.Currency");
        if (logger.isLoggable(Level.INFO)) {
            if (t != null) {
                logger.log(Level.INFO, message, t);
            } else {
                logger.info(message);
            }
        }
    }
}

