/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;
import org.apidesign.bck2brwsr.core.JavaScriptBody;

public class System {
    private static final Object[] lifeCycle;
    private static Properties mprops;
    public static final InputStream in;
    public static final PrintStream out;
    public static final PrintStream err;

    private System() {
    }

    public static void arraycopy(Object value, int srcBegin, Object dst, int dstBegin, int count) {
        org.apidesign.bck2brwsr.emul.lang.System.arraycopy((Object)value, (int)srcBegin, (Object)dst, (int)dstBegin, (int)count);
    }

    public static long currentTimeMillis() {
        return org.apidesign.bck2brwsr.emul.lang.System.currentTimeMillis();
    }

    public static long nanoTime() {
        return org.apidesign.bck2brwsr.emul.lang.System.nanoTime();
    }

    public static int identityHashCode(Object obj) {
        return Class.defaultHashCode((Object)obj);
    }

    public static String getProperty(String name) {
        if ("os.name".equals(name)) {
            return System.userAgent();
        }
        if ("java.version".equals(name)) {
            return "1.7";
        }
        return (String)mprops.get(name);
    }

    @JavaScriptBody(args={}, body="return (typeof navigator !== 'undefined') ? navigator.userAgent : 'unknown';")
    private static native String userAgent();

    public static String getProperty(String key, String def) {
        String answer = (String)mprops.get(key);
        return answer == null ? def : answer;
    }

    public static Properties getProperties() {
        return mprops;
    }

    public static void setProperties(Properties p) {
        mprops = p;
    }

    public static String setProperty(String key, String value) {
        return (String)mprops.setProperty(key, value);
    }

    public static String lineSeparator() {
        return "\n";
    }

    @JavaScriptBody(args={"socket"}, body="\n        socket[0] = null;\n        if (typeof WebSocket !== 'undefined') {\n            var s = new WebSocket('ws://' + location.host + '/heartbeat');\n            s.onopen = function(ev) {\n                socket[0] = s;\n                s.send('Application is running');\n            }\n            s.onmessage = function(ev) {\n                console.log(ev.data);\n                if ('reload' === ev.data) {\n                    window.location.reload();\n                }\n            }\n        }\n")
    private static void initLifeCycle(Object[] socket) {
        socket[0] = null;
    }

    @JavaScriptBody(args={"s", "exitCode"}, body="\n         s.send('exit: ' + exitCode);\n         window.close();\n")
    private static void lifeCycleExit(Object lifeCycle, int exitCode) {
    }

    @JavaScriptBody(args={"exitCode"}, body="var xhttp = new XMLHttpRequest();\nxhttp.open('GET', '/?exit=' + exitCode, true);\nxhttp.onreadystatechange = function () {\n  window.close();\n};\nxhttp.send();\n")
    private static void xhrExit(int exitCode) {
    }

    public static void exit(int exitCode) {
        if (lifeCycle[0] != null) {
            System.lifeCycleExit(lifeCycle[0], exitCode);
        } else {
            System.xhrExit(exitCode);
        }
    }

    public static void setOut(PrintStream out) {
        throw new SecurityException();
    }

    public static void setIn(InputStream in) {
        throw new SecurityException();
    }

    public static void setErr(PrintStream err) {
        throw new SecurityException();
    }

    static {
        PrintStream warn;
        PrintStream log;
        lifeCycle = new Object[]{null};
        System.initLifeCycle(lifeCycle);
        mprops = new Properties();
        in = new ByteArrayInputStream(new byte[0]);
        try {
            log = new PrintStream(new BufferedOutputStream(new SystemStream("log")));
            SystemStream rawWarn = new SystemStream("warn");
            org.apidesign.bck2brwsr.emul.lang.System.registerStdErr((OutputStream)rawWarn);
            warn = new PrintStream(new BufferedOutputStream(rawWarn));
        }
        catch (Exception ex) {
            log = null;
            warn = null;
        }
        out = log;
        err = warn;
    }

    private static final class SystemStream
    extends OutputStream {
        private final String method;
        private final StringBuilder pending = new StringBuilder();
        private Runnable sendOK = new Runnable(){

            @Override
            public void run() {
                sendOK = null;
            }
        };

        public SystemStream(String method) {
            this.method = method;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            String line = new String(b, off, len, "UTF-8");
            this.pending.append(line);
            int lastLine = this.pending.lastIndexOf("\n");
            if (lastLine >= 0) {
                this.doWrite(this.pending.substring(0, lastLine));
                this.pending.delete(0, lastLine + 1);
            }
        }

        @Override
        public void close() throws IOException {
            this.doWrite(this.pending.toString());
            this.pending.setLength(0);
        }

        void doWrite(String line) {
            SystemStream.write(this.method, line);
            SystemStream.writeRemote(this.method, line, this.sendOK);
        }

        @JavaScriptBody(args={"method", "b"}, body="if (typeof console !== 'undefined') console[method](b.toString());")
        private static native void write(String var0, String var1);

        @JavaScriptBody(args={"method", "msg", "onFail"}, body="if (!onFail) {\n   return;\n}\nif (typeof XMLHttpRequest === 'undefined') {\n  onFail.run__V();\n  return;\n}\nvar xhttp = new XMLHttpRequest();\nvar safeMsg = encodeURIComponent(msg);\nxhttp.open('GET', '/console/' + method + '/?msg=' + safeMsg, true);\nxhttp.onreadystatechange = function () {\n  if (xhttp.status === 0 || xhttp.status > 400) {\n    onFail.run__V();\n  }\n};\nxhttp.send();\n")
        private static native void writeRemote(String var0, String var1, Runnable var2);

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }
    }

    public static interface Logger {
        public String getName();

        public boolean isLoggable(Level var1);

        public static enum Level {
            ALL(Integer.MIN_VALUE),
            TRACE(400),
            DEBUG(500),
            INFO(800),
            WARNING(900),
            ERROR(1000),
            OFF(Integer.MAX_VALUE);

            private final int severity;

            private Level(int severity) {
                this.severity = severity;
            }

            public final String getName() {
                return this.name();
            }

            public final int getSeverity() {
                return this.severity;
            }
        }
    }
}

