/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;

public class FileOutputStream
extends OutputStream {
    private final FileDescriptor fd;
    private final boolean append;
    private final Object closeLock = new Object();
    private volatile boolean closed = false;
    private static final ThreadLocal<Boolean> runningFinalize = new ThreadLocal();

    private static boolean isRunningFinalize() {
        Boolean val = runningFinalize.get();
        if (val != null) {
            return val;
        }
        return false;
    }

    public FileOutputStream(String name) throws FileNotFoundException {
        this(name != null ? new File(name) : null, false);
    }

    public FileOutputStream(String name, boolean append) throws FileNotFoundException {
        this(name != null ? new File(name) : null, append);
    }

    public FileOutputStream(File file) throws FileNotFoundException {
        this(file, false);
    }

    public FileOutputStream(File file, boolean append) throws FileNotFoundException {
        throw new SecurityException();
    }

    public FileOutputStream(FileDescriptor fdObj) {
        throw new SecurityException();
    }

    private native void open(String var1, boolean var2) throws FileNotFoundException;

    private native void write(int var1, boolean var2) throws IOException;

    @Override
    public void write(int b) throws IOException {
        this.write(b, this.append);
    }

    private native void writeBytes(byte[] var1, int var2, int var3, boolean var4) throws IOException;

    @Override
    public void write(byte[] b) throws IOException {
        this.writeBytes(b, 0, b.length, this.append);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeBytes(b, off, len, this.append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        int useCount = this.fd.decrementAndGetUseCount();
        if (useCount <= 0 || !FileOutputStream.isRunningFinalize()) {
            this.close0();
        }
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    protected void finalize() throws IOException {
        if (this.fd != null) {
            if (this.fd == FileDescriptor.out || this.fd == FileDescriptor.err) {
                this.flush();
            } else {
                runningFinalize.set(Boolean.TRUE);
                try {
                    this.close();
                }
                finally {
                    runningFinalize.set(Boolean.FALSE);
                }
            }
        }
    }

    private native void close0() throws IOException;

    private static native void initIDs();

    static {
        FileOutputStream.initIDs();
    }
}

