/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.bck2brwsr.launcher;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import org.apidesign.bck2brwsr.launcher.InvocationContext;

public abstract class Launcher {
    Launcher() {
    }

    public abstract void initialize() throws IOException;

    public abstract void shutdown() throws IOException;

    public InvocationContext createInvocation(Class<?> clazz, String method) {
        return new InvocationContext(this, clazz, method);
    }

    public static Launcher createJavaScript() {
        try {
            Class<?> c = Launcher.loadClass("org.apidesign.bck2brwsr.launcher.JSLauncher");
            return (Launcher)c.newInstance();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Please include org.apidesign.bck2brwsr:launcher.html dependency!", ex);
        }
    }

    public static Launcher createBrowser(String cmd) {
        return Launcher.createBrowser(cmd, null, null);
    }

    public static Launcher createBrowser(String cmd, ClassLoader classes, String startpage) {
        String msg = "Trying to create browser '" + cmd + "'";
        try {
            Class<?> c;
            if ("fxbrwsr".equals(cmd)) {
                msg = "Please include org.apidesign.bck2brwsr:launcher.fx dependency!";
                c = Launcher.loadClass("org.apidesign.bck2brwsr.launcher.FXBrwsrLauncher");
            } else {
                msg = "Please include org.apidesign.bck2brwsr:launcher.html dependency!";
                c = Launcher.loadClass("org.apidesign.bck2brwsr.launcher.Bck2BrwsrLauncher");
                if ("bck2brwsr".equals(cmd)) {
                    cmd = null;
                }
            }
            Constructor<?> cnstr = c.getConstructor(String.class);
            Launcher launcher = (Launcher)cnstr.newInstance(cmd);
            if (classes != null) {
                launcher.addClassLoader(classes);
            }
            launcher.rootPage(startpage);
            return launcher;
        }
        catch (Exception ex) {
            throw new IllegalStateException(msg, ex);
        }
    }

    public static Closeable showURL(ClassLoader classes, String startpage) throws IOException {
        return Launcher.showURL(null, classes, startpage);
    }

    public static Closeable showURL(String brwsr, ClassLoader classes, String startpage) throws IOException {
        Launcher l = Launcher.createBrowser(brwsr);
        l.addClassLoader(classes);
        l.showURL(startpage);
        return (Closeable)((Object)l);
    }

    public static Closeable showDir(String brwsr, File directory, ClassLoader classes, String startpage) throws IOException {
        Launcher l = Launcher.createBrowser(brwsr);
        if (classes != null) {
            l.addClassLoader(classes);
        }
        l.showDirectory(directory, startpage, classes != null);
        return (Closeable)((Object)l);
    }

    public static Closeable showDir(File directory, String startpage) throws IOException {
        return Launcher.showDir(null, directory, null, startpage);
    }

    abstract InvocationContext runMethod(InvocationContext var1) throws IOException;

    private static Class<?> loadClass(String cn) throws ClassNotFoundException {
        return Launcher.class.getClassLoader().loadClass(cn);
    }

    void showDirectory(File directory, String startpage, boolean addClasses) throws IOException {
        throw new UnsupportedOperationException();
    }

    void showURL(String startpage) throws IOException {
        throw new UnsupportedOperationException();
    }

    void addClassLoader(ClassLoader classes) {
        throw new UnsupportedOperationException();
    }

    void rootPage(String startpage) {
        throw new UnsupportedOperationException();
    }
}

