/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import org.apidesign.bck2brwsr.core.JavaScriptBody;

public abstract class AtomicLongFieldUpdater<T> {
    public static <U> AtomicLongFieldUpdater<U> newUpdater(Class<U> tclass, String fieldName) {
        return new Impl<U>(tclass, fieldName);
    }

    protected AtomicLongFieldUpdater() {
    }

    public abstract boolean compareAndSet(T var1, long var2, long var4);

    public abstract boolean weakCompareAndSet(T var1, long var2, long var4);

    public abstract void set(T var1, long var2);

    public abstract void lazySet(T var1, long var2);

    public abstract long get(T var1);

    public long getAndSet(T obj, long newValue) {
        long current;
        while (!this.compareAndSet(obj, current = this.get(obj), newValue)) {
        }
        return current;
    }

    public long getAndIncrement(T obj) {
        long next;
        long current;
        while (!this.compareAndSet(obj, current = this.get(obj), next = current + 1L)) {
        }
        return current;
    }

    public long getAndDecrement(T obj) {
        long next;
        long current;
        while (!this.compareAndSet(obj, current = this.get(obj), next = current - 1L)) {
        }
        return current;
    }

    public long getAndAdd(T obj, long delta) {
        long next;
        long current;
        while (!this.compareAndSet(obj, current = this.get(obj), next = current + delta)) {
        }
        return current;
    }

    public long incrementAndGet(T obj) {
        long next;
        long current;
        while (!this.compareAndSet(obj, current = this.get(obj), next = current + 1L)) {
        }
        return next;
    }

    public long decrementAndGet(T obj) {
        long next;
        long current;
        while (!this.compareAndSet(obj, current = this.get(obj), next = current - 1L)) {
        }
        return next;
    }

    public long addAndGet(T obj, long delta) {
        long next;
        long current;
        while (!this.compareAndSet(obj, current = this.get(obj), next = current + delta)) {
        }
        return next;
    }

    private static class Impl<T>
    extends AtomicLongFieldUpdater<T> {
        private final Object fn;
        private Class<T> tclass;
        private Object cclass;

        Impl(Class<T> tclass, Object fieldName) {
            if (!Impl.isFunction(fieldName)) {
                throw new SecurityException("Updater can be used only from own class!");
            }
            this.tclass = tclass;
            this.fn = fieldName;
        }

        @JavaScriptBody(args={"obj", "fn"}, body="return fn.call(obj);")
        private static native long get(Object var0, Object var1);

        @JavaScriptBody(args={"obj", "fn", "v"}, body="fn.call(obj, v);")
        private static native void set(Object var0, Object var1, long var2);

        @JavaScriptBody(args={"f"}, body="return typeof f === 'function';")
        private static native boolean isFunction(Object var0);

        private void fullCheck(T obj) {
            if (!this.tclass.isInstance(obj)) {
                throw new ClassCastException();
            }
        }

        @Override
        public boolean compareAndSet(T obj, long expect, long update) {
            long prev;
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            if ((prev = Impl.get(obj, this.fn)) == expect) {
                Impl.set(obj, this.fn, update);
                return true;
            }
            return false;
        }

        @Override
        public boolean weakCompareAndSet(T obj, long expect, long update) {
            return this.compareAndSet(obj, expect, update);
        }

        @Override
        public void set(T obj, long newValue) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            Impl.set(obj, this.fn, newValue);
        }

        @Override
        public void lazySet(T obj, long newValue) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            Impl.set(obj, this.fn, newValue);
        }

        @Override
        public final long get(T obj) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            return Impl.get(obj, this.fn);
        }
    }
}

