/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.concurrent.ForkJoinTask;

public abstract class CountedCompleter<T>
extends ForkJoinTask<T> {
    private static final long serialVersionUID = 5232453752276485070L;
    final CountedCompleter<?> completer;
    volatile int pending;

    protected CountedCompleter(CountedCompleter<?> completer, int initialPendingCount) {
        this.completer = completer;
        this.pending = initialPendingCount;
    }

    protected CountedCompleter(CountedCompleter<?> completer) {
        this.completer = completer;
    }

    protected CountedCompleter() {
        this.completer = null;
    }

    public abstract void compute();

    public void onCompletion(CountedCompleter<?> caller) {
    }

    public boolean onExceptionalCompletion(Throwable ex, CountedCompleter<?> caller) {
        return true;
    }

    public final CountedCompleter<?> getCompleter() {
        return this.completer;
    }

    public final int getPendingCount() {
        return this.pending;
    }

    public final void setPendingCount(int count) {
        this.pending = count;
    }

    public final void addToPendingCount(int delta) {
        this.pending += delta;
    }

    public final boolean compareAndSetPendingCount(int expected, int count) {
        if (expected == this.pending) {
            this.pending = count;
            return true;
        }
        return false;
    }

    public final int decrementPendingCountUnlessZero() {
        int c;
        if ((c = this.pending--) != 0) {
            // empty if block
        }
        return c;
    }

    public final CountedCompleter<?> getRoot() {
        CountedCompleter<?> p;
        CountedCompleter<?> a = this;
        while ((p = a.completer) != null) {
            a = p;
        }
        return a;
    }

    public final void tryComplete() {
        CountedCompleter<?> a;
        CountedCompleter<?> s = a = this;
        while (true) {
            int c;
            if ((c = a.pending) == 0) {
                a.onCompletion(s);
                s = a;
                a = s.completer;
                if (a != null) continue;
                s.quietlyComplete();
                return;
            }
            if (this.pending == c) break;
        }
        --this.pending;
    }

    public final void propagateCompletion() {
        CountedCompleter<?> a;
        CountedCompleter<?> s = a = this;
        while (true) {
            int c;
            if ((c = a.pending) == 0) {
                s = a;
                a = s.completer;
                if (a != null) continue;
                s.quietlyComplete();
                return;
            }
            if (this.pending == c) break;
        }
        --this.pending;
    }

    @Override
    public void complete(T rawResult) {
        this.setRawResult(rawResult);
        this.onCompletion(this);
        this.quietlyComplete();
        CountedCompleter<?> p = this.completer;
        if (p != null) {
            p.tryComplete();
        }
    }

    public final CountedCompleter<?> firstComplete() {
        int c;
        do {
            if ((c = this.pending) != 0) continue;
            return this;
        } while (this.pending != c);
        --this.pending;
        return null;
    }

    public final CountedCompleter<?> nextComplete() {
        CountedCompleter<?> p = this.completer;
        if (p != null) {
            return p.firstComplete();
        }
        this.quietlyComplete();
        return null;
    }

    public final void quietlyCompleteRoot() {
        CountedCompleter<?> a = this;
        while (true) {
            CountedCompleter<?> p;
            if ((p = a.completer) == null) {
                a.quietlyComplete();
                return;
            }
            a = p;
        }
    }

    public final void helpComplete(int maxTasks) {
    }

    void internalPropagateException(Throwable ex) {
        CountedCompleter<?> a;
        CountedCompleter<?> s = a = this;
        while (a.onExceptionalCompletion(ex, s)) {
            s = a;
            a = s.completer;
            if (a != null && a.status >= 0 && a.recordExceptionalCompletion(ex) == -3) continue;
        }
    }

    @Override
    protected final boolean exec() {
        this.compute();
        return false;
    }

    @Override
    public T getRawResult() {
        return null;
    }

    @Override
    protected void setRawResult(T t) {
    }
}

