/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;

public final class ServiceLoader<S>
implements Iterable<S> {
    private static final String PREFIX = "META-INF/services/";
    private Class<S> service;
    private ClassLoader loader;
    private Providers providers = new Providers<Object>(null, null);
    private LazyIterator lookupIterator;

    public void reload() {
        this.providers.clear();
        this.lookupIterator = new LazyIterator(this.service, this.loader);
    }

    private ServiceLoader(Class<S> svc, ClassLoader cl) {
        this.service = svc;
        this.loader = cl;
        this.reload();
    }

    private static void fail(Class service, String msg, Throwable cause) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg, cause);
    }

    private static void fail(Class service, String msg) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg);
    }

    private static void fail(Class service, URL u, int line, String msg) throws ServiceConfigurationError {
        ServiceLoader.fail(service, u + ":" + line + ": " + msg);
    }

    private static String readLine(InputStream is) throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = is.read()) != -1 && ch != 10) {
            sb.append((char)ch);
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    private int parseLine(Class service, URL u, InputStream r, int lc, Names names) throws IOException, ServiceConfigurationError {
        int n;
        String ln = ServiceLoader.readLine(r);
        if (ln == null) {
            return -1;
        }
        int ci = ln.indexOf(35);
        if (ci >= 0) {
            ln = ln.substring(0, ci);
        }
        if ((n = (ln = ln.trim()).length()) != 0) {
            int cp;
            if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                ServiceLoader.fail(service, u, lc, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(cp = ln.codePointAt(0))) {
                ServiceLoader.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                cp = ln.codePointAt(i);
                if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                ServiceLoader.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            if (!this.providers.containsKey(ln)) {
                names.addIfMissing(ln);
            }
        }
        return lc + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Names parse(Class service, URL u) throws ServiceConfigurationError {
        InputStream in = null;
        Names names = new Names(null);
        try {
            in = u.openStream();
            int lc = 1;
            while ((lc = this.parseLine(service, u, in, lc, names)) >= 0) {
            }
        }
        catch (IOException x) {
            ServiceLoader.fail(service, "Error reading configuration file", x);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException y) {
                ServiceLoader.fail(service, "Error closing configuration file", y);
            }
        }
        return names.next;
    }

    @Override
    public Iterator<S> iterator() {
        return new Iterator<S>(){
            Providers knownProviders;
            {
                this.knownProviders = ServiceLoader.this.providers.next();
            }

            @Override
            public boolean hasNext() {
                if (this.knownProviders != null) {
                    return true;
                }
                return ServiceLoader.this.lookupIterator.hasNext();
            }

            @Override
            public S next() {
                if (this.knownProviders != null) {
                    Providers p = this.knownProviders;
                    this.knownProviders = this.knownProviders.next();
                    return p.service;
                }
                return ServiceLoader.this.lookupIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <S> ServiceLoader<S> load(Class<S> service, ClassLoader loader) {
        return new ServiceLoader<S>(service, loader);
    }

    public static <S> ServiceLoader<S> load(Class<S> service) {
        ClassLoader cl = null;
        return ServiceLoader.load(service, cl);
    }

    public static <S> ServiceLoader<S> loadInstalled(Class<S> service) {
        ClassLoader prev = null;
        for (ClassLoader cl = ClassLoader.getSystemClassLoader(); cl != null; cl = cl.getParent()) {
            prev = cl;
        }
        return ServiceLoader.load(service, prev);
    }

    public String toString() {
        return "java.util.ServiceLoader[" + this.service.getName() + "]";
    }

    private class LazyIterator
    implements Iterator<S> {
        Class<S> service;
        ClassLoader loader;
        Enumeration<URL> configs = null;
        Names pending = null;
        String nextName = null;

        private LazyIterator(Class<S> service, ClassLoader loader) {
            this.service = service;
            this.loader = loader;
        }

        @Override
        public boolean hasNext() {
            if (this.nextName != null) {
                return true;
            }
            if (this.configs == null) {
                try {
                    String fullName = ServiceLoader.PREFIX + this.service.getName();
                    this.configs = this.loader == null ? ClassLoader.getSystemResources(fullName) : this.loader.getResources(fullName);
                }
                catch (IOException x) {
                    ServiceLoader.fail(this.service, "Error locating configuration files", x);
                }
            }
            while (this.pending == null) {
                if (!this.configs.hasMoreElements()) {
                    return false;
                }
                this.pending = ServiceLoader.this.parse(this.service, this.configs.nextElement());
            }
            this.nextName = this.pending.name;
            this.pending = this.pending.next;
            return true;
        }

        @Override
        public S next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String cn = this.nextName;
            this.nextName = null;
            try {
                Object p = this.service.cast(Class.forName(cn, true, this.loader).newInstance());
                ServiceLoader.this.providers.put(cn, p);
                return p;
            }
            catch (ClassNotFoundException x) {
                ServiceLoader.fail(this.service, "Provider " + cn + " not found");
            }
            catch (Throwable x) {
                ServiceLoader.fail(this.service, "Provider " + cn + " could not be instantiated: " + x, x);
            }
            throw new Error();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Providers<S> {
        private Providers<S> next;
        private final String name;
        final S service;

        Providers(String name, S service) {
            this.name = name;
            this.service = service;
        }

        void clear() {
            this.next = null;
        }

        boolean containsKey(String ln) {
            Providers<S> p = this.next;
            while (p != null) {
                if (p.name.equals(ln)) {
                    return true;
                }
                p = p.next;
            }
            return false;
        }

        void put(String cn, S obj) {
            Providers<S> p = this;
            while (p.next != null) {
                p = p.next;
            }
            p.next = new Providers<S>(cn, obj);
        }

        Providers next() {
            return this.next;
        }
    }

    private static class Names {
        private final String name;
        private Names next;

        Names(String name) {
            this.name = name;
        }

        void addIfMissing(String ln) {
            Names n = this;
            while (!ln.equals(n.name)) {
                if (n.next == null) {
                    n.next = new Names(ln);
                    return;
                }
                n = n.next;
            }
            return;
        }
    }
}

