/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.apidesign.bck2brwsr.core.JavaScriptBody;
import org.apidesign.bck2brwsr.emul.reflect.MethodImpl;
import org.apidesign.bck2brwsr.emul.reflect.TypeProvider;

public final class Constructor<T>
extends AccessibleObject
implements GenericDeclaration,
Member {
    private final Class<T> clazz;
    private final Object data;
    private final String sig;

    Constructor(Class<T> declaringClass, Object data, String sig) {
        this.clazz = declaringClass;
        this.data = data;
        this.sig = sig;
    }

    Constructor<T> copy() {
        return this;
    }

    public Class<T> getDeclaringClass() {
        return this.clazz;
    }

    @Override
    public String getName() {
        return this.getDeclaringClass().getName();
    }

    @Override
    public int getModifiers() {
        return Method.getAccess(this.data);
    }

    public TypeVariable<Constructor<T>>[] getTypeParameters() {
        return TypeProvider.getDefault().getTypeParameters(this);
    }

    public Class<?>[] getParameterTypes() {
        return Method.getParameterTypes(this.sig);
    }

    public Type[] getGenericParameterTypes() {
        return TypeProvider.getDefault().getGenericParameterTypes(this);
    }

    public Class<?>[] getExceptionTypes() {
        return new Class[0];
    }

    public Type[] getGenericExceptionTypes() {
        return TypeProvider.getDefault().getGenericExceptionTypes(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Constructor) {
            Constructor other = (Constructor)obj;
            return this.data == other.data;
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode();
    }

    public String toString() {
        try {
            StringBuffer sb = new StringBuffer();
            int mod = this.getModifiers() & Modifier.constructorModifiers();
            if (mod != 0) {
                sb.append(Modifier.toString(mod) + " ");
            }
            sb.append(Field.getTypeName(this.getDeclaringClass()));
            sb.append("(");
            Class<?>[] params = this.getParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                sb.append(Field.getTypeName(params[j]));
                if (j >= params.length - 1) continue;
                sb.append(",");
            }
            sb.append(")");
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    public String toGenericString() {
        try {
            TypeVariable<Constructor<T>>[] typeparms;
            StringBuilder sb = new StringBuilder();
            int mod = this.getModifiers() & Modifier.constructorModifiers();
            if (mod != 0) {
                sb.append(Modifier.toString(mod) + " ");
            }
            if ((typeparms = this.getTypeParameters()).length > 0) {
                boolean first = true;
                sb.append("<");
                for (TypeVariable<Constructor<T>> typeparm : typeparms) {
                    if (!first) {
                        sb.append(",");
                    }
                    sb.append(typeparm.toString());
                    first = false;
                }
                sb.append("> ");
            }
            sb.append(Field.getTypeName(this.getDeclaringClass()));
            sb.append("(");
            Type[] params = this.getGenericParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                String param;
                String string = param = params[j] instanceof Class ? Field.getTypeName((Class)params[j]) : params[j].toString();
                if (this.isVarArgs() && j == params.length - 1) {
                    param = param.replaceFirst("\\[\\]$", "...");
                }
                sb.append(param);
                if (j >= params.length - 1) continue;
                sb.append(",");
            }
            sb.append(")");
            Type[] exceptions = this.getGenericExceptionTypes();
            if (exceptions.length > 0) {
                sb.append(" throws ");
                for (int k = 0; k < exceptions.length; ++k) {
                    sb.append(exceptions[k] instanceof Class ? ((Class)exceptions[k]).getName() : exceptions[k].toString());
                    if (k >= exceptions.length - 1) continue;
                    sb.append(",");
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    public T newInstance(Object ... initargs) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?>[] types = this.getParameterTypes();
        if (types.length != initargs.length) {
            throw new IllegalArgumentException("Types len " + types.length + " args: " + initargs.length);
        }
        initargs = (Object[])initargs.clone();
        for (int i = 0; i < types.length; ++i) {
            Class<?> c = types[i];
            if (!c.isPrimitive() || initargs[i] == null) continue;
            initargs[i] = MethodImpl.toPrimitive(initargs[i]);
        }
        return (T)Constructor.newInstance0(this.getDeclaringClass(), "cons__" + this.sig, initargs);
    }

    @JavaScriptBody(args={"self", "sig", "args"}, body="\nvar c = self.cnstr;\nvar inst = c();\nc[sig].apply(inst, args);\nreturn inst;")
    private static native Object newInstance0(Class<?> var0, String var1, Object[] var2);

    public boolean isVarArgs() {
        return (this.getModifiers() & 0x80) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return Modifier.isSynthetic(this.getModifiers());
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException();
        }
        return null;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return new Annotation[0];
    }

    public Annotation[][] getParameterAnnotations() {
        return new Annotation[0][0];
    }
}

