/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class ObjectStreamClass
implements Serializable {
    public static final ObjectStreamField[] NO_FIELDS = new ObjectStreamField[0];
    private static final long serialVersionUID = -6120832682080437368L;
    private static final ObjectStreamField[] serialPersistentFields = NO_FIELDS;
    private Class<?> cl;
    private String name;
    private volatile Long suid;
    private boolean isProxy;
    private boolean isEnum;
    private boolean serializable;
    private boolean externalizable;
    private boolean hasWriteObjectData;
    private boolean hasBlockExternalData = true;
    private ClassNotFoundException resolveEx;
    private InvalidClassException deserializeEx;
    private InvalidClassException serializeEx;
    private InvalidClassException defaultSerializeEx;
    private ObjectStreamField[] fields;
    private int primDataSize;
    private int numObjFields;
    private volatile ClassDataSlot[] dataLayout;
    private Constructor cons;
    private Method writeObjectMethod;
    private Method readObjectMethod;
    private Method readObjectNoDataMethod;
    private Method writeReplaceMethod;
    private Method readResolveMethod;
    private ObjectStreamClass localDesc;
    private ObjectStreamClass superDesc;

    private static native void initNative();

    public static ObjectStreamClass lookup(Class<?> cl) {
        return ObjectStreamClass.lookup(cl, false);
    }

    public static ObjectStreamClass lookupAny(Class<?> cl) {
        return ObjectStreamClass.lookup(cl, true);
    }

    public String getName() {
        return this.name;
    }

    public long getSerialVersionUID() {
        if (this.suid == null) {
            return ObjectStreamClass.computeDefaultSUID(this.cl);
        }
        return this.suid;
    }

    public Class<?> forClass() {
        return this.cl;
    }

    public ObjectStreamField[] getFields() {
        return this.getFields(true);
    }

    public ObjectStreamField getField(String name) {
        return this.getField(name, null);
    }

    public String toString() {
        return this.name + ": static final long serialVersionUID = " + this.getSerialVersionUID() + "L;";
    }

    static ObjectStreamClass lookup(Class<?> cl, boolean all) {
        if (!all && !Serializable.class.isAssignableFrom(cl)) {
            return null;
        }
        Object entry = null;
        EntryFuture future = null;
        if (entry == null) {
            EntryFuture newEntry = new EntryFuture();
            SoftReference<EntryFuture> newRef = new SoftReference<EntryFuture>(newEntry);
            if (entry == null) {
                future = newEntry;
            }
        }
        if (entry instanceof ObjectStreamClass) {
            return (ObjectStreamClass)entry;
        }
        if (entry instanceof EntryFuture) {
            future = (EntryFuture)entry;
            entry = null;
        }
        if (entry == null) {
            try {
                entry = new ObjectStreamClass(cl);
            }
            catch (Throwable th) {
                entry = th;
            }
            entry = future.get();
        }
        if (entry instanceof ObjectStreamClass) {
            return (ObjectStreamClass)entry;
        }
        if (entry instanceof RuntimeException) {
            throw (RuntimeException)entry;
        }
        if (entry instanceof Error) {
            throw (Error)entry;
        }
        throw new InternalError("unexpected entry: " + entry);
    }

    private ObjectStreamClass(Class<?> cl) {
        this.cl = cl;
        this.name = cl.getName();
        this.isProxy = Proxy.isProxyClass(cl);
        this.isEnum = Enum.class.isAssignableFrom(cl);
        this.serializable = Serializable.class.isAssignableFrom(cl);
        this.externalizable = Externalizable.class.isAssignableFrom(cl);
        Class<?> superCl = cl.getSuperclass();
        this.superDesc = superCl != null ? ObjectStreamClass.lookup(superCl, false) : null;
        this.localDesc = this;
        this.suid = 0L;
        this.fields = NO_FIELDS;
        if (this.deserializeEx == null) {
            if (this.isEnum) {
                this.deserializeEx = new InvalidClassException(this.name, "enum type");
            } else if (this.cons == null) {
                this.deserializeEx = new InvalidClassException(this.name, "no valid constructor");
            }
        }
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i].getField() != null) continue;
            this.defaultSerializeEx = new InvalidClassException(this.name, "unmatched serializable field(s) declared");
        }
    }

    ObjectStreamClass() {
    }

    void initProxy(Class<?> cl, ClassNotFoundException resolveEx, ObjectStreamClass superDesc) throws InvalidClassException {
        this.cl = cl;
        this.resolveEx = resolveEx;
        this.superDesc = superDesc;
        this.isProxy = true;
        this.serializable = true;
        this.suid = 0L;
        this.fields = NO_FIELDS;
        if (cl != null) {
            this.localDesc = ObjectStreamClass.lookup(cl, true);
            if (!this.localDesc.isProxy) {
                throw new InvalidClassException("cannot bind proxy descriptor to a non-proxy class");
            }
            this.name = this.localDesc.name;
            this.externalizable = this.localDesc.externalizable;
            this.cons = this.localDesc.cons;
            this.writeReplaceMethod = this.localDesc.writeReplaceMethod;
            this.readResolveMethod = this.localDesc.readResolveMethod;
            this.deserializeEx = this.localDesc.deserializeEx;
        }
    }

    void initNonProxy(ObjectStreamClass model, Class<?> cl, ClassNotFoundException resolveEx, ObjectStreamClass superDesc) throws InvalidClassException {
        this.cl = cl;
        this.resolveEx = resolveEx;
        this.superDesc = superDesc;
        this.name = model.name;
        this.suid = model.getSerialVersionUID();
        this.isProxy = false;
        this.isEnum = model.isEnum;
        this.serializable = model.serializable;
        this.externalizable = model.externalizable;
        this.hasBlockExternalData = model.hasBlockExternalData;
        this.hasWriteObjectData = model.hasWriteObjectData;
        this.fields = model.fields;
        this.primDataSize = model.primDataSize;
        this.numObjFields = model.numObjFields;
        if (cl != null) {
            this.localDesc = ObjectStreamClass.lookup(cl, true);
            if (this.localDesc.isProxy) {
                throw new InvalidClassException("cannot bind non-proxy descriptor to a proxy class");
            }
            if (this.isEnum != this.localDesc.isEnum) {
                throw new InvalidClassException(this.isEnum ? "cannot bind enum descriptor to a non-enum class" : "cannot bind non-enum descriptor to an enum class");
            }
            if (this.serializable == this.localDesc.serializable && !cl.isArray() && this.suid.longValue() != this.localDesc.getSerialVersionUID()) {
                throw new InvalidClassException(this.localDesc.name, "local class incompatible: stream classdesc serialVersionUID = " + this.suid + ", local class serialVersionUID = " + this.localDesc.getSerialVersionUID());
            }
            if (!ObjectStreamClass.classNamesEqual(this.name, this.localDesc.name)) {
                throw new InvalidClassException(this.localDesc.name, "local class name incompatible with stream class name \"" + this.name + "\"");
            }
            if (!this.isEnum) {
                if (this.serializable == this.localDesc.serializable && this.externalizable != this.localDesc.externalizable) {
                    throw new InvalidClassException(this.localDesc.name, "Serializable incompatible with Externalizable");
                }
                if (this.serializable != this.localDesc.serializable || this.externalizable != this.localDesc.externalizable || !this.serializable && !this.externalizable) {
                    this.deserializeEx = new InvalidClassException(this.localDesc.name, "class invalid for deserialization");
                }
            }
            this.cons = this.localDesc.cons;
            this.writeObjectMethod = this.localDesc.writeObjectMethod;
            this.readObjectMethod = this.localDesc.readObjectMethod;
            this.readObjectNoDataMethod = this.localDesc.readObjectNoDataMethod;
            this.writeReplaceMethod = this.localDesc.writeReplaceMethod;
            this.readResolveMethod = this.localDesc.readResolveMethod;
            if (this.deserializeEx == null) {
                this.deserializeEx = this.localDesc.deserializeEx;
            }
        }
        this.fields = null;
    }

    void readNonProxy(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean sflag;
        this.name = in.readUTF();
        this.suid = in.readLong();
        this.isProxy = false;
        byte flags = in.readByte();
        this.hasWriteObjectData = (flags & 1) != 0;
        this.hasBlockExternalData = (flags & 8) != 0;
        this.externalizable = (flags & 4) != 0;
        boolean bl = sflag = (flags & 2) != 0;
        if (this.externalizable && sflag) {
            throw new InvalidClassException(this.name, "serializable and externalizable flags conflict");
        }
        this.serializable = this.externalizable || sflag;
        boolean bl2 = this.isEnum = (flags & 0x10) != 0;
        if (this.isEnum && this.suid != 0L) {
            throw new InvalidClassException(this.name, "enum descriptor has non-zero serialVersionUID: " + this.suid);
        }
        int numFields = in.readShort();
        if (this.isEnum && numFields != 0) {
            throw new InvalidClassException(this.name, "enum descriptor has non-zero field count: " + numFields);
        }
        this.fields = numFields > 0 ? new ObjectStreamField[numFields] : NO_FIELDS;
        for (int i = 0; i < numFields; ++i) {
            char tcode = (char)in.readByte();
            String fname = in.readUTF();
            String signature = tcode == 'L' || tcode == '[' ? in.readTypeString() : new String(new char[]{tcode});
            try {
                this.fields[i] = new ObjectStreamField(fname, signature, false);
                continue;
            }
            catch (RuntimeException e) {
                throw (IOException)new InvalidClassException(this.name, "invalid descriptor for field " + fname).initCause(e);
            }
        }
        this.computeFieldOffsets();
    }

    void writeNonProxy(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.name);
        out.writeLong(this.getSerialVersionUID());
        int flags = 0;
        if (this.externalizable) {
            flags = (byte)(flags | 4);
            int protocol = out.getProtocolVersion();
            if (protocol != 1) {
                flags = (byte)(flags | 8);
            }
        } else if (this.serializable) {
            flags = (byte)(flags | 2);
        }
        if (this.hasWriteObjectData) {
            flags = (byte)(flags | 1);
        }
        if (this.isEnum) {
            flags = (byte)(flags | 0x10);
        }
        out.writeByte(flags);
        out.writeShort(this.fields.length);
        for (int i = 0; i < this.fields.length; ++i) {
            ObjectStreamField f = this.fields[i];
            out.writeByte(f.getTypeCode());
            out.writeUTF(f.getName());
            if (f.isPrimitive()) continue;
            out.writeTypeString(f.getTypeString());
        }
    }

    ClassNotFoundException getResolveException() {
        return this.resolveEx;
    }

    void checkDeserialize() throws InvalidClassException {
        if (this.deserializeEx != null) {
            InvalidClassException ice = new InvalidClassException(this.deserializeEx.classname, this.deserializeEx.getMessage());
            ice.initCause(this.deserializeEx);
            throw ice;
        }
    }

    void checkSerialize() throws InvalidClassException {
        if (this.serializeEx != null) {
            InvalidClassException ice = new InvalidClassException(this.serializeEx.classname, this.serializeEx.getMessage());
            ice.initCause(this.serializeEx);
            throw ice;
        }
    }

    void checkDefaultSerialize() throws InvalidClassException {
        if (this.defaultSerializeEx != null) {
            InvalidClassException ice = new InvalidClassException(this.defaultSerializeEx.classname, this.defaultSerializeEx.getMessage());
            ice.initCause(this.defaultSerializeEx);
            throw ice;
        }
    }

    ObjectStreamClass getSuperDesc() {
        return this.superDesc;
    }

    ObjectStreamClass getLocalDesc() {
        return this.localDesc;
    }

    ObjectStreamField[] getFields(boolean copy) {
        return copy ? (ObjectStreamField[])this.fields.clone() : this.fields;
    }

    ObjectStreamField getField(String name, Class<?> type) {
        for (int i = 0; i < this.fields.length; ++i) {
            ObjectStreamField f = this.fields[i];
            if (!f.getName().equals(name)) continue;
            if (type == null || type == Object.class && !f.isPrimitive()) {
                return f;
            }
            Class<?> ftype = f.getType();
            if (ftype == null || !type.isAssignableFrom(ftype)) continue;
            return f;
        }
        return null;
    }

    boolean isProxy() {
        return this.isProxy;
    }

    boolean isEnum() {
        return this.isEnum;
    }

    boolean isExternalizable() {
        return this.externalizable;
    }

    boolean isSerializable() {
        return this.serializable;
    }

    boolean hasBlockExternalData() {
        return this.hasBlockExternalData;
    }

    boolean hasWriteObjectData() {
        return this.hasWriteObjectData;
    }

    boolean isInstantiable() {
        return this.cons != null;
    }

    boolean hasWriteObjectMethod() {
        return this.writeObjectMethod != null;
    }

    boolean hasReadObjectMethod() {
        return this.readObjectMethod != null;
    }

    boolean hasReadObjectNoDataMethod() {
        return this.readObjectNoDataMethod != null;
    }

    boolean hasWriteReplaceMethod() {
        return this.writeReplaceMethod != null;
    }

    boolean hasReadResolveMethod() {
        return this.readResolveMethod != null;
    }

    Object newInstance() throws InstantiationException, InvocationTargetException, UnsupportedOperationException {
        if (this.cons != null) {
            try {
                return this.cons.newInstance(new Object[0]);
            }
            catch (IllegalAccessException ex) {
                throw new InternalError();
            }
        }
        throw new UnsupportedOperationException();
    }

    void invokeWriteObject(Object obj, ObjectOutputStream out) throws IOException, UnsupportedOperationException {
        if (this.writeObjectMethod != null) {
            try {
                this.writeObjectMethod.invoke(obj, out);
            }
            catch (InvocationTargetException ex) {
                Throwable th = ex.getTargetException();
                if (th instanceof IOException) {
                    throw (IOException)th;
                }
                ObjectStreamClass.throwMiscException(th);
            }
            catch (IllegalAccessException ex) {
                throw new InternalError();
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    void invokeReadObject(Object obj, ObjectInputStream in) throws ClassNotFoundException, IOException, UnsupportedOperationException {
        if (this.readObjectMethod != null) {
            try {
                this.readObjectMethod.invoke(obj, in);
            }
            catch (InvocationTargetException ex) {
                Throwable th = ex.getTargetException();
                if (th instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)th;
                }
                if (th instanceof IOException) {
                    throw (IOException)th;
                }
                ObjectStreamClass.throwMiscException(th);
            }
            catch (IllegalAccessException ex) {
                throw new InternalError();
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    void invokeReadObjectNoData(Object obj) throws IOException, UnsupportedOperationException {
        if (this.readObjectNoDataMethod != null) {
            try {
                this.readObjectNoDataMethod.invoke(obj, null);
            }
            catch (InvocationTargetException ex) {
                Throwable th = ex.getTargetException();
                if (th instanceof ObjectStreamException) {
                    throw (ObjectStreamException)th;
                }
                ObjectStreamClass.throwMiscException(th);
            }
            catch (IllegalAccessException ex) {
                throw new InternalError();
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    Object invokeWriteReplace(Object obj) throws IOException, UnsupportedOperationException {
        if (this.writeReplaceMethod != null) {
            try {
                return this.writeReplaceMethod.invoke(obj, null);
            }
            catch (InvocationTargetException ex) {
                Throwable th = ex.getTargetException();
                if (th instanceof ObjectStreamException) {
                    throw (ObjectStreamException)th;
                }
                ObjectStreamClass.throwMiscException(th);
                throw new InternalError();
            }
            catch (IllegalAccessException ex) {
                throw new InternalError();
            }
        }
        throw new UnsupportedOperationException();
    }

    Object invokeReadResolve(Object obj) throws IOException, UnsupportedOperationException {
        if (this.readResolveMethod != null) {
            try {
                return this.readResolveMethod.invoke(obj, null);
            }
            catch (InvocationTargetException ex) {
                Throwable th = ex.getTargetException();
                if (th instanceof ObjectStreamException) {
                    throw (ObjectStreamException)th;
                }
                ObjectStreamClass.throwMiscException(th);
                throw new InternalError();
            }
            catch (IllegalAccessException ex) {
                throw new InternalError();
            }
        }
        throw new UnsupportedOperationException();
    }

    ClassDataSlot[] getClassDataLayout() throws InvalidClassException {
        if (this.dataLayout == null) {
            this.dataLayout = this.getClassDataLayout0();
        }
        return this.dataLayout;
    }

    private ClassDataSlot[] getClassDataLayout0() throws InvalidClassException {
        Class<?> end;
        ArrayList<ClassDataSlot> slots = new ArrayList<ClassDataSlot>();
        Class<?> start = this.cl;
        for (end = this.cl; end != null && Serializable.class.isAssignableFrom(end); end = end.getSuperclass()) {
        }
        ObjectStreamClass d = this;
        while (d != null) {
            Class<?> c;
            String searchName = d.cl != null ? d.cl.getName() : d.name;
            Class<?> match = null;
            for (c = start; c != end; c = c.getSuperclass()) {
                if (!searchName.equals(c.getName())) continue;
                match = c;
                break;
            }
            if (match != null) {
                for (c = start; c != match; c = c.getSuperclass()) {
                    slots.add(new ClassDataSlot(ObjectStreamClass.lookup(c, true), false));
                }
                start = match.getSuperclass();
            }
            slots.add(new ClassDataSlot(d.getVariantFor(match), true));
            d = d.superDesc;
        }
        for (Class<?> c = start; c != end; c = c.getSuperclass()) {
            slots.add(new ClassDataSlot(ObjectStreamClass.lookup(c, true), false));
        }
        Collections.reverse(slots);
        return slots.toArray(new ClassDataSlot[slots.size()]);
    }

    int getPrimDataSize() {
        return this.primDataSize;
    }

    int getNumObjFields() {
        return this.numObjFields;
    }

    void getPrimFieldValues(Object obj, byte[] buf) {
    }

    void setPrimFieldValues(Object obj, byte[] buf) {
    }

    void getObjFieldValues(Object obj, Object[] vals) {
    }

    void setObjFieldValues(Object obj, Object[] vals) {
    }

    private void computeFieldOffsets() throws InvalidClassException {
        this.primDataSize = 0;
        this.numObjFields = 0;
        int firstObjIndex = -1;
        block7: for (int i = 0; i < this.fields.length; ++i) {
            ObjectStreamField f = this.fields[i];
            switch (f.getTypeCode()) {
                case 'B': 
                case 'Z': {
                    f.setOffset(this.primDataSize++);
                    continue block7;
                }
                case 'C': 
                case 'S': {
                    f.setOffset(this.primDataSize);
                    this.primDataSize += 2;
                    continue block7;
                }
                case 'F': 
                case 'I': {
                    f.setOffset(this.primDataSize);
                    this.primDataSize += 4;
                    continue block7;
                }
                case 'D': 
                case 'J': {
                    f.setOffset(this.primDataSize);
                    this.primDataSize += 8;
                    continue block7;
                }
                case 'L': 
                case '[': {
                    f.setOffset(this.numObjFields++);
                    if (firstObjIndex != -1) continue block7;
                    firstObjIndex = i;
                    continue block7;
                }
                default: {
                    throw new InternalError();
                }
            }
        }
        if (firstObjIndex != -1 && firstObjIndex + this.numObjFields != this.fields.length) {
            throw new InvalidClassException(this.name, "illegal field order");
        }
    }

    private ObjectStreamClass getVariantFor(Class<?> cl) throws InvalidClassException {
        if (this.cl == cl) {
            return this;
        }
        ObjectStreamClass desc = new ObjectStreamClass();
        if (this.isProxy) {
            desc.initProxy(cl, null, this.superDesc);
        } else {
            desc.initNonProxy(this, cl, null, this.superDesc);
        }
        return desc;
    }

    private static Constructor getExternalizableConstructor(Class<?> cl) {
        throw new SecurityException();
    }

    private static Constructor getSerializableConstructor(Class<?> cl) {
        Class<?> initCl = cl;
        while (Serializable.class.isAssignableFrom(initCl)) {
            if ((initCl = initCl.getSuperclass()) != null) continue;
            return null;
        }
        throw new SecurityException();
    }

    private static Method getInheritableMethod(Class<?> cl, String name, Class<?>[] argTypes, Class<?> returnType) {
        throw new SecurityException();
    }

    private static Method getPrivateMethod(Class<?> cl, String name, Class<?>[] argTypes, Class<?> returnType) {
        throw new SecurityException();
    }

    private static boolean packageEquals(Class<?> cl1, Class<?> cl2) {
        return cl1.getClassLoader() == cl2.getClassLoader() && ObjectStreamClass.getPackageName(cl1).equals(ObjectStreamClass.getPackageName(cl2));
    }

    private static String getPackageName(Class<?> cl) {
        String s = cl.getName();
        int i = s.lastIndexOf(91);
        if (i >= 0) {
            s = s.substring(i + 2);
        }
        return (i = s.lastIndexOf(46)) >= 0 ? s.substring(0, i) : "";
    }

    private static boolean classNamesEqual(String name1, String name2) {
        name1 = name1.substring(name1.lastIndexOf(46) + 1);
        name2 = name2.substring(name2.lastIndexOf(46) + 1);
        return name1.equals(name2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getClassSignature(Class<?> cl) {
        StringBuilder sbuf = new StringBuilder();
        while (cl.isArray()) {
            sbuf.append('[');
            cl = cl.getComponentType();
        }
        if (cl.isPrimitive()) {
            if (cl == Integer.TYPE) {
                sbuf.append('I');
                return sbuf.toString();
            } else if (cl == Byte.TYPE) {
                sbuf.append('B');
                return sbuf.toString();
            } else if (cl == Long.TYPE) {
                sbuf.append('J');
                return sbuf.toString();
            } else if (cl == Float.TYPE) {
                sbuf.append('F');
                return sbuf.toString();
            } else if (cl == Double.TYPE) {
                sbuf.append('D');
                return sbuf.toString();
            } else if (cl == Short.TYPE) {
                sbuf.append('S');
                return sbuf.toString();
            } else if (cl == Character.TYPE) {
                sbuf.append('C');
                return sbuf.toString();
            } else if (cl == Boolean.TYPE) {
                sbuf.append('Z');
                return sbuf.toString();
            } else {
                if (cl != Void.TYPE) throw new InternalError();
                sbuf.append('V');
            }
            return sbuf.toString();
        } else {
            sbuf.append('L' + cl.getName().replace('.', '/') + ';');
        }
        return sbuf.toString();
    }

    private static String getMethodSignature(Class<?>[] paramTypes, Class<?> retType) {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append('(');
        for (int i = 0; i < paramTypes.length; ++i) {
            sbuf.append(ObjectStreamClass.getClassSignature(paramTypes[i]));
        }
        sbuf.append(')');
        sbuf.append(ObjectStreamClass.getClassSignature(retType));
        return sbuf.toString();
    }

    private static void throwMiscException(Throwable th) throws IOException {
        if (th instanceof RuntimeException) {
            throw (RuntimeException)th;
        }
        if (th instanceof Error) {
            throw (Error)th;
        }
        IOException ex = new IOException("unexpected exception type");
        ex.initCause(th);
        throw ex;
    }

    private static ObjectStreamField[] getSerialFields(Class<?> cl) throws InvalidClassException {
        Object[] fields;
        if (Serializable.class.isAssignableFrom(cl) && !Externalizable.class.isAssignableFrom(cl) && !Proxy.isProxyClass(cl) && !cl.isInterface()) {
            fields = ObjectStreamClass.getDeclaredSerialFields(cl);
            if (fields == null) {
                fields = ObjectStreamClass.getDefaultSerialFields(cl);
            }
            Arrays.sort(fields);
        } else {
            fields = NO_FIELDS;
        }
        return fields;
    }

    private static ObjectStreamField[] getDeclaredSerialFields(Class<?> cl) throws InvalidClassException {
        throw new SecurityException();
    }

    private static ObjectStreamField[] getDefaultSerialFields(Class<?> cl) {
        throw new SecurityException();
    }

    private static Long getDeclaredSUID(Class<?> cl) {
        return null;
    }

    private static long computeDefaultSUID(Class<?> cl) {
        throw new SecurityException();
    }

    static {
        ObjectStreamClass.initNative();
    }

    private static class EntryFuture {
        private static final Object unset = new Object();
        private Object entry = unset;

        private EntryFuture() {
        }

        synchronized boolean set(Object entry) {
            if (this.entry != unset) {
                return false;
            }
            this.entry = entry;
            this.notifyAll();
            return true;
        }

        synchronized Object get() {
            boolean interrupted = false;
            while (this.entry == unset) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
            }
            return this.entry;
        }
    }

    static class ClassDataSlot {
        final ObjectStreamClass desc;
        final boolean hasData;

        ClassDataSlot(ObjectStreamClass desc, boolean hasData) {
            this.desc = desc;
            this.hasData = hasData;
        }
    }
}

