/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.ChangeListenerMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeListenerProxy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import org.apidesign.bck2brwsr.emul.lang.System;

public class VetoableChangeSupport
implements Serializable {
    private VetoableChangeListenerMap map = new VetoableChangeListenerMap();
    private Object source;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("children", Hashtable.class), new ObjectStreamField("source", Object.class), new ObjectStreamField("vetoableChangeSupportSerializedDataVersion", Integer.TYPE)};
    static final long serialVersionUID = -5090210921595982017L;

    public VetoableChangeSupport(Object sourceBean) {
        if (sourceBean == null) {
            throw new NullPointerException();
        }
        this.source = sourceBean;
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (listener instanceof VetoableChangeListenerProxy) {
            VetoableChangeListenerProxy proxy = (VetoableChangeListenerProxy)listener;
            this.addVetoableChangeListener(proxy.getPropertyName(), (VetoableChangeListener)proxy.getListener());
        } else {
            this.map.add(null, listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (listener instanceof VetoableChangeListenerProxy) {
            VetoableChangeListenerProxy proxy = (VetoableChangeListenerProxy)listener;
            this.removeVetoableChangeListener(proxy.getPropertyName(), (VetoableChangeListener)proxy.getListener());
        } else {
            this.map.remove(null, listener);
        }
    }

    public VetoableChangeListener[] getVetoableChangeListeners() {
        return (VetoableChangeListener[])this.map.getListeners();
    }

    public void addVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        if (listener == null || propertyName == null) {
            return;
        }
        if ((listener = this.map.extract(listener)) != null) {
            this.map.add(propertyName, listener);
        }
    }

    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        if (listener == null || propertyName == null) {
            return;
        }
        if ((listener = this.map.extract(listener)) != null) {
            this.map.remove(propertyName, listener);
        }
    }

    public VetoableChangeListener[] getVetoableChangeListeners(String propertyName) {
        return (VetoableChangeListener[])this.map.getListeners(propertyName);
    }

    public void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        if (oldValue == null || newValue == null || !oldValue.equals(newValue)) {
            this.fireVetoableChange(new PropertyChangeEvent(this.source, propertyName, oldValue, newValue));
        }
    }

    public void fireVetoableChange(String propertyName, int oldValue, int newValue) throws PropertyVetoException {
        if (oldValue != newValue) {
            this.fireVetoableChange(propertyName, (Object)oldValue, (Object)newValue);
        }
    }

    public void fireVetoableChange(String propertyName, boolean oldValue, boolean newValue) throws PropertyVetoException {
        if (oldValue != newValue) {
            this.fireVetoableChange(propertyName, (Object)oldValue, (Object)newValue);
        }
    }

    public void fireVetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        if (oldValue == null || newValue == null || !oldValue.equals(newValue)) {
            VetoableChangeListener[] listeners;
            VetoableChangeListener[] named;
            String name = event.getPropertyName();
            VetoableChangeListener[] common = (VetoableChangeListener[])this.map.get(null);
            VetoableChangeListener[] vetoableChangeListenerArray = named = name != null ? (VetoableChangeListener[])this.map.get(name) : null;
            if (common == null) {
                listeners = named;
            } else if (named == null) {
                listeners = common;
            } else {
                listeners = new VetoableChangeListener[common.length + named.length];
                System.arraycopy(common, 0, listeners, 0, common.length);
                System.arraycopy(named, 0, listeners, common.length, named.length);
            }
            if (listeners != null) {
                int current;
                try {
                    for (current = 0; current < listeners.length; ++current) {
                        listeners[current].vetoableChange(event);
                    }
                }
                catch (PropertyVetoException veto) {
                    event = new PropertyChangeEvent(this.source, name, newValue, oldValue);
                    for (int i = 0; i < current; ++i) {
                        try {
                            listeners[i].vetoableChange(event);
                            continue;
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                    throw veto;
                }
            }
        }
    }

    public boolean hasListeners(String propertyName) {
        return this.map.hasListeners(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        Hashtable<String, VetoableChangeSupport> children = null;
        VetoableChangeListener[] listeners = null;
        VetoableChangeListenerMap vetoableChangeListenerMap = this.map;
        synchronized (vetoableChangeListenerMap) {
            for (Map.Entry<String, L[]> entry : this.map.getEntries()) {
                String property = entry.getKey();
                if (property == null) {
                    listeners = (VetoableChangeListener[])entry.getValue();
                    continue;
                }
                if (children == null) {
                    children = new Hashtable<String, VetoableChangeSupport>();
                }
                VetoableChangeSupport vcs = new VetoableChangeSupport(this.source);
                vcs.map.set(null, (VetoableChangeListener[])entry.getValue());
                children.put(property, vcs);
            }
        }
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put("children", children);
        fields.put("source", this.source);
        fields.put("vetoableChangeSupportSerializedDataVersion", 2);
        s.writeFields();
        if (listeners != null) {
            for (VetoableChangeListener l : listeners) {
                if (!(l instanceof Serializable)) continue;
                s.writeObject(l);
            }
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        Object listenerOrNull;
        this.map = new VetoableChangeListenerMap();
        ObjectInputStream.GetField fields = s.readFields();
        Hashtable children = (Hashtable)fields.get("children", null);
        this.source = fields.get("source", null);
        fields.get("vetoableChangeSupportSerializedDataVersion", 2);
        while (null != (listenerOrNull = s.readObject())) {
            this.map.add(null, (VetoableChangeListener)listenerOrNull);
        }
        if (children != null) {
            for (Map.Entry entry : children.entrySet()) {
                for (VetoableChangeListener listener : ((VetoableChangeSupport)entry.getValue()).getVetoableChangeListeners()) {
                    this.map.add((String)entry.getKey(), listener);
                }
            }
        }
    }

    private static final class VetoableChangeListenerMap
    extends ChangeListenerMap<VetoableChangeListener> {
        private static final VetoableChangeListener[] EMPTY = new VetoableChangeListener[0];

        private VetoableChangeListenerMap() {
        }

        protected VetoableChangeListener[] newArray(int length) {
            return 0 < length ? new VetoableChangeListener[length] : EMPTY;
        }

        @Override
        protected VetoableChangeListener newProxy(String name, VetoableChangeListener listener) {
            return new VetoableChangeListenerProxy(name, listener);
        }
    }
}

