/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.Serializable;
import java.util.ArrayList;

public class Level
implements Serializable {
    private static ArrayList<Level> known = new ArrayList();
    private static String defaultBundle = "sun.util.logging.resources.logging";
    private final String name;
    private final int value;
    private final String resourceBundleName;
    public static final Level OFF = new Level("OFF", Integer.MAX_VALUE, defaultBundle);
    public static final Level SEVERE = new Level("SEVERE", 1000, defaultBundle);
    public static final Level WARNING = new Level("WARNING", 900, defaultBundle);
    public static final Level INFO = new Level("INFO", 800, defaultBundle);
    public static final Level CONFIG = new Level("CONFIG", 700, defaultBundle);
    public static final Level FINE = new Level("FINE", 500, defaultBundle);
    public static final Level FINER = new Level("FINER", 400, defaultBundle);
    public static final Level FINEST = new Level("FINEST", 300, defaultBundle);
    public static final Level ALL = new Level("ALL", Integer.MIN_VALUE, defaultBundle);
    private static final long serialVersionUID = -8176160795706313070L;

    protected Level(String name, int value) {
        this(name, value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Level(String name, int value, String resourceBundleName) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.value = value;
        this.resourceBundleName = resourceBundleName;
        Class<Level> clazz = Level.class;
        synchronized (Level.class) {
            known.add(this);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public String getName() {
        return this.name;
    }

    public String getLocalizedName() {
        return this.getName();
    }

    public final String toString() {
        return this.name;
    }

    public final int intValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readResolve() {
        Class<Level> clazz = Level.class;
        synchronized (Level.class) {
            for (int i = 0; i < known.size(); ++i) {
                Level other = known.get(i);
                if (!this.name.equals(other.name) || this.value != other.value || this.resourceBundleName != other.resourceBundleName && (this.resourceBundleName == null || !this.resourceBundleName.equals(other.resourceBundleName))) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return other;
            }
            known.add(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this;
        }
    }

    public static synchronized Level parse(String name) throws IllegalArgumentException {
        Level l;
        name.length();
        for (int i = 0; i < known.size(); ++i) {
            l = known.get(i);
            if (!name.equals(l.name)) continue;
            return l;
        }
        try {
            int x = Integer.parseInt(name);
            for (int i = 0; i < known.size(); ++i) {
                Level l2 = known.get(i);
                if (l2.value != x) continue;
                return l2;
            }
            return new Level(name, x);
        }
        catch (NumberFormatException x) {
            for (int i = 0; i < known.size(); ++i) {
                l = known.get(i);
                if (!name.equals(l.getLocalizedName())) continue;
                return l;
            }
            throw new IllegalArgumentException("Bad level \"" + name + "\"");
        }
    }

    public boolean equals(Object ox) {
        try {
            Level lx = (Level)ox;
            return lx.value == this.value;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public int hashCode() {
        return this.value;
    }
}

