/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apidesign.bck2brwsr.core.JavaScriptBody;

public abstract class TimeZone
implements Serializable,
Cloneable {
    public static final int SHORT = 0;
    public static final int LONG = 1;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final int ONE_DAY = 86400000;
    static final long serialVersionUID = 3581463369166924961L;
    static final TimeZone NO_TIMEZONE = null;
    private String ID;
    private static volatile TimeZone defaultTimeZone;
    static final String GMT_ID = "GMT";
    private static final int GMT_ID_LENGTH = 3;

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    public int getOffset(long date) {
        if (this.inDaylightTime(new Date(date))) {
            return this.getRawOffset() + this.getDSTSavings();
        }
        return this.getRawOffset();
    }

    int getOffsets(long date, int[] offsets) {
        int rawoffset = this.getRawOffset();
        int dstoffset = 0;
        if (this.inDaylightTime(new Date(date))) {
            dstoffset = this.getDSTSavings();
        }
        if (offsets != null) {
            offsets[0] = rawoffset;
            offsets[1] = dstoffset;
        }
        return rawoffset + dstoffset;
    }

    public abstract void setRawOffset(int var1);

    public abstract int getRawOffset();

    public String getID() {
        return this.ID;
    }

    public void setID(String ID) {
        if (ID == null) {
            throw new NullPointerException();
        }
        this.ID = ID;
    }

    public final String getDisplayName() {
        return this.getDisplayName(false, 1, Locale.getDefault(Locale.Category.DISPLAY));
    }

    public final String getDisplayName(Locale locale) {
        return this.getDisplayName(false, 1, locale);
    }

    public final String getDisplayName(boolean daylight, int style) {
        return this.getDisplayName(daylight, style, Locale.getDefault(Locale.Category.DISPLAY));
    }

    public String getDisplayName(boolean daylight, int style, Locale locale) {
        int index;
        if (style != 0 && style != 1) {
            throw new IllegalArgumentException("Illegal style: " + style);
        }
        String id = this.getID();
        String[] names = TimeZone.getDisplayNames(id, locale);
        if (names == null) {
            char sign;
            if (id.startsWith(GMT_ID) && ((sign = id.charAt(3)) == '+' || sign == '-')) {
                return id;
            }
            int offset = this.getRawOffset();
            if (daylight) {
                offset += this.getDSTSavings();
            }
        }
        int n = index = daylight ? 3 : 1;
        if (style == 0) {
            ++index;
        }
        return names[index];
    }

    private static final String[] getDisplayNames(String id, Locale locale) {
        Map perLocale;
        Map displayNames = DisplayNames.CACHE;
        SoftReference ref = (SoftReference)displayNames.get(id);
        if (ref != null && (perLocale = (Map)ref.get()) != null) {
            String[] names = (String[])perLocale.get(locale);
            if (names != null) {
                return names;
            }
            names = null;
            if (names != null) {
                perLocale.put(locale, names);
            }
            return names;
        }
        Object names = null;
        if (names != null) {
            ConcurrentHashMap<Locale, Object> perLocale2 = new ConcurrentHashMap<Locale, Object>();
            perLocale2.put(locale, names);
            ref = new SoftReference(perLocale2);
            displayNames.put(id, ref);
        }
        return names;
    }

    public int getDSTSavings() {
        if (this.useDaylightTime()) {
            return 3600000;
        }
        return 0;
    }

    public abstract boolean useDaylightTime();

    public boolean observesDaylightTime() {
        return this.useDaylightTime() || this.inDaylightTime(new Date());
    }

    public abstract boolean inDaylightTime(Date var1);

    public static synchronized TimeZone getTimeZone(String ID) {
        return TimeZone.getTimeZone(ID, true);
    }

    private static TimeZone getTimeZone(String ID, boolean fallback) {
        return NO_TIMEZONE;
    }

    public static synchronized String[] getAvailableIDs(int rawOffset) {
        return new String[0];
    }

    public static synchronized String[] getAvailableIDs() {
        return new String[0];
    }

    private static native String getSystemTimeZoneID(String var0, String var1);

    private static native String getSystemGMTOffsetID();

    public static TimeZone getDefault() {
        return (TimeZone)TimeZone.getDefaultRef().clone();
    }

    static TimeZone getDefaultRef() {
        TimeZone defaultZone = null;
        if (defaultZone == null && (defaultZone = defaultTimeZone) == null) {
            defaultZone = new TimeZone(){

                @Override
                public int getOffset(int era, int year, int month, int day, int dayOfWeek, int milliseconds) {
                    return this.getRawOffset();
                }

                @Override
                public void setRawOffset(int offsetMillis) {
                }

                @Override
                public int getRawOffset() {
                    int minutesOff = this.dateTimezoneOffset();
                    return -60000 * minutesOff;
                }

                @JavaScriptBody(args={}, body="return new Date().getTimezoneOffset();")
                private native int dateTimezoneOffset();

                @Override
                public boolean useDaylightTime() {
                    return false;
                }

                @Override
                public boolean inDaylightTime(Date date) {
                    return false;
                }
            };
        }
        return defaultZone;
    }

    private static boolean hasPermission() {
        boolean hasPermission = false;
        return hasPermission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setDefault(TimeZone zone) {
        if (!TimeZone.hasPermission()) return;
        Class<TimeZone> clazz = TimeZone.class;
        synchronized (TimeZone.class) {
            defaultTimeZone = zone;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean hasSameRules(TimeZone other) {
        return other != null && this.getRawOffset() == other.getRawOffset() && this.useDaylightTime() == other.useDaylightTime();
    }

    public Object clone() {
        try {
            TimeZone other = (TimeZone)super.clone();
            other.ID = this.ID;
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    private static final TimeZone parseCustomTimeZone(String id) {
        return null;
    }

    private static class DisplayNames {
        private static final Map<String, SoftReference<Map<Locale, String[]>>> CACHE = new ConcurrentHashMap<String, SoftReference<Map<Locale, String[]>>>();

        private DisplayNames() {
        }
    }
}

