/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.bck2brwsr.launcher;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apidesign.bck2brwsr.launcher.Launcher;

public final class InvocationContext {
    final CountDownLatch wait = new CountDownLatch(1);
    final Class<?> clazz;
    final String methodName;
    private final Launcher launcher;
    private String result;
    private Throwable exception;
    String html;
    String[] args;
    final List<Resource> resources = new ArrayList<Resource>();
    private int time;

    InvocationContext(Launcher launcher, Class<?> clazz, String methodName) {
        this.launcher = launcher;
        this.clazz = clazz;
        this.methodName = methodName;
    }

    public void setHtmlFragment(String html) {
        this.html = html;
    }

    public void setArguments(String ... args) {
        this.args = args;
    }

    public void addHttpResource(String relativePath, String mimeType, String[] parameters, InputStream content) {
        if (relativePath == null || mimeType == null || content == null || parameters == null) {
            throw new NullPointerException();
        }
        this.resources.add(new Resource(content, mimeType, relativePath, parameters));
    }

    public String invoke() throws IOException {
        this.launcher.runMethod(this);
        return this.toString();
    }

    public String invoke(int[] time) throws IOException {
        this.launcher.runMethod(this);
        if (time != null) {
            time[0] = this.time;
        }
        return this.toString();
    }

    public String toString() {
        if (this.exception != null) {
            return this.exception.toString();
        }
        return this.result;
    }

    void await(long timeOut) throws InterruptedException {
        this.wait.await(timeOut, TimeUnit.MILLISECONDS);
    }

    void result(String r, int time, Throwable e) {
        this.time = time;
        this.result = r;
        this.exception = e;
        this.wait.countDown();
    }

    static final class Resource {
        final InputStream httpContent;
        final String httpType;
        final String httpPath;
        final String[] parameters;

        Resource(InputStream httpContent, String httpType, String httpPath, String[] parameters) {
            httpContent.mark(Integer.MAX_VALUE);
            this.httpContent = httpContent;
            this.httpType = httpType;
            this.httpPath = httpPath;
            this.parameters = parameters;
        }
    }
}

