/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;

public class AtomicReference<V>
implements Serializable {
    private static final long serialVersionUID = -1848883965231344442L;
    private volatile V value;

    public AtomicReference(V initialValue) {
        this.value = initialValue;
    }

    public AtomicReference() {
    }

    public final V get() {
        return this.value;
    }

    public final void set(V newValue) {
        this.value = newValue;
    }

    public final void lazySet(V newValue) {
        this.value = newValue;
    }

    public final boolean compareAndSet(V expect, V update) {
        if (this.value == expect) {
            this.value = update;
            return true;
        }
        return false;
    }

    public final boolean weakCompareAndSet(V expect, V update) {
        return this.compareAndSet(expect, update);
    }

    public final V getAndSet(V newValue) {
        V x;
        while (!this.compareAndSet(x = this.get(), newValue)) {
        }
        return x;
    }

    public String toString() {
        return String.valueOf(this.get());
    }
}

