/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import org.apidesign.bck2brwsr.core.JavaScriptBody;

public abstract class AtomicIntegerFieldUpdater<T> {
    public static <U> AtomicIntegerFieldUpdater<U> newUpdater(Class<U> tclass, String fieldName) {
        return new AtomicIntegerFieldUpdaterImpl<U>(tclass, fieldName);
    }

    protected AtomicIntegerFieldUpdater() {
    }

    public abstract boolean compareAndSet(T var1, int var2, int var3);

    public abstract boolean weakCompareAndSet(T var1, int var2, int var3);

    public abstract void set(T var1, int var2);

    public abstract void lazySet(T var1, int var2);

    public abstract int get(T var1);

    public int getAndSet(T obj, int newValue) {
        int current;
        while (!this.compareAndSet(obj, current = this.get(obj), newValue)) {
        }
        return current;
    }

    public int getAndIncrement(T obj) {
        int next;
        int current;
        while (!this.compareAndSet(obj, current = this.get(obj), next = current + 1)) {
        }
        return current;
    }

    public int getAndDecrement(T obj) {
        int next;
        int current;
        while (!this.compareAndSet(obj, current = this.get(obj), next = current - 1)) {
        }
        return current;
    }

    public int getAndAdd(T obj, int delta) {
        int next;
        int current;
        while (!this.compareAndSet(obj, current = this.get(obj), next = current + delta)) {
        }
        return current;
    }

    public int incrementAndGet(T obj) {
        int next;
        int current;
        while (!this.compareAndSet(obj, current = this.get(obj), next = current + 1)) {
        }
        return next;
    }

    public int decrementAndGet(T obj) {
        int next;
        int current;
        while (!this.compareAndSet(obj, current = this.get(obj), next = current - 1)) {
        }
        return next;
    }

    public int addAndGet(T obj, int delta) {
        int next;
        int current;
        while (!this.compareAndSet(obj, current = this.get(obj), next = current + delta)) {
        }
        return next;
    }

    private static class AtomicIntegerFieldUpdaterImpl<T>
    extends AtomicIntegerFieldUpdater<T> {
        private final Object fn;
        private Class<T> tclass;
        private Object cclass;

        AtomicIntegerFieldUpdaterImpl(Class<T> tclass, Object fieldName) {
            if (!AtomicIntegerFieldUpdaterImpl.isFunction(fieldName)) {
                throw new SecurityException("Updater can be used only from own class!");
            }
            this.tclass = tclass;
            this.fn = fieldName;
        }

        @JavaScriptBody(args={"obj", "fn"}, body="return fn.call(obj);")
        private static native int get(Object var0, Object var1);

        @JavaScriptBody(args={"obj", "fn", "v"}, body="fn.call(obj, v);")
        private static native void set(Object var0, Object var1, int var2);

        @JavaScriptBody(args={"f"}, body="return typeof f === 'function';")
        private static native boolean isFunction(Object var0);

        private void fullCheck(T obj) {
            if (!this.tclass.isInstance(obj)) {
                throw new ClassCastException();
            }
        }

        @Override
        public boolean compareAndSet(T obj, int expect, int update) {
            int prev;
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            if ((prev = AtomicIntegerFieldUpdaterImpl.get(obj, this.fn)) == expect) {
                AtomicIntegerFieldUpdaterImpl.set(obj, this.fn, update);
                return true;
            }
            return false;
        }

        @Override
        public boolean weakCompareAndSet(T obj, int expect, int update) {
            return this.compareAndSet(obj, expect, update);
        }

        @Override
        public void set(T obj, int newValue) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            AtomicIntegerFieldUpdaterImpl.set(obj, this.fn, newValue);
        }

        @Override
        public void lazySet(T obj, int newValue) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            AtomicIntegerFieldUpdaterImpl.set(obj, this.fn, newValue);
        }

        @Override
        public final int get(T obj) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            return AtomicIntegerFieldUpdaterImpl.get(obj, this.fn);
        }
    }
}

