/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import org.apidesign.bck2brwsr.emul.lang.System;

public class Random
implements Serializable {
    static final long serialVersionUID = 3905348978240129619L;
    private long seed;
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private static long seedUniquifier = 8682522807148012L;
    private double nextNextGaussian;
    private boolean haveNextNextGaussian = false;

    public Random() {
        this(Random.seedUniquifier() ^ System.nanoTime());
    }

    private static synchronized long seedUniquifier() {
        long next;
        long current = seedUniquifier;
        seedUniquifier = next = current * 181783497276652981L;
        return next;
    }

    public Random(long seed) {
        this.seed = Random.initialScramble(seed);
    }

    private static long initialScramble(long seed) {
        return (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    public synchronized void setSeed(long seed) {
        this.seed = Random.initialScramble(seed);
        this.haveNextNextGaussian = false;
    }

    protected synchronized int next(int bits) {
        long nextseed;
        long seed;
        long oldseed = seed = this.seed;
        this.seed = nextseed = oldseed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(nextseed >>> 48 - bits);
    }

    public void nextBytes(byte[] bytes) {
        int i = 0;
        int len = bytes.length;
        while (i < len) {
            int rnd = this.nextInt();
            int n = Math.min(len - i, 4);
            while (n-- > 0) {
                bytes[i++] = (byte)rnd;
                rnd >>= 8;
            }
        }
    }

    public int nextInt() {
        return this.next(32);
    }

    public int nextInt(int n) {
        int val;
        int bits;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        if ((n & -n) == n) {
            return (int)((long)n * (long)this.next(31) >> 31);
        }
        while ((bits = this.next(31)) - (val = bits % n) + (n - 1) < 0) {
        }
        return val;
    }

    public long nextLong() {
        return ((long)this.next(32) << 32) + (long)this.next(32);
    }

    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    public float nextFloat() {
        return (float)this.next(24) / 1.6777216E7f;
    }

    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) / 9.007199254740992E15;
    }

    public synchronized double nextGaussian() {
        double v2;
        double v1;
        double s;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = Math.sqrt(-2.0 * Math.log(s) / s);
        this.nextNextGaussian = v2 * multiplier;
        this.haveNextNextGaussian = true;
        return v1 * multiplier;
    }
}

