/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.TimeZone;

public class Date
implements Serializable,
Cloneable,
Comparable<Date> {
    private static final BaseCalendar gcal = new BaseCalendar();
    private static BaseCalendar jcal;
    private transient long fastTime;
    private transient BaseCalendar.Datum cdate;
    private static int defaultCenturyStart;
    private static final long serialVersionUID = 7523967970034938905L;
    private static final String[] wtb;
    private static final int[] ttb;

    public Date() {
        this(System.currentTimeMillis());
    }

    public Date(long date) {
        this.fastTime = date;
    }

    @Deprecated
    public Date(int year, int month, int date) {
        this(year, month, date, 0, 0, 0);
    }

    @Deprecated
    public Date(int year, int month, int date, int hrs, int min) {
        this(year, month, date, hrs, min, 0);
    }

    @Deprecated
    public Date(int year, int month, int date, int hrs, int min, int sec) {
        int y = year + 1900;
        if (month >= 12) {
            y += month / 12;
            month %= 12;
        } else if (month < 0) {
            y += month / 12;
            month %= 12;
        }
        BaseCalendar cal = Date.getCalendarSystem(y);
        this.cdate = cal.newCalendarDate(TimeZone.getDefaultRef());
        this.cdate.setNormalizedDate(y, month + 1, date).setTimeOfDay(hrs, min, sec, 0);
        this.getTimeImpl();
        this.cdate = null;
    }

    @Deprecated
    public Date(String s) {
        this(Date.parse(s));
    }

    public Object clone() {
        Date d = null;
        try {
            d = (Date)super.clone();
            if (this.cdate != null) {
                d.cdate = this.cdate.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return d;
    }

    @Deprecated
    public static long UTC(int year, int month, int date, int hrs, int min, int sec) {
        int y = year + 1900;
        if (month >= 12) {
            y += month / 12;
            month %= 12;
        } else if (month < 0) {
            y += month / 12;
            month %= 12;
        }
        int m = month + 1;
        BaseCalendar cal = Date.getCalendarSystem(y);
        BaseCalendar.Datum udate = cal.newCalendarDate(null);
        udate.setNormalizedDate(y, m, date).setTimeOfDay(hrs, min, sec, 0);
        Date d = new Date(0L);
        d.normalize(udate);
        return d.fastTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Deprecated
    public static long parse(String s) {
        int year = Integer.MIN_VALUE;
        int mon = -1;
        int mday = -1;
        int hour = -1;
        int min = -1;
        int sec = -1;
        int millis = -1;
        int c = -1;
        int i = 0;
        int n = -1;
        int wst = -1;
        int tzoffset = -1;
        int prevc = 0;
        if (s == null) {
            throw new IllegalArgumentException();
        }
        int limit = s.length();
        block2: while (true) {
            int st2;
            block52: {
                block51: {
                    block50: {
                        if (i >= limit) break block50;
                        c = s.charAt(i);
                        ++i;
                        if (c <= 32 || c == 44) continue;
                        if (c == 40) break block51;
                        if (48 <= c && c <= 57) {
                            n = c - 48;
                            while (i < limit) {
                                char c2 = s.charAt(i);
                                c = c2;
                                if ('0' > c2 || c > 57) break;
                                n = n * 10 + c - 48;
                                ++i;
                            }
                            if (prevc == 43 || prevc == 45 && year != Integer.MIN_VALUE) {
                                n = n < 24 ? (n *= 60) : n % 100 + n / 100 * 60;
                                if (prevc == 43) {
                                    n = -n;
                                }
                                if (tzoffset != 0 && tzoffset != -1) {
                                    throw new IllegalArgumentException();
                                }
                                tzoffset = n;
                            } else if (n >= 70) {
                                if (year != Integer.MIN_VALUE) {
                                    throw new IllegalArgumentException();
                                }
                                if (c > 32 && c != 44 && c != 47) {
                                    if (i < limit) throw new IllegalArgumentException();
                                }
                                year = n;
                            } else if (c == 58) {
                                if (hour < 0) {
                                    hour = (byte)n;
                                } else {
                                    if (min >= 0) throw new IllegalArgumentException();
                                    min = (byte)n;
                                }
                            } else if (c == 47) {
                                if (mon < 0) {
                                    mon = (byte)(n - 1);
                                } else {
                                    if (mday >= 0) throw new IllegalArgumentException();
                                    mday = (byte)n;
                                }
                            } else {
                                if (i < limit && c != 44 && c > 32 && c != 45) {
                                    throw new IllegalArgumentException();
                                }
                                if (hour >= 0 && min < 0) {
                                    min = (byte)n;
                                } else if (min >= 0 && sec < 0) {
                                    sec = (byte)n;
                                } else if (mday < 0) {
                                    mday = (byte)n;
                                } else {
                                    if (year != Integer.MIN_VALUE) throw new IllegalArgumentException();
                                    if (mon < 0) throw new IllegalArgumentException();
                                    if (mday < 0) throw new IllegalArgumentException();
                                    year = n;
                                }
                            }
                            prevc = 0;
                            continue;
                        }
                        if (c == 47 || c == 58 || c == 43 || c == 45) {
                            prevc = c;
                            continue;
                        }
                        st2 = i - 1;
                        break block52;
                    }
                    if (year == Integer.MIN_VALUE) throw new IllegalArgumentException();
                    if (mon < 0) throw new IllegalArgumentException();
                    if (mday < 0) {
                        throw new IllegalArgumentException();
                    }
                    if (year < 100) {
                        Class<Date> st2 = Date.class;
                        // MONITORENTER : java.util.Date.class
                        if (defaultCenturyStart == 0) {
                            defaultCenturyStart = gcal.getCalendarDate().getYear() - 80;
                        }
                        // MONITOREXIT : st2
                        if ((year += defaultCenturyStart / 100 * 100) < defaultCenturyStart) {
                            year += 100;
                        }
                    }
                    if (sec < 0) {
                        sec = 0;
                    }
                    if (min < 0) {
                        min = 0;
                    }
                    if (hour < 0) {
                        hour = 0;
                    }
                    BaseCalendar cal = Date.getCalendarSystem(year);
                    if (tzoffset == -1) {
                        BaseCalendar.Datum ldate = cal.newCalendarDate(TimeZone.getDefaultRef());
                        ldate.setDate(year, mon + 1, mday);
                        ldate.setTimeOfDay(hour, min, sec, 0);
                        return cal.getTime(ldate);
                    }
                    BaseCalendar.Datum udate = cal.newCalendarDate(null);
                    udate.setDate(year, mon + 1, mday);
                    udate.setTimeOfDay(hour, min, sec, 0);
                    return cal.getTime(udate) + tzoffset * 60000;
                }
                int depth = 1;
                while (true) {
                    if (i >= limit) continue block2;
                    c = s.charAt(i);
                    ++i;
                    if (c == 40) {
                        ++depth;
                        continue;
                    }
                    if (c == 41 && --depth <= 0) break;
                }
                continue;
            }
            while (i < limit && (65 <= (c = (int)s.charAt(i)) && c <= 90 || 97 <= c && c <= 122)) {
                ++i;
            }
            if (i <= st2 + 1) {
                throw new IllegalArgumentException();
            }
            int k = wtb.length;
            while (--k >= 0) {
                if (!wtb[k].regionMatches(true, 0, s, st2, i - st2)) continue;
                int action = ttb[k];
                if (action == 0) break;
                if (action == 1) {
                    if (hour > 12) throw new IllegalArgumentException();
                    if (hour < 1) {
                        throw new IllegalArgumentException();
                    }
                    if (hour >= 12) break;
                    hour += 12;
                    break;
                }
                if (action == 14) {
                    if (hour > 12) throw new IllegalArgumentException();
                    if (hour < 1) {
                        throw new IllegalArgumentException();
                    }
                    if (hour != 12) break;
                    hour = 0;
                    break;
                }
                if (action <= 13) {
                    if (mon >= 0) throw new IllegalArgumentException();
                    mon = (byte)(action - 2);
                    break;
                }
                tzoffset = action - 10000;
                break;
            }
            if (k < 0) {
                throw new IllegalArgumentException();
            }
            prevc = 0;
        }
    }

    @Deprecated
    public int getYear() {
        return this.normalize().getYear() - 1900;
    }

    @Deprecated
    public void setYear(int year) {
        this.getCalendarDate().setNormalizedYear(year + 1900);
    }

    @Deprecated
    public int getMonth() {
        return this.normalize().getMonth() - 1;
    }

    @Deprecated
    public void setMonth(int month) {
        int y = 0;
        if (month >= 12) {
            y = month / 12;
            month %= 12;
        } else if (month < 0) {
            y = month / 12;
            month %= 12;
        }
        BaseCalendar.Datum d = this.getCalendarDate();
        if (y != 0) {
            d.setNormalizedYear(d.getNormalizedYear() + y);
        }
        d.setMonth(month + 1);
    }

    @Deprecated
    public int getDate() {
        return this.normalize().getDayOfMonth();
    }

    @Deprecated
    public void setDate(int date) {
        this.getCalendarDate().setDayOfMonth(date);
    }

    @Deprecated
    public int getDay() {
        return this.normalize().getDayOfWeek() - 7;
    }

    @Deprecated
    public int getHours() {
        return this.normalize().getHours();
    }

    @Deprecated
    public void setHours(int hours) {
        this.getCalendarDate().setHours(hours);
    }

    @Deprecated
    public int getMinutes() {
        return this.normalize().getMinutes();
    }

    @Deprecated
    public void setMinutes(int minutes) {
        this.getCalendarDate().setMinutes(minutes);
    }

    @Deprecated
    public int getSeconds() {
        return this.normalize().getSeconds();
    }

    @Deprecated
    public void setSeconds(int seconds) {
        this.getCalendarDate().setSeconds(seconds);
    }

    public long getTime() {
        return this.getTimeImpl();
    }

    private final long getTimeImpl() {
        if (this.cdate != null && !this.cdate.isNormalized()) {
            this.normalize();
        }
        return this.fastTime;
    }

    public void setTime(long time) {
        this.fastTime = time;
        this.cdate = null;
    }

    public boolean before(Date when) {
        return Date.getMillisOf(this) < Date.getMillisOf(when);
    }

    public boolean after(Date when) {
        return Date.getMillisOf(this) > Date.getMillisOf(when);
    }

    public boolean equals(Object obj) {
        return obj instanceof Date && this.getTime() == ((Date)obj).getTime();
    }

    static final long getMillisOf(Date date) {
        if (date.cdate == null || date.cdate.isNormalized()) {
            return date.fastTime;
        }
        BaseCalendar.Datum d = date.cdate.clone();
        return gcal.getTime(d);
    }

    @Override
    public int compareTo(Date anotherDate) {
        long anotherTime;
        long thisTime = Date.getMillisOf(this);
        return thisTime < (anotherTime = Date.getMillisOf(anotherDate)) ? -1 : (thisTime == anotherTime ? 0 : 1);
    }

    public int hashCode() {
        long ht = this.getTime();
        return (int)ht ^ (int)(ht >> 32);
    }

    public String toString() {
        BaseCalendar.Datum date = this.normalize();
        StringBuilder sb = new StringBuilder(28);
        int index = date.getDayOfWeek();
        if (index == 7) {
            index = 8;
        }
        Date.convertToAbbr(sb, wtb[index]).append(' ');
        Date.convertToAbbr(sb, wtb[date.getMonth() - 1 + 2 + 7]).append(' ');
        sb.append(' ').append(date.getYear());
        return sb.toString();
    }

    private static final StringBuilder convertToAbbr(StringBuilder sb, String name) {
        sb.append(Character.toUpperCase(name.charAt(0)));
        sb.append(name.charAt(1)).append(name.charAt(2));
        return sb;
    }

    @Deprecated
    public String toLocaleString() {
        DateFormat formatter = DateFormat.getDateTimeInstance();
        return formatter.format(this);
    }

    @Deprecated
    public String toGMTString() {
        long t = this.getTime();
        BaseCalendar cal = Date.getCalendarSystem(t);
        StringBuilder sb = new StringBuilder(32);
        sb.append(" GMT");
        return sb.toString();
    }

    @Deprecated
    public int getTimezoneOffset() {
        int zoneOffset;
        if (this.cdate == null) {
            TimeZone tz = TimeZone.getDefaultRef();
            zoneOffset = tz.getOffset(this.fastTime);
        } else {
            this.normalize();
            zoneOffset = this.cdate.getZoneOffset();
        }
        return -zoneOffset / 60000;
    }

    private final BaseCalendar.Datum getCalendarDate() {
        if (this.cdate == null) {
            // empty if block
        }
        return this.cdate;
    }

    private final BaseCalendar.Datum normalize() {
        TimeZone tz;
        if (this.cdate == null) {
            // empty if block
        }
        if (!this.cdate.isNormalized()) {
            this.cdate = this.normalize(this.cdate);
        }
        if ((tz = TimeZone.getDefaultRef()) != this.cdate.getZone()) {
            // empty if block
        }
        return this.cdate;
    }

    private final BaseCalendar.Datum normalize(BaseCalendar.Datum date) {
        int y = date.getNormalizedYear();
        int m = date.getMonth();
        int d = date.getDayOfMonth();
        int hh = date.getHours();
        int mm = date.getMinutes();
        int ss = date.getSeconds();
        int ms = date.getMillis();
        TimeZone tz = date.getZone();
        BaseCalendar cal = Date.getCalendarSystem(y);
        if (cal != Date.getCalendarSystem(date)) {
            date = cal.newCalendarDate(tz);
            date.setNormalizedDate(y, m, d).setTimeOfDay(hh, mm, ss, ms);
        }
        this.fastTime = cal.getTime(date);
        BaseCalendar ncal = Date.getCalendarSystem(this.fastTime);
        if (ncal != cal) {
            date = ncal.newCalendarDate(tz);
            date.setNormalizedDate(y, m, d).setTimeOfDay(hh, mm, ss, ms);
            this.fastTime = ncal.getTime(date);
        }
        return date;
    }

    private static final BaseCalendar getCalendarSystem(int year) {
        if (year >= 1582) {
            return gcal;
        }
        return Date.getJulianCalendar();
    }

    private static final BaseCalendar getCalendarSystem(long utc) {
        return gcal;
    }

    private static final BaseCalendar getCalendarSystem(BaseCalendar.Datum cdate) {
        if (jcal == null) {
            return gcal;
        }
        if (cdate.getEra() != null) {
            return jcal;
        }
        return gcal;
    }

    private static final synchronized BaseCalendar getJulianCalendar() {
        if (jcal == null) {
            // empty if block
        }
        return jcal;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeLong(this.getTimeImpl());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.fastTime = s.readLong();
    }

    static {
        wtb = new String[]{"am", "pm", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};
        ttb = new int[]{14, 1, 0, 0, 0, 0, 0, 0, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 10000, 10000, 10000, 10300, 10240, 10360, 10300, 10420, 10360, 10480, 10420};
    }

    static final class BaseCalendar {
        BaseCalendar() {
        }

        Datum newCalendarDate(TimeZone t) {
            return new Datum();
        }

        Datum getNthDayOfWeek(int a, int b, Datum c) {
            return new Datum();
        }

        Datum getCalendarDate() {
            return new Datum();
        }

        int getTime(Datum udate) {
            return 0;
        }

        int getMonthLength(Datum cdate) {
            return 0;
        }

        void getCalendarDate(long l, Datum cdate) {
        }

        static class Datum
        implements Cloneable {
            Datum() {
            }

            public Datum clone() {
                return new Datum();
            }

            Datum setNormalizedDate(int y, int i, int date) {
                return this;
            }

            void setTimeOfDay(int hrs, int min, int sec, int i) {
            }

            int getYear() {
                return 0;
            }

            void setDate(int year, int i, int mday) {
            }

            void setNormalizedYear(int i) {
            }

            int getMonth() {
                return 0;
            }

            int getNormalizedYear() {
                return 0;
            }

            void setMonth(int i) {
            }

            int getDayOfMonth() {
                return 0;
            }

            void setDayOfMonth(int date) {
            }

            int getDayOfWeek() {
                return 0;
            }

            int getHours() {
                return 0;
            }

            void setHours(int hours) {
            }

            int getMinutes() {
                return 0;
            }

            void setMinutes(int minutes) {
            }

            int getSeconds() {
                return 0;
            }

            void setSeconds(int seconds) {
            }

            boolean isNormalized() {
                return false;
            }

            Object getEra() {
                return this;
            }

            int getMillis() {
                return 0;
            }

            TimeZone getZone() {
                return TimeZone.NO_TIMEZONE;
            }

            int getZoneOffset() {
                return 0;
            }
        }
    }
}

