/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;

public class InputStreamReader
extends Reader {
    public InputStreamReader(InputStream in) {
        super(in);
    }

    public InputStreamReader(InputStream in, String charsetName) throws UnsupportedEncodingException {
        super(in);
        if (!charsetName.toUpperCase().equals("UTF-8")) {
            throw new UnsupportedEncodingException(charsetName);
        }
    }

    public String getEncoding() {
        return "UTF-8";
    }

    @Override
    public int read() throws IOException {
        InputStream is = (InputStream)this.lock;
        int c = is.read();
        if (c == -1) {
            return -1;
        }
        switch ((c &= 0xFF) >> 4) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return c;
            }
            case 12: 
            case 13: {
                int char2 = is.read();
                if ((char2 & 0xC0) != 128) {
                    throw new UTFDataFormatException("malformed input");
                }
                return (c & 0x1F) << 6 | char2 & 0x3F;
            }
            case 14: {
                int char2 = is.read();
                int char3 = is.read();
                if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                    throw new UTFDataFormatException("malformed input");
                }
                return (c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0;
            }
        }
        throw new UTFDataFormatException("malformed input");
    }

    @Override
    public int read(char[] cbuf, int offset, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            int ch = this.read();
            if (ch == -1) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            cbuf[offset++] = (char)ch;
        }
        return length;
    }

    @Override
    public boolean ready() throws IOException {
        return ((InputStream)this.lock).available() > 0;
    }

    @Override
    public void close() throws IOException {
        ((InputStream)this.lock).close();
    }
}

