/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apidesign.bck2brwsr.core.JavaScriptBody;

public final class Locale
implements Cloneable,
Serializable {
    public static final Locale ENGLISH = Locale.createConstant("en", "");
    public static final Locale FRENCH = Locale.createConstant("fr", "");
    public static final Locale GERMAN = Locale.createConstant("de", "");
    public static final Locale ITALIAN = Locale.createConstant("it", "");
    public static final Locale JAPANESE = Locale.createConstant("ja", "");
    public static final Locale KOREAN = Locale.createConstant("ko", "");
    public static final Locale CHINESE = Locale.createConstant("zh", "");
    public static final Locale SIMPLIFIED_CHINESE = Locale.createConstant("zh", "CN");
    public static final Locale TRADITIONAL_CHINESE = Locale.createConstant("zh", "TW");
    public static final Locale FRANCE = Locale.createConstant("fr", "FR");
    public static final Locale GERMANY = Locale.createConstant("de", "DE");
    public static final Locale ITALY = Locale.createConstant("it", "IT");
    public static final Locale JAPAN = Locale.createConstant("ja", "JP");
    public static final Locale KOREA = Locale.createConstant("ko", "KR");
    public static final Locale CHINA = SIMPLIFIED_CHINESE;
    public static final Locale PRC = SIMPLIFIED_CHINESE;
    public static final Locale TAIWAN = TRADITIONAL_CHINESE;
    public static final Locale UK = Locale.createConstant("en", "GB");
    public static final Locale US = Locale.createConstant("en", "US");
    public static final Locale CANADA = Locale.createConstant("en", "CA");
    public static final Locale CANADA_FRENCH = Locale.createConstant("fr", "CA");
    public static final Locale ROOT = Locale.createConstant("", "");
    public static final char PRIVATE_USE_EXTENSION = 'x';
    public static final char UNICODE_LOCALE_EXTENSION = 'u';
    static final long serialVersionUID = 9149081749638150636L;
    private static final int DISPLAY_LANGUAGE = 0;
    private static final int DISPLAY_COUNTRY = 1;
    private static final int DISPLAY_VARIANT = 2;
    private static final int DISPLAY_SCRIPT = 3;
    private String language;
    private String country;
    private String variant;

    static Locale getInstance(String language, String script, String region, String v, Object object) {
        return new Locale(language, script, region);
    }

    static Locale getInstance(String no, String no0, String ny) {
        return new Locale(no, no0, ny);
    }

    public Locale(String language, String country, String variant) {
        if (language == null || country == null || variant == null) {
            throw new NullPointerException();
        }
        this.language = language;
        this.country = country;
        this.variant = variant;
    }

    public Locale(String language, String country) {
        this(language, country, "");
    }

    public Locale(String language) {
        this(language, "", "");
    }

    private static Locale createConstant(String lang, String country) {
        return new Locale(lang, country);
    }

    public static Locale getDefault() {
        String lang = Locale.language();
        if (lang != null) {
            String[] arr = lang.split("-");
            return new Locale(arr[0], arr.length == 1 ? "" : arr[1]);
        }
        return US;
    }

    @JavaScriptBody(args={}, body="if (typeof navigator === 'undefined') return null;\nif (navigator.language) return navigator.language;\nif (navigator.userLangage) return navigator.userLangage;\nreturn null;\n")
    private static native String language();

    public static Locale getDefault(Category category) {
        return Locale.getDefault();
    }

    public static void setDefault(Locale newLocale) {
        throw new SecurityException();
    }

    public static Locale[] getAvailableLocales() {
        return new Locale[]{US};
    }

    public String getLanguage() {
        return this.language;
    }

    public String getScript() {
        return "";
    }

    public String getCountry() {
        return this.country;
    }

    public String getVariant() {
        return this.variant;
    }

    String getRegion() {
        return this.getCountry();
    }

    public String getExtension(char key) {
        return null;
    }

    public Set<Character> getExtensionKeys() {
        return Collections.emptySet();
    }

    public Set<String> getUnicodeLocaleAttributes() {
        return Collections.emptySet();
    }

    public String getUnicodeLocaleType(String key) {
        return null;
    }

    public Set<String> getUnicodeLocaleKeys() {
        return Collections.emptySet();
    }

    public final String toString() {
        Locale baseLocale = this;
        boolean l = baseLocale.getLanguage().length() != 0;
        boolean s = baseLocale.getScript().length() != 0;
        boolean r = baseLocale.getRegion().length() != 0;
        boolean v = baseLocale.getVariant().length() != 0;
        boolean e = false;
        StringBuilder result = new StringBuilder(baseLocale.getLanguage());
        if (r || l && (v || s || e)) {
            result.append('_').append(baseLocale.getRegion());
        }
        if (v && (l || r)) {
            result.append('_').append(baseLocale.getVariant());
        }
        if (s && (l || r)) {
            result.append("_#").append(baseLocale.getScript());
        }
        if (e && (l || r)) {
            result.append('_');
            if (!s) {
                result.append('#');
            }
        }
        return result.toString();
    }

    public Object clone() {
        try {
            Locale that = (Locale)super.clone();
            return that;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        int hash = 3;
        hash = 43 * hash + Objects.hashCode(this.language);
        hash = 43 * hash + Objects.hashCode(this.country);
        hash = 43 * hash + Objects.hashCode(this.variant);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Locale other = (Locale)obj;
        if (!Objects.equals(this.language, other.language)) {
            return false;
        }
        if (!Objects.equals(this.country, other.country)) {
            return false;
        }
        return Objects.equals(this.variant, other.variant);
    }

    public static enum Category {
        DISPLAY("user.language.display", "user.script.display", "user.country.display", "user.variant.display"),
        FORMAT("user.language.format", "user.script.format", "user.country.format", "user.variant.format");

        final String languageKey;
        final String scriptKey;
        final String countryKey;
        final String variantKey;

        private Category(String languageKey, String scriptKey, String countryKey, String variantKey) {
            this.languageKey = languageKey;
            this.scriptKey = scriptKey;
            this.countryKey = countryKey;
            this.variantKey = variantKey;
        }
    }
}

