/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DateFormatSymbols
implements Serializable,
Cloneable {
    String[] eras = null;
    String[] months = null;
    String[] shortMonths = null;
    String[] weekdays = null;
    String[] shortWeekdays = null;
    String[] ampms = null;
    String[][] zoneStrings = null;
    transient boolean isZoneStringsSet = false;
    static final String patternChars = "GyMdkHmsSEDFwWahKzZYuX";
    static final int PATTERN_ERA = 0;
    static final int PATTERN_YEAR = 1;
    static final int PATTERN_MONTH = 2;
    static final int PATTERN_DAY_OF_MONTH = 3;
    static final int PATTERN_HOUR_OF_DAY1 = 4;
    static final int PATTERN_HOUR_OF_DAY0 = 5;
    static final int PATTERN_MINUTE = 6;
    static final int PATTERN_SECOND = 7;
    static final int PATTERN_MILLISECOND = 8;
    static final int PATTERN_DAY_OF_WEEK = 9;
    static final int PATTERN_DAY_OF_YEAR = 10;
    static final int PATTERN_DAY_OF_WEEK_IN_MONTH = 11;
    static final int PATTERN_WEEK_OF_YEAR = 12;
    static final int PATTERN_WEEK_OF_MONTH = 13;
    static final int PATTERN_AM_PM = 14;
    static final int PATTERN_HOUR1 = 15;
    static final int PATTERN_HOUR0 = 16;
    static final int PATTERN_ZONE_NAME = 17;
    static final int PATTERN_ZONE_VALUE = 18;
    static final int PATTERN_WEEK_YEAR = 19;
    static final int PATTERN_ISO_DAY_OF_WEEK = 20;
    static final int PATTERN_ISO_ZONE = 21;
    String localPatternChars = null;
    Locale locale = null;
    static final long serialVersionUID = -5987973545549424702L;
    static final int millisPerHour = 3600000;
    private static final ConcurrentMap<Locale, SoftReference<DateFormatSymbols>> cachedInstances = new ConcurrentHashMap<Locale, SoftReference<DateFormatSymbols>>(3);

    public DateFormatSymbols() {
        this.initializeData(Locale.getDefault(Locale.Category.FORMAT));
    }

    public DateFormatSymbols(Locale locale) {
        this.initializeData(locale);
    }

    public static Locale[] getAvailableLocales() {
        return new Locale[]{Locale.US};
    }

    public static final DateFormatSymbols getInstance() {
        return DateFormatSymbols.getInstance(Locale.getDefault(Locale.Category.FORMAT));
    }

    public static final DateFormatSymbols getInstance(Locale locale) {
        DateFormatSymbols dfs = DateFormatSymbols.getProviderInstance(locale);
        if (dfs != null) {
            return dfs;
        }
        return (DateFormatSymbols)DateFormatSymbols.getCachedInstance(locale).clone();
    }

    static final DateFormatSymbols getInstanceRef(Locale locale) {
        DateFormatSymbols dfs = DateFormatSymbols.getProviderInstance(locale);
        if (dfs != null) {
            return dfs;
        }
        return DateFormatSymbols.getCachedInstance(locale);
    }

    private static DateFormatSymbols getProviderInstance(Locale locale) {
        DateFormatSymbols providersInstance = null;
        return providersInstance;
    }

    private static DateFormatSymbols getCachedInstance(Locale locale) {
        SoftReference<DateFormatSymbols> x;
        SoftReference<DateFormatSymbols> ref = (SoftReference<DateFormatSymbols>)cachedInstances.get(locale);
        DateFormatSymbols dfs = null;
        if ((ref == null || (dfs = (DateFormatSymbols)ref.get()) == null) && (x = cachedInstances.putIfAbsent(locale, ref = new SoftReference<DateFormatSymbols>(dfs = new DateFormatSymbols(locale)))) != null) {
            DateFormatSymbols y = x.get();
            if (y != null) {
                dfs = y;
            } else {
                cachedInstances.put(locale, ref);
            }
        }
        return dfs;
    }

    public String[] getEras() {
        return Arrays.copyOf(this.eras, this.eras.length);
    }

    public void setEras(String[] newEras) {
        this.eras = Arrays.copyOf(newEras, newEras.length);
    }

    public String[] getMonths() {
        return Arrays.copyOf(this.months, this.months.length);
    }

    public void setMonths(String[] newMonths) {
        this.months = Arrays.copyOf(newMonths, newMonths.length);
    }

    public String[] getShortMonths() {
        return Arrays.copyOf(this.shortMonths, this.shortMonths.length);
    }

    public void setShortMonths(String[] newShortMonths) {
        this.shortMonths = Arrays.copyOf(newShortMonths, newShortMonths.length);
    }

    public String[] getWeekdays() {
        return Arrays.copyOf(this.weekdays, this.weekdays.length);
    }

    public void setWeekdays(String[] newWeekdays) {
        this.weekdays = Arrays.copyOf(newWeekdays, newWeekdays.length);
    }

    public String[] getShortWeekdays() {
        return Arrays.copyOf(this.shortWeekdays, this.shortWeekdays.length);
    }

    public void setShortWeekdays(String[] newShortWeekdays) {
        this.shortWeekdays = Arrays.copyOf(newShortWeekdays, newShortWeekdays.length);
    }

    public String[] getAmPmStrings() {
        return Arrays.copyOf(this.ampms, this.ampms.length);
    }

    public void setAmPmStrings(String[] newAmpms) {
        this.ampms = Arrays.copyOf(newAmpms, newAmpms.length);
    }

    public String[][] getZoneStrings() {
        return this.getZoneStringsImpl(true);
    }

    public void setZoneStrings(String[][] newZoneStrings) {
        String[][] aCopy = new String[newZoneStrings.length][];
        for (int i = 0; i < newZoneStrings.length; ++i) {
            int len = newZoneStrings[i].length;
            if (len < 5) {
                throw new IllegalArgumentException();
            }
            aCopy[i] = Arrays.copyOf(newZoneStrings[i], len);
        }
        this.zoneStrings = aCopy;
        this.isZoneStringsSet = true;
    }

    public String getLocalPatternChars() {
        return this.localPatternChars;
    }

    public void setLocalPatternChars(String newLocalPatternChars) {
        this.localPatternChars = newLocalPatternChars.toString();
    }

    public Object clone() {
        try {
            DateFormatSymbols other = (DateFormatSymbols)super.clone();
            this.copyMembers(this, other);
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        int hashcode = 0;
        String[][] zoneStrings = this.getZoneStringsWrapper();
        for (int index = 0; index < zoneStrings[0].length; ++index) {
            hashcode ^= zoneStrings[0][index].hashCode();
        }
        return hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DateFormatSymbols that = (DateFormatSymbols)obj;
        return Arrays.equals(this.eras, that.eras) && Arrays.equals(this.months, that.months) && Arrays.equals(this.shortMonths, that.shortMonths) && Arrays.equals(this.weekdays, that.weekdays) && Arrays.equals(this.shortWeekdays, that.shortWeekdays) && Arrays.equals(this.ampms, that.ampms) && Arrays.deepEquals((Object[])this.getZoneStringsWrapper(), (Object[])that.getZoneStringsWrapper()) && (this.localPatternChars != null && this.localPatternChars.equals(that.localPatternChars) || this.localPatternChars == null && that.localPatternChars == null);
    }

    private void initializeData(Locale desiredLocale) {
        DateFormatSymbols dfs;
        this.locale = desiredLocale;
        SoftReference ref = (SoftReference)cachedInstances.get(this.locale);
        if (ref != null && (dfs = (DateFormatSymbols)ref.get()) != null) {
            this.copyMembers(dfs, this);
            return;
        }
    }

    private static String[] toOneBasedArray(String[] src) {
        int len = src.length;
        String[] dst = new String[len + 1];
        dst[0] = "";
        for (int i = 0; i < len; ++i) {
            dst[i + 1] = src[i];
        }
        return dst;
    }

    final int getZoneIndex(String ID) {
        String[][] zoneStrings = this.getZoneStringsWrapper();
        for (int index = 0; index < zoneStrings.length; ++index) {
            if (!ID.equals(zoneStrings[index][0])) continue;
            return index;
        }
        return -1;
    }

    final String[][] getZoneStringsWrapper() {
        if (this.isSubclassObject()) {
            return this.getZoneStrings();
        }
        return this.getZoneStringsImpl(false);
    }

    private final String[][] getZoneStringsImpl(boolean needsCopy) {
        if (this.zoneStrings == null) {
            // empty if block
        }
        if (!needsCopy) {
            return this.zoneStrings;
        }
        int len = this.zoneStrings.length;
        String[][] aCopy = new String[len][];
        for (int i = 0; i < len; ++i) {
            aCopy[i] = Arrays.copyOf(this.zoneStrings[i], this.zoneStrings[i].length);
        }
        return aCopy;
    }

    private final boolean isSubclassObject() {
        return !this.getClass().getName().equals("java.text.DateFormatSymbols");
    }

    private final void copyMembers(DateFormatSymbols src, DateFormatSymbols dst) {
        dst.eras = Arrays.copyOf(src.eras, src.eras.length);
        dst.months = Arrays.copyOf(src.months, src.months.length);
        dst.shortMonths = Arrays.copyOf(src.shortMonths, src.shortMonths.length);
        dst.weekdays = Arrays.copyOf(src.weekdays, src.weekdays.length);
        dst.shortWeekdays = Arrays.copyOf(src.shortWeekdays, src.shortWeekdays.length);
        dst.ampms = Arrays.copyOf(src.ampms, src.ampms.length);
        dst.zoneStrings = src.zoneStrings != null ? src.getZoneStringsImpl(true) : (String[][])null;
        dst.localPatternChars = src.localPatternChars;
    }
}

