/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;
import org.apidesign.bck2brwsr.core.JavaScriptBody;
import org.apidesign.bck2brwsr.core.JavaScriptPrototype;

@JavaScriptPrototype(container="Boolean.prototype", prototype="new Boolean")
public final class Boolean
implements Serializable,
Comparable<Boolean> {
    public static final Boolean TRUE = new Boolean(true);
    public static final Boolean FALSE = new Boolean(false);
    public static final Class<Boolean> TYPE = Class.getPrimitiveClass("boolean");
    private final boolean value;
    private static final long serialVersionUID = -3665804199014368530L;

    public Boolean(boolean value) {
        this.value = value;
    }

    public Boolean(String s) {
        this(Boolean.toBoolean(s));
    }

    public static boolean parseBoolean(String s) {
        return Boolean.toBoolean(s);
    }

    @JavaScriptBody(args={}, body="return this.valueOf();")
    public boolean booleanValue() {
        return this.value;
    }

    public static Boolean valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static Boolean valueOf(String s) {
        return Boolean.toBoolean(s) ? TRUE : FALSE;
    }

    public static String toString(boolean b) {
        return b ? "true" : "false";
    }

    public String toString() {
        return this.value ? "true" : "false";
    }

    public int hashCode() {
        return this.value ? 1231 : 1237;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Boolean) {
            return this.value == (Boolean)obj;
        }
        return false;
    }

    public static boolean getBoolean(String name) {
        boolean result = false;
        try {
            result = Boolean.toBoolean(AbstractStringBuilder.getProperty(name));
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public int compareTo(Boolean b) {
        return Boolean.compare(this.value, b.value);
    }

    public static int compare(boolean x, boolean y) {
        return x == y ? 0 : (x ? 1 : -1);
    }

    private static boolean toBoolean(String name) {
        return name != null && name.equalsIgnoreCase("true");
    }

    @JavaScriptBody(args={}, body="var bc = vm.java_lang_Boolean(false);\nbc.valueOf = function() { return this._value() ? true : false; };\nbc.toString = function() { return this.valueOf().toString(); };\n")
    private static native void initValueOf();

    static {
        Boolean.initValueOf();
    }
}

