/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.bck2brwsr.emul.reflect;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.apidesign.bck2brwsr.core.JavaScriptBody;
import org.apidesign.bck2brwsr.emul.reflect.MethodImpl;

public final class ProxyImpl
implements Serializable {
    private static final long serialVersionUID = -2222568056686623797L;
    private static final String proxyClassNamePrefix = "$Proxy";
    private static final Class[] constructorParams = new Class[]{InvocationHandler.class};
    private static Map<ClassLoader, Map<List<String>, Object>> loaderToCache = new WeakHashMap<ClassLoader, Map<List<String>, Object>>();
    private static Object pendingGenerationMarker = new Object();
    private static long nextUniqueNumber = 0L;
    private static Object nextUniqueNumberLock = new Object();
    private static Map<Class<?>, Void> proxyClasses = Collections.synchronizedMap(new WeakHashMap());
    protected InvocationHandler h;

    private ProxyImpl() {
    }

    protected ProxyImpl(InvocationHandler h) {
        this.h = h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> getProxyClass(ClassLoader loader, Class<?> ... interfaces) throws IllegalArgumentException {
        Map<List<String>, Object> cache;
        Map<List<String>, Object> interfaceClass;
        if (interfaces.length > 65535) {
            throw new IllegalArgumentException("interface limit exceeded");
        }
        Class proxyClass = null;
        String[] interfaceNames = new String[interfaces.length];
        HashSet<Map<List<String>, Object>> interfaceSet = new HashSet<Map<List<String>, Object>>();
        for (int i = 0; i < interfaces.length; ++i) {
            String interfaceName = interfaces[i].getName();
            interfaceClass = null;
            try {
                interfaceClass = Class.forName(interfaceName, false, loader);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (interfaceClass != interfaces[i]) {
                throw new IllegalArgumentException(interfaces[i] + " is not visible from class loader");
            }
            if (!((Class)((Object)interfaceClass)).isInterface()) {
                throw new IllegalArgumentException(((Class)((Object)interfaceClass)).getName() + " is not an interface");
            }
            if (interfaceSet.contains(interfaceClass)) {
                throw new IllegalArgumentException("repeated interface: " + ((Class)((Object)interfaceClass)).getName());
            }
            interfaceSet.add(interfaceClass);
            interfaceNames[i] = interfaceName;
        }
        List<String> key = Arrays.asList(interfaceNames);
        interfaceClass = loaderToCache;
        synchronized (interfaceClass) {
            cache = loaderToCache.get(loader);
            if (cache == null) {
                cache = new HashMap<List<String>, Object>();
                loaderToCache.put(loader, cache);
            }
        }
        interfaceClass = cache;
        synchronized (interfaceClass) {
            while (true) {
                Object value;
                if ((value = cache.get(key)) instanceof Reference) {
                    proxyClass = (Class)((Reference)value).get();
                }
                if (proxyClass != null) {
                    return proxyClass;
                }
                if (value != pendingGenerationMarker) break;
                try {
                    cache.wait();
                }
                catch (InterruptedException e) {}
            }
            cache.put(key, pendingGenerationMarker);
        }
        try {
            long num;
            Object name;
            String proxyPkg = null;
            for (int i = 0; i < interfaces.length; ++i) {
                String pkg;
                int flags = interfaces[i].getModifiers();
                if (Modifier.isPublic(flags)) continue;
                name = interfaces[i].getName();
                int n = ((String)name).lastIndexOf(46);
                String string = pkg = n == -1 ? "" : ((String)name).substring(0, n + 1);
                if (proxyPkg == null) {
                    proxyPkg = pkg;
                    continue;
                }
                if (pkg.equals(proxyPkg)) continue;
                throw new IllegalArgumentException("non-public interfaces from different packages");
            }
            if (proxyPkg == null) {
                proxyPkg = "";
            }
            name = nextUniqueNumberLock;
            synchronized (name) {
                num = nextUniqueNumber++;
            }
            String proxyName = proxyPkg + proxyClassNamePrefix + num;
            Generator gen = new Generator(proxyName, interfaces);
            byte[] proxyClassFile = gen.generateClassFile();
            try {
                proxyClass = ProxyImpl.defineClass0(loader, proxyName, proxyClassFile);
            }
            catch (ClassFormatError e) {
                throw new IllegalArgumentException(e.toString());
            }
            gen.fillInMethods(proxyClass);
            proxyClasses.put(proxyClass, null);
        }
        finally {
            Map<List<String>, Object> map = cache;
            synchronized (map) {
                if (proxyClass != null) {
                    cache.put(key, new WeakReference<Class>(proxyClass));
                } else {
                    cache.remove(key);
                }
                cache.notifyAll();
            }
        }
        return proxyClass;
    }

    public static Object newProxyInstance(ClassLoader loader, Class<?>[] interfaces, InvocationHandler h) throws IllegalArgumentException {
        if (h == null) {
            throw new NullPointerException();
        }
        Class<?> cl = ProxyImpl.getProxyClass(loader, interfaces);
        try {
            Constructor<?> cons = cl.getConstructor(constructorParams);
            return cons.newInstance(h);
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new InternalError(e.toString());
        }
        catch (InstantiationException e) {
            throw new InternalError(e.toString());
        }
        catch (InvocationTargetException e) {
            throw new InternalError(e.toString());
        }
    }

    public static boolean isProxyClass(Class<?> cl) {
        if (cl == null) {
            throw new NullPointerException();
        }
        return proxyClasses.containsKey(cl);
    }

    public static InvocationHandler getInvocationHandler(Object proxy) throws IllegalArgumentException {
        if (!ProxyImpl.isProxyClass(proxy.getClass())) {
            throw new IllegalArgumentException("not a proxy instance");
        }
        ProxyImpl p = (ProxyImpl)proxy;
        return p.h;
    }

    @JavaScriptBody(args={"ignore", "name", "byteCode"}, body="var r = vm['_reload'];if (!r) r = exports['_reload'];return r(name, byteCode).constructor.$class;")
    private static native Class defineClass0(ClassLoader var0, String var1, byte[] var2);

    private static class Generator {
        private static final int CLASSFILE_MAJOR_VERSION = 50;
        private static final int CLASSFILE_MINOR_VERSION = 0;
        private static final int CONSTANT_UTF8 = 1;
        private static final int CONSTANT_UNICODE = 2;
        private static final int CONSTANT_INTEGER = 3;
        private static final int CONSTANT_FLOAT = 4;
        private static final int CONSTANT_LONG = 5;
        private static final int CONSTANT_DOUBLE = 6;
        private static final int CONSTANT_CLASS = 7;
        private static final int CONSTANT_STRING = 8;
        private static final int CONSTANT_FIELD = 9;
        private static final int CONSTANT_METHOD = 10;
        private static final int CONSTANT_INTERFACEMETHOD = 11;
        private static final int CONSTANT_NAMEANDTYPE = 12;
        private static final int ACC_PUBLIC = 1;
        private static final int ACC_FINAL = 16;
        private static final int ACC_SUPER = 32;
        private static final String superclassName = "java/lang/reflect/Proxy";
        private static final String handlerFieldName = "h";
        private static Method hashCodeMethod;
        private static Method equalsMethod;
        private static Method toStringMethod;
        private String className;
        private Class[] interfaces;
        private ConstantPool cp = new ConstantPool();
        private Map<String, List<ProxyMethod>> proxyMethods = new HashMap<String, List<ProxyMethod>>();
        private int proxyMethodCount = 0;

        private Generator(String className, Class[] interfaces) {
            this.className = className;
            this.interfaces = interfaces;
        }

        private byte[] generateClassFile() {
            this.addProxyMethod(hashCodeMethod, Object.class);
            this.addProxyMethod(equalsMethod, Object.class);
            this.addProxyMethod(toStringMethod, Object.class);
            for (int i = 0; i < this.interfaces.length; ++i) {
                Method[] methods = this.interfaces[i].getMethods();
                for (int j = 0; j < methods.length; ++j) {
                    this.addProxyMethod(methods[j], this.interfaces[i]);
                }
            }
            for (List<ProxyMethod> sigmethods : this.proxyMethods.values()) {
                Generator.checkReturnTypes(sigmethods);
            }
            this.cp.getClass(Generator.dotToSlash(this.className));
            this.cp.getClass(superclassName);
            for (int i = 0; i < this.interfaces.length; ++i) {
                this.cp.getClass(Generator.dotToSlash(this.interfaces[i].getName()));
            }
            this.cp.setReadOnly();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            try {
                dout.writeInt(-889275714);
                dout.writeShort(0);
                dout.writeShort(50);
                this.cp.write(dout);
                dout.writeShort(49);
                dout.writeShort(this.cp.getClass(Generator.dotToSlash(this.className)));
                dout.writeShort(this.cp.getClass(superclassName));
                dout.writeShort(this.interfaces.length);
                for (int i = 0; i < this.interfaces.length; ++i) {
                    dout.writeShort(this.cp.getClass(Generator.dotToSlash(this.interfaces[i].getName())));
                }
                dout.writeShort(0);
                dout.writeShort(0);
                dout.writeShort(0);
            }
            catch (IOException e) {
                throw new InternalError("unexpected I/O Exception");
            }
            return bout.toByteArray();
        }

        @JavaScriptBody(args={"c", "sig", "method", "primitive"}, body="var p = c.cnstr.prototype;\np[sig] = function() {\n  var h = this['_h']();\n  var res = h['invoke__Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_reflect_Method_2_3Ljava_lang_Object_2'](this, method, arguments);\n  \n  \n  return res;\n};")
        private static native void defineMethod(Class<?> var0, String var1, Method var2, boolean var3);

        @JavaScriptBody(args={"c"}, body="var h = c.cnstr['cons__VLjava_lang_reflect_InvocationHandler_2'] = function(h) {\n  c.superclass.cnstr['cons__VLjava_lang_reflect_InvocationHandler_2'].call(this, h);\n}\nh.cls = c.cnstr;\n")
        private static native void defineConstructor(Class<?> var0);

        final void fillInMethods(Class<?> proxyClass) {
            for (List<ProxyMethod> sigmethods : this.proxyMethods.values()) {
                for (ProxyMethod pm : sigmethods) {
                    String sig = MethodImpl.toSignature((Method)pm.method);
                    Generator.defineMethod(proxyClass, sig, pm.method, pm.method.getReturnType().isPrimitive());
                }
            }
            Generator.defineConstructor(proxyClass);
        }

        private void addProxyMethod(Method m, Class fromClass) {
            String name = m.getName();
            Class[] parameterTypes = m.getParameterTypes();
            Class<?> returnType = m.getReturnType();
            Class[] exceptionTypes = m.getExceptionTypes();
            String sig = MethodImpl.toSignature((Method)m);
            List<ProxyMethod> sigmethods = this.proxyMethods.get(sig);
            if (sigmethods != null) {
                for (ProxyMethod pm : sigmethods) {
                    if (returnType != pm.returnType) continue;
                    ArrayList legalExceptions = new ArrayList();
                    Generator.collectCompatibleTypes(exceptionTypes, pm.exceptionTypes, legalExceptions);
                    Generator.collectCompatibleTypes(pm.exceptionTypes, exceptionTypes, legalExceptions);
                    pm.exceptionTypes = new Class[legalExceptions.size()];
                    pm.exceptionTypes = legalExceptions.toArray(pm.exceptionTypes);
                    return;
                }
            } else {
                sigmethods = new ArrayList<ProxyMethod>(3);
                this.proxyMethods.put(sig, sigmethods);
            }
            sigmethods.add(new ProxyMethod(m, name, parameterTypes, returnType, exceptionTypes, fromClass));
        }

        private static void checkReturnTypes(List<ProxyMethod> methods) {
            if (methods.size() < 2) {
                return;
            }
            LinkedList<Class> uncoveredReturnTypes = new LinkedList<Class>();
            block0: for (ProxyMethod pm : methods) {
                Class newReturnType = pm.returnType;
                if (newReturnType.isPrimitive()) {
                    throw new IllegalArgumentException("methods with same signature " + Generator.getFriendlyMethodSignature(pm.methodName, pm.parameterTypes) + " but incompatible return types: " + newReturnType.getName() + " and others");
                }
                boolean added = false;
                ListIterator<Class> liter = uncoveredReturnTypes.listIterator();
                while (liter.hasNext()) {
                    Class uncoveredReturnType = (Class)liter.next();
                    if (newReturnType.isAssignableFrom(uncoveredReturnType)) {
                        assert (!added);
                        continue block0;
                    }
                    if (!uncoveredReturnType.isAssignableFrom(newReturnType)) continue;
                    if (!added) {
                        liter.set(newReturnType);
                        added = true;
                        continue;
                    }
                    liter.remove();
                }
                if (added) continue;
                uncoveredReturnTypes.add(newReturnType);
            }
            if (uncoveredReturnTypes.size() > 1) {
                ProxyMethod pm = methods.get(0);
                throw new IllegalArgumentException("methods with same signature " + Generator.getFriendlyMethodSignature(pm.methodName, pm.parameterTypes) + " but incompatible return types: " + uncoveredReturnTypes);
            }
        }

        private static String dotToSlash(String name) {
            return name.replace('.', '/');
        }

        private static String getParameterDescriptors(Class[] parameterTypes) {
            StringBuilder desc = new StringBuilder("(");
            for (int i = 0; i < parameterTypes.length; ++i) {
                desc.append(Generator.getFieldType(parameterTypes[i]));
            }
            desc.append(')');
            return desc.toString();
        }

        private static String getFieldType(Class type) {
            if (type.isPrimitive()) {
                return PrimitiveTypeInfo.get((Class)type).baseTypeString;
            }
            if (type.isArray()) {
                return type.getName().replace('.', '/');
            }
            return "L" + Generator.dotToSlash(type.getName()) + ";";
        }

        private static String getFriendlyMethodSignature(String name, Class[] parameterTypes) {
            StringBuilder sig = new StringBuilder(name);
            sig.append('(');
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (i > 0) {
                    sig.append(',');
                }
                Class<?> parameterType = parameterTypes[i];
                int dimensions = 0;
                while (parameterType.isArray()) {
                    parameterType = parameterType.getComponentType();
                    ++dimensions;
                }
                sig.append(parameterType.getName());
                while (dimensions-- > 0) {
                    sig.append("[]");
                }
            }
            sig.append(')');
            return sig.toString();
        }

        private static void collectCompatibleTypes(Class<?>[] from, Class<?>[] with, List<Class<?>> list) {
            block0: for (int i = 0; i < from.length; ++i) {
                if (list.contains(from[i])) continue;
                for (int j = 0; j < with.length; ++j) {
                    if (!with[j].isAssignableFrom(from[i])) continue;
                    list.add(from[i]);
                    continue block0;
                }
            }
        }

        static {
            try {
                hashCodeMethod = Object.class.getMethod("hashCode", new Class[0]);
                equalsMethod = Object.class.getMethod("equals", Object.class);
                toStringMethod = Object.class.getMethod("toString", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }

        private static class ConstantPool {
            private List<Entry> pool = new ArrayList<Entry>(32);
            private Map<Object, Short> map = new HashMap<Object, Short>(16);
            private boolean readOnly = false;

            private ConstantPool() {
            }

            public short getUtf8(String s) {
                if (s == null) {
                    throw new NullPointerException();
                }
                return this.getValue(s);
            }

            public short getInteger(int i) {
                return this.getValue(new Integer(i));
            }

            public short getFloat(float f) {
                return this.getValue(new Float(f));
            }

            public short getClass(String name) {
                short utf8Index = this.getUtf8(name);
                return this.getIndirect(new IndirectEntry(7, utf8Index));
            }

            public short getString(String s) {
                short utf8Index = this.getUtf8(s);
                return this.getIndirect(new IndirectEntry(8, utf8Index));
            }

            public short getFieldRef(String className, String name, String descriptor) {
                short classIndex = this.getClass(className);
                short nameAndTypeIndex = this.getNameAndType(name, descriptor);
                return this.getIndirect(new IndirectEntry(9, classIndex, nameAndTypeIndex));
            }

            public short getMethodRef(String className, String name, String descriptor) {
                short classIndex = this.getClass(className);
                short nameAndTypeIndex = this.getNameAndType(name, descriptor);
                return this.getIndirect(new IndirectEntry(10, classIndex, nameAndTypeIndex));
            }

            public short getInterfaceMethodRef(String className, String name, String descriptor) {
                short classIndex = this.getClass(className);
                short nameAndTypeIndex = this.getNameAndType(name, descriptor);
                return this.getIndirect(new IndirectEntry(11, classIndex, nameAndTypeIndex));
            }

            public short getNameAndType(String name, String descriptor) {
                short nameIndex = this.getUtf8(name);
                short descriptorIndex = this.getUtf8(descriptor);
                return this.getIndirect(new IndirectEntry(12, nameIndex, descriptorIndex));
            }

            public void setReadOnly() {
                this.readOnly = true;
            }

            public void write(OutputStream out) throws IOException {
                DataOutputStream dataOut = new DataOutputStream(out);
                dataOut.writeShort(this.pool.size() + 1);
                for (Entry e : this.pool) {
                    e.write(dataOut);
                }
            }

            private short addEntry(Entry entry) {
                this.pool.add(entry);
                if (this.pool.size() >= 65535) {
                    throw new IllegalArgumentException("constant pool size limit exceeded");
                }
                return (short)this.pool.size();
            }

            private short getValue(Object key) {
                Short index = this.map.get(key);
                if (index != null) {
                    return index;
                }
                if (this.readOnly) {
                    throw new InternalError("late constant pool addition: " + key);
                }
                short i = this.addEntry(new ValueEntry(key));
                this.map.put(key, new Short(i));
                return i;
            }

            private short getIndirect(IndirectEntry e) {
                Short index = this.map.get(e);
                if (index != null) {
                    return index;
                }
                if (this.readOnly) {
                    throw new InternalError("late constant pool addition");
                }
                short i = this.addEntry(e);
                this.map.put(e, new Short(i));
                return i;
            }

            private static class IndirectEntry
            extends Entry {
                private int tag;
                private short index0;
                private short index1;

                public IndirectEntry(int tag, short index) {
                    this.tag = tag;
                    this.index0 = index;
                    this.index1 = 0;
                }

                public IndirectEntry(int tag, short index0, short index1) {
                    this.tag = tag;
                    this.index0 = index0;
                    this.index1 = index1;
                }

                @Override
                public void write(DataOutputStream out) throws IOException {
                    out.writeByte(this.tag);
                    out.writeShort(this.index0);
                    if (this.tag == 9 || this.tag == 10 || this.tag == 11 || this.tag == 12) {
                        out.writeShort(this.index1);
                    }
                }

                public int hashCode() {
                    return this.tag + this.index0 + this.index1;
                }

                public boolean equals(Object obj) {
                    if (obj instanceof IndirectEntry) {
                        IndirectEntry other = (IndirectEntry)obj;
                        if (this.tag == other.tag && this.index0 == other.index0 && this.index1 == other.index1) {
                            return true;
                        }
                    }
                    return false;
                }
            }

            private static class ValueEntry
            extends Entry {
                private Object value;

                public ValueEntry(Object value) {
                    this.value = value;
                }

                @Override
                public void write(DataOutputStream out) throws IOException {
                    if (this.value instanceof String) {
                        out.writeByte(1);
                        out.writeUTF((String)this.value);
                    } else if (this.value instanceof Integer) {
                        out.writeByte(3);
                        out.writeInt((Integer)this.value);
                    } else if (this.value instanceof Float) {
                        out.writeByte(4);
                        out.writeFloat(((Float)this.value).floatValue());
                    } else if (this.value instanceof Long) {
                        out.writeByte(5);
                        out.writeLong((Long)this.value);
                    } else if (this.value instanceof Double) {
                        out.writeDouble(6.0);
                        out.writeDouble((Double)this.value);
                    } else {
                        throw new InternalError("bogus value entry: " + this.value);
                    }
                }
            }

            private static abstract class Entry {
                private Entry() {
                }

                public abstract void write(DataOutputStream var1) throws IOException;
            }
        }

        private static class PrimitiveTypeInfo {
            public String baseTypeString;
            public String wrapperClassName;
            public String wrapperValueOfDesc;
            public String unwrapMethodName;
            public String unwrapMethodDesc;
            private static Map<Class, PrimitiveTypeInfo> table = new HashMap<Class, PrimitiveTypeInfo>();

            private static void add(Class primitiveClass, Class wrapperClass) {
                table.put(primitiveClass, new PrimitiveTypeInfo(primitiveClass, wrapperClass));
            }

            private PrimitiveTypeInfo(Class primitiveClass, Class wrapperClass) {
                assert (primitiveClass.isPrimitive());
                this.baseTypeString = Array.newInstance(primitiveClass, 0).getClass().getName().substring(1);
                this.wrapperClassName = Generator.dotToSlash(wrapperClass.getName());
                this.wrapperValueOfDesc = "(" + this.baseTypeString + ")L" + this.wrapperClassName + ";";
                this.unwrapMethodName = primitiveClass.getName() + "Value";
                this.unwrapMethodDesc = "()" + this.baseTypeString;
            }

            public static PrimitiveTypeInfo get(Class cl) {
                return table.get(cl);
            }

            static {
                PrimitiveTypeInfo.add(Byte.TYPE, Byte.class);
                PrimitiveTypeInfo.add(Character.TYPE, Character.class);
                PrimitiveTypeInfo.add(Double.TYPE, Double.class);
                PrimitiveTypeInfo.add(Float.TYPE, Float.class);
                PrimitiveTypeInfo.add(Integer.TYPE, Integer.class);
                PrimitiveTypeInfo.add(Long.TYPE, Long.class);
                PrimitiveTypeInfo.add(Short.TYPE, Short.class);
                PrimitiveTypeInfo.add(Boolean.TYPE, Boolean.class);
            }
        }

        private class ProxyMethod {
            private final Method method;
            public String methodName;
            public Class[] parameterTypes;
            public Class returnType;
            public Class[] exceptionTypes;
            public Class fromClass;
            public String methodFieldName;

            private ProxyMethod(Method m, String methodName, Class[] parameterTypes, Class returnType, Class[] exceptionTypes, Class fromClass) {
                this.method = m;
                this.methodName = methodName;
                this.parameterTypes = parameterTypes;
                this.returnType = returnType;
                this.exceptionTypes = exceptionTypes;
                this.fromClass = fromClass;
                this.methodFieldName = "m" + Generator.this.proxyMethodCount++;
            }
        }
    }
}

