/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;

public class AtomicBoolean
implements Serializable {
    private static final long serialVersionUID = 4654671469794556979L;
    private volatile int value;

    public AtomicBoolean(boolean initialValue) {
        this.value = initialValue ? 1 : 0;
    }

    public AtomicBoolean() {
    }

    public final boolean get() {
        return this.value != 0;
    }

    public final boolean compareAndSet(boolean expect, boolean update) {
        int u;
        int e = expect ? 1 : 0;
        int n = u = update ? 1 : 0;
        if (this.value == e) {
            this.value = u;
            return true;
        }
        return false;
    }

    public boolean weakCompareAndSet(boolean expect, boolean update) {
        return this.compareAndSet(expect, update);
    }

    public final void set(boolean newValue) {
        this.value = newValue ? 1 : 0;
    }

    public final void lazySet(boolean newValue) {
        this.set(newValue);
    }

    public final boolean getAndSet(boolean newValue) {
        boolean current;
        while (!this.compareAndSet(current = this.get(), newValue)) {
        }
        return current;
    }

    public String toString() {
        return Boolean.toString(this.get());
    }
}

