/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.Method;
import org.apidesign.bck2brwsr.core.Exported;
import org.apidesign.bck2brwsr.core.JavaScriptPrototype;

@JavaScriptPrototype(prototype="new Array", container="Array.prototype")
public final class Array {
    private Array() {
    }

    public static Object newInstance(Class<?> componentType, int length) throws NegativeArraySizeException {
        if (length < 0) {
            throw new NegativeArraySizeException();
        }
        String sig = Method.findArraySignature(componentType);
        return Array.newArray(componentType.isPrimitive(), sig, null, length);
    }

    public static Object newInstance(Class<?> componentType, int ... dimensions) throws IllegalArgumentException, NegativeArraySizeException {
        StringBuilder sig = new StringBuilder();
        for (int i = 1; i < dimensions.length; ++i) {
            sig.append('[');
        }
        sig.append(Method.findArraySignature(componentType));
        return Array.multiNewArray(sig.toString(), dimensions, 0);
    }

    public static int getLength(Object array) throws IllegalArgumentException {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Argument is not an array");
        }
        return Method.arrayLength(array);
    }

    public static Object get(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> t = array.getClass().getComponentType();
        if (t.isPrimitive()) {
            return Array.fromPrimitive(t, array, index);
        }
        return ((Object[])array)[index];
    }

    public static native boolean getBoolean(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static byte getByte(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (!Method.samePrimitive(array.getClass().getComponentType(), Byte.TYPE)) {
            throw new IllegalArgumentException();
        }
        byte[] arr = (byte[])array;
        return arr[index];
    }

    public static native char getChar(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static short getShort(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> t = array.getClass().getComponentType();
        if (Method.samePrimitive(t, Short.TYPE)) {
            short[] arr = (short[])array;
            return arr[index];
        }
        return Array.getByte(array, index);
    }

    public static int getInt(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> t = array.getClass().getComponentType();
        if (Method.samePrimitive(t, Integer.TYPE)) {
            int[] arr = (int[])array;
            return arr[index];
        }
        return Array.getShort(array, index);
    }

    public static long getLong(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> t = array.getClass().getComponentType();
        if (Method.samePrimitive(t, Long.TYPE)) {
            long[] arr = (long[])array;
            return arr[index];
        }
        return Array.getInt(array, index);
    }

    public static float getFloat(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> t = array.getClass().getComponentType();
        if (Method.samePrimitive(t, Float.TYPE)) {
            float[] arr = (float[])array;
            return arr[index];
        }
        return Array.getLong(array, index);
    }

    public static double getDouble(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> t = array.getClass().getComponentType();
        if (Method.samePrimitive(t, Double.TYPE)) {
            double[] arr = (double[])array;
            return arr[index];
        }
        return Array.getFloat(array, index);
    }

    public static void set(Object array, int index, Object value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array.getClass().getComponentType().isPrimitive()) {
            throw new IllegalArgumentException();
        }
        Object[] arr = (Object[])array;
        arr[index] = value;
    }

    public static native void setBoolean(Object var0, int var1, boolean var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static void setByte(Object array, int index, byte b) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> t = array.getClass().getComponentType();
        if (Method.samePrimitive(t, Byte.TYPE)) {
            byte[] arr = (byte[])array;
            arr[index] = b;
        } else {
            Array.setShort(array, index, b);
        }
    }

    public static native void setChar(Object var0, int var1, char var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static void setShort(Object array, int index, short s) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> t = array.getClass().getComponentType();
        if (Method.samePrimitive(t, Short.TYPE)) {
            short[] arr = (short[])array;
            arr[index] = s;
        } else {
            Array.setInt(array, index, s);
        }
    }

    public static void setInt(Object array, int index, int i) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> t = array.getClass().getComponentType();
        if (Method.samePrimitive(t, Integer.TYPE)) {
            int[] arr = (int[])array;
            arr[index] = i;
        } else {
            Array.setLong(array, index, i);
        }
    }

    public static void setLong(Object array, int index, long l) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> t = array.getClass().getComponentType();
        if (Method.samePrimitive(t, Long.TYPE)) {
            long[] arr = (long[])array;
            arr[index] = l;
        } else {
            Array.setFloat(array, index, l);
        }
    }

    public static void setFloat(Object array, int index, float f) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> t = array.getClass().getComponentType();
        if (Method.samePrimitive(t, Float.TYPE)) {
            float[] arr = (float[])array;
            arr[index] = f;
        } else {
            Array.setDouble(array, index, f);
        }
    }

    public static void setDouble(Object array, int index, double d) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> t = array.getClass().getComponentType();
        if (!Method.samePrimitive(t, Double.TYPE)) {
            throw new IllegalArgumentException("argument type mismatch");
        }
        double[] arr = (double[])array;
        arr[index] = d;
    }

    @Exported
    private static Object newArray(boolean primitive, String sig, Object fn, int length) {
        return Method.newArray(primitive, sig, fn, length);
    }

    @Exported
    private static boolean isInstance(Object arr, String sig) {
        if (arr == null) {
            return false;
        }
        return sig.equals(arr.getClass().getName());
    }

    @Exported
    private static boolean isInstance(Object arr, int dimensions, Object fn) throws ClassNotFoundException {
        if (arr == null) {
            return false;
        }
        Class<?> c = arr.getClass();
        while (dimensions-- > 0) {
            if ((c = c.getComponentType()) != null) continue;
            return false;
        }
        Class<?> t = Method.classFromFn(fn);
        return t.isAssignableFrom(c);
    }

    @Exported
    private static Object multiNewArray(String sig, int[] dims, Object fn) throws IllegalArgumentException, NegativeArraySizeException {
        return Array.multiNewArray(sig, dims, 0, fn);
    }

    private static Object multiNewArray(String sig, int[] dims, int index, Object fn) throws IllegalArgumentException, NegativeArraySizeException {
        if (dims.length == index + 1) {
            return Array.newArray(sig.length() == 2, sig, fn, dims[index]);
        }
        Object arr = Array.newArray(false, sig, null, dims[index]);
        String compsig = sig.substring(1);
        int len = Array.getLength(arr);
        for (int i = 0; i < len; ++i) {
            Method.setArray(arr, i, Array.multiNewArray(compsig, dims, index + 1, fn));
        }
        return arr;
    }

    private static Object fromPrimitive(Class<?> t, Object array, int index) {
        return Method.fromPrimitive(t, Method.atArray(array, index));
    }
}

