/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import org.apidesign.bck2brwsr.core.JavaScriptBody;

public final class Integer
extends Number
implements Comparable<Integer> {
    public static final int MIN_VALUE = -2147483648;
    public static final int MAX_VALUE = 0x7FFFFFFF;
    public static final Class<Integer> TYPE = Class.getPrimitiveClass("int");
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private final int value;
    public static final int SIZE = 32;
    private static final long serialVersionUID = 1360826667806852920L;

    public static String toString(int i, int radix) {
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        if (radix == 10) {
            return Integer.toString(i);
        }
        char[] buf = new char[33];
        boolean negative = i < 0;
        int charPos = 32;
        if (!negative) {
            i = -i;
        }
        while (i <= -radix) {
            buf[charPos--] = digits[-(i % radix)];
            i /= radix;
        }
        buf[charPos] = digits[-i];
        if (negative) {
            buf[--charPos] = 45;
        }
        return new String(buf, charPos, 33 - charPos);
    }

    public static String toHexString(int i) {
        return Integer.toUnsignedString(i, 4);
    }

    public static String toOctalString(int i) {
        return Integer.toUnsignedString(i, 3);
    }

    public static String toBinaryString(int i) {
        return Integer.toUnsignedString(i, 1);
    }

    private static String toUnsignedString(int i, int shift) {
        char[] buf = new char[32];
        int charPos = 32;
        int radix = 1 << shift;
        int mask = radix - 1;
        do {
            buf[--charPos] = digits[i & mask];
        } while ((i >>>= shift) != 0);
        return new String(buf, charPos, 32 - charPos);
    }

    @JavaScriptBody(args={"i"}, body="return i.toString();")
    public static String toString(int i) {
        if (i == Integer.MIN_VALUE) {
            return "-2147483648";
        }
        int size = i < 0 ? Integer.stringSize(-i) + 1 : Integer.stringSize(i);
        char[] buf = new char[size];
        Integer.getChars(i, size, buf);
        return new String(buf, 0, size);
    }

    static void getChars(int i, int index, char[] buf) {
        int r;
        int q;
        int charPos = index;
        int sign = 0;
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = digits[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    static int stringSize(int x) {
        int i = 0;
        while (x > sizeTable[i]) {
            ++i;
        }
        return i + 1;
    }

    @JavaScriptBody(args={"s", "radix"}, body="return parseInt(s,radix);")
    public static int parseInt(String s, int radix) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
        }
        if (radix > 36) {
            throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
        }
        int result = 0;
        boolean negative = false;
        int i = 0;
        int len = s.length();
        int limit = -2147483647;
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Integer.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw NumberFormatException.forInputString(s);
                }
                if (len == 1) {
                    throw NumberFormatException.forInputString(s);
                }
                ++i;
            }
            int multmin = limit / radix;
            while (i < len) {
                int digit;
                if ((digit = Character.digit(s.charAt(i++), radix)) < 0) {
                    throw NumberFormatException.forInputString(s);
                }
                if (result < multmin) {
                    throw NumberFormatException.forInputString(s);
                }
                if ((result *= radix) < limit + digit) {
                    throw NumberFormatException.forInputString(s);
                }
                result -= digit;
            }
        } else {
            throw NumberFormatException.forInputString(s);
        }
        return negative ? result : -result;
    }

    public static int parseInt(String s) throws NumberFormatException {
        return Integer.parseInt(s, 10);
    }

    public static Integer valueOf(String s, int radix) throws NumberFormatException {
        return Integer.parseInt(s, radix);
    }

    public static Integer valueOf(String s) throws NumberFormatException {
        return Integer.parseInt(s, 10);
    }

    public static Integer valueOf(int i) {
        if (i >= -128 && i <= IntegerCache.high) {
            return IntegerCache.cache[i + 128];
        }
        return new Integer(i);
    }

    public Integer(int value) {
        this.value = value;
    }

    public Integer(String s) throws NumberFormatException {
        this.value = Integer.parseInt(s, 10);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Integer) {
            return this.value == (Integer)obj;
        }
        return false;
    }

    public static Integer getInteger(String nm) {
        return Integer.getInteger(nm, null);
    }

    public static Integer getInteger(String nm, int val) {
        Integer result = Integer.getInteger(nm, null);
        return result == null ? Integer.valueOf(val) : result;
    }

    public static Integer getInteger(String nm, Integer val) {
        String v = null;
        try {
            v = AbstractStringBuilder.getProperty(nm);
        }
        catch (IllegalArgumentException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (v != null) {
            try {
                return Integer.decode(v);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return val;
    }

    public static Integer decode(String nm) throws NumberFormatException {
        Integer result;
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (nm.length() == 0) {
            throw new NumberFormatException("Zero length string");
        }
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        if (nm.startsWith("0x", index) || nm.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (nm.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (nm.startsWith("0", index) && nm.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        if (nm.startsWith("-", index) || nm.startsWith("+", index)) {
            throw new NumberFormatException("Sign character in wrong position");
        }
        try {
            result = Integer.valueOf(nm.substring(index), radix);
            result = negative ? Integer.valueOf(-result.intValue()) : result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index) : nm.substring(index);
            result = Integer.valueOf(constant, radix);
        }
        return result;
    }

    @Override
    public int compareTo(Integer anotherInteger) {
        return Integer.compare(this.value, anotherInteger.value);
    }

    public static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static int highestOneBit(int i) {
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        return i - (i >>> 1);
    }

    public static int lowestOneBit(int i) {
        return i & -i;
    }

    public static int numberOfLeadingZeros(int i) {
        if (i == 0) {
            return 32;
        }
        int n = 1;
        if (i >>> 16 == 0) {
            n += 16;
            i <<= 16;
        }
        if (i >>> 24 == 0) {
            n += 8;
            i <<= 8;
        }
        if (i >>> 28 == 0) {
            n += 4;
            i <<= 4;
        }
        if (i >>> 30 == 0) {
            n += 2;
            i <<= 2;
        }
        return n -= i >>> 31;
    }

    public static int numberOfTrailingZeros(int i) {
        if (i == 0) {
            return 32;
        }
        int n = 31;
        int y = i << 16;
        if (y != 0) {
            n -= 16;
            i = y;
        }
        if ((y = i << 8) != 0) {
            n -= 8;
            i = y;
        }
        if ((y = i << 4) != 0) {
            n -= 4;
            i = y;
        }
        if ((y = i << 2) != 0) {
            n -= 2;
            i = y;
        }
        return n - (i << 1 >>> 31);
    }

    public static int bitCount(int i) {
        i -= i >>> 1 & 0x55555555;
        i = (i & 0x33333333) + (i >>> 2 & 0x33333333);
        i = i + (i >>> 4) & 0xF0F0F0F;
        i += i >>> 8;
        i += i >>> 16;
        return i & 0x3F;
    }

    public static int rotateLeft(int i, int distance) {
        return i << distance | i >>> -distance;
    }

    public static int rotateRight(int i, int distance) {
        return i >>> distance | i << -distance;
    }

    public static int reverse(int i) {
        i = (i & 0x55555555) << 1 | i >>> 1 & 0x55555555;
        i = (i & 0x33333333) << 2 | i >>> 2 & 0x33333333;
        i = (i & 0xF0F0F0F) << 4 | i >>> 4 & 0xF0F0F0F;
        i = i << 24 | (i & 0xFF00) << 8 | i >>> 8 & 0xFF00 | i >>> 24;
        return i;
    }

    public static int signum(int i) {
        return i >> 31 | -i >>> 31;
    }

    public static int reverseBytes(int i) {
        return i >>> 24 | i >> 8 & 0xFF00 | i << 8 & 0xFF0000 | i << 24;
    }

    private static class IntegerCache {
        static final int low = -128;
        static final int high;
        static final Integer[] cache;

        private IntegerCache() {
        }

        static {
            int h = 127;
            String integerCacheHighPropValue = AbstractStringBuilder.getProperty("java.lang.Integer.IntegerCache.high");
            if (integerCacheHighPropValue != null) {
                int i = Integer.parseInt(integerCacheHighPropValue);
                i = Math.max(i, 127);
                h = Math.min(i, 0x7FFFFF7F);
            }
            high = h;
            cache = new Integer[high - -128 + 1];
            int j = -128;
            for (int k = 0; k < cache.length; ++k) {
                IntegerCache.cache[k] = new Integer(j++);
            }
        }
    }
}

