/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.bck2brwsr.vmzip;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apidesign.bck2brwsr.core.Exported;
import org.apidesign.bck2brwsr.core.JavaScriptBody;
import org.apidesign.bck2brwsr.emul.zip.FastJar;
import org.apidesign.vm4brwsr.Bck2Brwsr;

@Exported
public final class ZipResources
implements Bck2Brwsr.Resources {
    private final FastJar fj;

    @Exported
    public ZipResources(byte[] zipData) throws IOException {
        this.fj = new FastJar(zipData);
        for (FastJar.Entry e : this.fj.list()) {
            this.putRes(e.name, e);
        }
    }

    @JavaScriptBody(args={"arr"}, body="return arr.length;")
    private static native int length(Object var0);

    @JavaScriptBody(args={"arr", "index", "value"}, body="arr[index] = value; return value;")
    private static native Object set(Object var0, int var1, Object var2);

    @JavaScriptBody(args={"msg"}, body="if (typeof console !== 'undefined') console.log(msg.toString());")
    private static native void log(String var0);

    private byte[] findRes(String res) throws IOException {
        Object arr = this.findResImpl(res);
        if (arr instanceof FastJar.Entry) {
            double bef = ZipResources.timeNow();
            InputStream zip = this.fj.getInputStream((FastJar.Entry)arr);
            arr = ZipResources.readFully(new byte[512], zip);
            this.putRes(res, arr);
            ZipResources.log("Reading " + res + " took " + (ZipResources.timeNow() - bef) + "ms");
        }
        return (byte[])arr;
    }

    public InputStream get(String resource) throws IOException {
        byte[] arr = this.findRes(resource);
        return arr == null ? null : new ByteArrayInputStream(arr);
    }

    @JavaScriptBody(args={"res"}, body="var r = this[res]; return r ? r : null;")
    private native Object findResImpl(String var1);

    @JavaScriptBody(args={"res", "arr"}, body="this[res] = arr;")
    private native void putRes(String var1, Object var2);

    @JavaScriptBody(args={"arr", "len"}, body="while (arr.length < len) arr.push(0);")
    private static native void enlargeBytes(byte[] var0, int var1);

    @JavaScriptBody(args={"arr", "len"}, body="arr.splice(len, arr.length - len);")
    private static native void sliceArray(byte[] var0, int var1);

    private static Object readFully(byte[] arr, InputStream zip) throws IOException {
        int len;
        int offset = 0;
        while ((len = zip.read(arr, offset, arr.length - offset)) != -1) {
            if ((offset += len) != arr.length) continue;
            ZipResources.enlargeBytes(arr, arr.length + 4096);
        }
        ZipResources.sliceArray(arr, offset);
        return arr;
    }

    @JavaScriptBody(args={}, body="if (typeof window.performance === 'undefined') return -1;\nif (typeof window.performance.now === 'undefined') return -1;\nreturn window.performance.now();")
    private static native double timeNow();
}

