/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.bck2brwsr.emul.lang;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apidesign.bck2brwsr.core.Exported;
import org.apidesign.bck2brwsr.emul.lang.System;

@Exported
public abstract class ManifestInputStream
extends FilterInputStream {
    private byte[] buf;
    private int count = 0;
    private int pos = 0;

    protected ManifestInputStream(InputStream in) {
        this(in, 8192);
    }

    protected ManifestInputStream(InputStream in, int size) {
        super(in);
        this.buf = new byte[size];
    }

    @Override
    public int read() throws IOException {
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int avail = this.count - this.pos;
        if (avail <= 0) {
            if (len >= this.buf.length) {
                return this.in.read(b, off, len);
            }
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0) {
                return -1;
            }
        }
        if (len > avail) {
            len = avail;
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    public int readLine(byte[] b, int off, int len) throws IOException {
        int total;
        int n;
        byte[] tbuf = this.buf;
        for (total = 0; total < len; total += n) {
            int avail = this.count - this.pos;
            if (avail <= 0) {
                this.fill();
                avail = this.count - this.pos;
                if (avail <= 0) {
                    return -1;
                }
            }
            if ((n = len - total) > avail) {
                n = avail;
            }
            int tpos = this.pos;
            int maxpos = tpos + n;
            while (tpos < maxpos && tbuf[tpos++] != 10) {
            }
            n = tpos - this.pos;
            System.arraycopy(tbuf, this.pos, b, off, n);
            off += n;
            this.pos = tpos;
            if (tbuf[tpos - 1] != 10) continue;
            break;
        }
        return total;
    }

    public byte peek() throws IOException {
        if (this.pos == this.count) {
            this.fill();
        }
        if (this.pos == this.count) {
            return -1;
        }
        return this.buf[this.pos];
    }

    public int readLine(byte[] b) throws IOException {
        return this.readLine(b, 0, b.length);
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long avail = this.count - this.pos;
        if (avail <= 0L) {
            return this.in.skip(n);
        }
        if (n > avail) {
            n = avail;
        }
        this.pos = (int)((long)this.pos + n);
        return n;
    }

    @Override
    public int available() throws IOException {
        return this.count - this.pos + this.in.available();
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
            this.buf = null;
        }
    }

    private void fill() throws IOException {
        this.pos = 0;
        this.count = 0;
        int n = this.in.read(this.buf, 0, this.buf.length);
        if (n > 0) {
            this.count = n;
        }
    }

    protected abstract String putValue(String var1, String var2);

    public void readAttributes(byte[] lbuf) throws IOException {
        int len;
        ManifestInputStream is = this;
        String name = null;
        String value = null;
        byte[] lastline = null;
        while ((len = is.readLine(lbuf)) != -1) {
            boolean lineContinued = false;
            if (lbuf[--len] != 10) {
                throw new IOException("line too long");
            }
            if (len > 0 && lbuf[len - 1] == 13) {
                --len;
            }
            if (len == 0) break;
            int i = 0;
            if (lbuf[0] == 32) {
                if (name == null) {
                    throw new IOException("misplaced continuation line");
                }
                lineContinued = true;
                byte[] buf = new byte[lastline.length + len - 1];
                System.arraycopy(lastline, 0, buf, 0, lastline.length);
                System.arraycopy(lbuf, 1, buf, lastline.length, len - 1);
                if (is.peek() == 32) {
                    lastline = buf;
                    continue;
                }
                value = new String(buf, 0, buf.length, "UTF8");
                lastline = null;
            } else {
                while (lbuf[i++] != 58) {
                    if (i < len) continue;
                    throw new IOException("invalid header field");
                }
                if (lbuf[i++] != 32) {
                    throw new IOException("invalid header field");
                }
                name = new String(lbuf, 0, 0, i - 2);
                if (is.peek() == 32) {
                    lastline = new byte[len - i];
                    System.arraycopy(lbuf, i, lastline, 0, len - i);
                    continue;
                }
                value = new String(lbuf, i, len - i, "UTF8");
            }
            try {
                if (this.putValue(name, value) == null || lineContinued) continue;
                throw new IOException("Duplicate name in Manifest: " + name + ".\n" + "Ensure that the manifest does not " + "have duplicate entries, and\n" + "that blank lines separate " + "individual sections in both your\n" + "manifest and in the META-INF/MANIFEST.MF " + "entry in the jar file.");
            }
            catch (IllegalArgumentException e) {
                throw new IOException("invalid header field name: " + name);
            }
        }
    }
}

