/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

public final class Field
extends AccessibleObject
implements Member {
    private Class<?> clazz;
    private int slot;
    private String name;
    private Class<?> type;
    private int modifiers;
    private transient String signature;
    private byte[] annotations;
    private Field root;

    private String getGenericSignature() {
        return this.signature;
    }

    Field(Class<?> declaringClass, String name, Class<?> type, int modifiers, int slot, String signature, byte[] annotations) {
        this.clazz = declaringClass;
        this.name = name;
        this.type = type;
        this.modifiers = modifiers;
        this.slot = slot;
        this.signature = signature;
        this.annotations = annotations;
    }

    Field copy() {
        Field res = new Field(this.clazz, this.name, this.type, this.modifiers, this.slot, this.signature, this.annotations);
        res.root = this;
        return res;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.clazz;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isEnumConstant() {
        return (this.getModifiers() & 0x4000) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return Modifier.isSynthetic(this.getModifiers());
    }

    public Class<?> getType() {
        return this.type;
    }

    public Type getGenericType() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Field) {
            Field other = (Field)obj;
            return this.getDeclaringClass() == other.getDeclaringClass() && this.getName() == other.getName() && this.getType() == other.getType();
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        int mod = this.getModifiers();
        return (mod == 0 ? "" : Modifier.toString(mod) + " ") + Field.getTypeName(this.getType()) + " " + Field.getTypeName(this.getDeclaringClass()) + "." + this.getName();
    }

    public String toGenericString() {
        int mod = this.getModifiers();
        Type fieldType = this.getGenericType();
        return (mod == 0 ? "" : Modifier.toString(mod) + " ") + (fieldType instanceof Class ? Field.getTypeName((Class)fieldType) : fieldType.toString()) + " " + Field.getTypeName(this.getDeclaringClass()) + "." + this.getName();
    }

    public Object get(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(obj).get(obj);
    }

    public boolean getBoolean(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(obj).getBoolean(obj);
    }

    public byte getByte(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(obj).getByte(obj);
    }

    public char getChar(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(obj).getChar(obj);
    }

    public short getShort(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(obj).getShort(obj);
    }

    public int getInt(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(obj).getInt(obj);
    }

    public long getLong(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(obj).getLong(obj);
    }

    public float getFloat(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(obj).getFloat(obj);
    }

    public double getDouble(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(obj).getDouble(obj);
    }

    public void set(Object obj, Object value) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(obj).set(obj, value);
    }

    public void setBoolean(Object obj, boolean z) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(obj).setBoolean(obj, z);
    }

    public void setByte(Object obj, byte b) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(obj).setByte(obj, b);
    }

    public void setChar(Object obj, char c) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(obj).setChar(obj, c);
    }

    public void setShort(Object obj, short s) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(obj).setShort(obj, s);
    }

    public void setInt(Object obj, int i) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(obj).setInt(obj, i);
    }

    public void setLong(Object obj, long l) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(obj).setLong(obj, l);
    }

    public void setFloat(Object obj, float f) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(obj).setFloat(obj, f);
    }

    public void setDouble(Object obj, double d) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(obj).setDouble(obj, d);
    }

    private FieldAccessor getFieldAccessor(Object obj) throws IllegalAccessException {
        throw new SecurityException();
    }

    static String getTypeName(Class<?> type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return type.getName();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        throw new UnsupportedOperationException();
    }

    private static abstract class FieldAccessor {
        private FieldAccessor() {
        }

        abstract void setShort(Object var1, short var2);

        abstract void setInt(Object var1, int var2);

        abstract void setChar(Object var1, char var2);

        abstract void setByte(Object var1, byte var2);

        abstract void setBoolean(Object var1, boolean var2);

        abstract void set(Object var1, Object var2);

        abstract double getDouble(Object var1);

        abstract void setLong(Object var1, long var2);

        abstract void setFloat(Object var1, float var2);

        abstract void setDouble(Object var1, double var2);

        abstract long getLong(Object var1);

        abstract int getInt(Object var1);

        abstract short getShort(Object var1);

        abstract char getChar(Object var1);

        abstract byte getByte(Object var1);

        abstract boolean getBoolean(Object var1);

        abstract Object get(Object var1);

        abstract float getFloat(Object var1);
    }
}

