/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Proxy
implements Serializable {
    private static final long serialVersionUID = -2222568056686623797L;
    private static final Method getProxyClass;
    protected InvocationHandler h;

    private Proxy() {
    }

    protected Proxy(InvocationHandler h) {
        this.h = h;
    }

    public static Class<?> getProxyClass(ClassLoader loader, Class<?> ... interfaces) throws IllegalArgumentException {
        try {
            return (Class)getProxyClass.invoke(null, loader, interfaces);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(ex);
        }
        catch (InvocationTargetException ex) {
            throw (RuntimeException)ex.getTargetException();
        }
    }

    public static Object newProxyInstance(ClassLoader loader, Class<?>[] interfaces, InvocationHandler h) throws IllegalArgumentException {
        if (h == null) {
            throw new NullPointerException();
        }
        Class<?> cl = Proxy.getProxyClass(loader, interfaces);
        try {
            Constructor<?> cons = cl.getConstructor(InvocationHandler.class);
            return cons.newInstance(h);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e.toString());
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e.toString());
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.toString());
        }
    }

    public static boolean isProxyClass(Class<?> cl) {
        if (cl == null) {
            throw new NullPointerException();
        }
        return Proxy.class.isAssignableFrom(cl);
    }

    public static InvocationHandler getInvocationHandler(Object proxy) throws IllegalArgumentException {
        if (!Proxy.isProxyClass(proxy.getClass())) {
            throw new IllegalArgumentException("not a proxy instance");
        }
        Proxy p = (Proxy)proxy;
        return p.h;
    }

    static {
        try {
            Class<?> pg = Class.forName("org.apidesign.bck2brwsr.emul.reflect.ProxyImpl");
            getProxyClass = pg.getMethod("getProxyClass", ClassLoader.class, Class[].class);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }
}

