/*
 * Decompiled with CFR 0.152.
 */
package pl.net.bluesoft.rnd.pt.ext.usersubstitution.widget;

import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.data.util.BeanItemContainer;
import com.vaadin.data.util.MethodProperty;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.PopupDateField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.logging.Logger;
import pl.net.bluesoft.rnd.processtool.di.ObjectFactory;
import pl.net.bluesoft.rnd.processtool.model.BpmTask;
import pl.net.bluesoft.rnd.processtool.model.ProcessInstance;
import pl.net.bluesoft.rnd.processtool.model.UserData;
import pl.net.bluesoft.rnd.processtool.plugins.ProcessToolRegistry;
import pl.net.bluesoft.rnd.processtool.ui.widgets.ProcessToolDataWidget;
import pl.net.bluesoft.rnd.processtool.ui.widgets.ProcessToolVaadinRenderable;
import pl.net.bluesoft.rnd.processtool.ui.widgets.ProcessToolWidget;
import pl.net.bluesoft.rnd.processtool.ui.widgets.annotations.AliasName;
import pl.net.bluesoft.rnd.processtool.ui.widgets.annotations.AutoWiredProperty;
import pl.net.bluesoft.rnd.processtool.ui.widgets.impl.BaseProcessToolWidget;
import pl.net.bluesoft.rnd.processtool.usersource.IUserSource;
import pl.net.bluesoft.util.lang.Formats;
import pl.net.bluesoft.util.lang.Maps;
import pl.net.bluesoft.util.lang.Strings;

@AliasName(name="UserSubstitutionRequest")
public class UserSubstitutionRequestWidget
extends BaseProcessToolWidget
implements ProcessToolVaadinRenderable,
ProcessToolDataWidget {
    private static final Logger logger = Logger.getLogger(UserSubstitutionRequestWidget.class.getName());
    private static final String USER_SUBSTITUTE_LOGIN = "userSubstitute";
    private static final String DATE_FROM = "dateFrom";
    private static final String DATE_TO = "dateTo";
    @AutoWiredProperty
    private boolean requestMode = true;
    private Map<String, UserData> usersMap;
    private UserData user;
    private UserData userSubstitute = null;
    private Date dateFrom;
    private Date dateTo;

    public void loadData(BpmTask task) {
        ProcessInstance pi = task.getProcessInstance();
        this.user = ProcessToolRegistry.Util.getRegistry().getUserSource().getUserByLogin(pi.getCreatorLogin());
        String userSubstituteLogin = pi.getSimpleAttributeValue(USER_SUBSTITUTE_LOGIN, null);
        this.dateFrom = UserSubstitutionRequestWidget.parseShortDate(pi.getSimpleAttributeValue(DATE_FROM, null));
        this.dateTo = UserSubstitutionRequestWidget.parseShortDate(pi.getSimpleAttributeValue(DATE_TO, null));
        IUserSource userSource = (IUserSource)ObjectFactory.create(IUserSource.class, (Object[])new Object[0]);
        this.usersMap = Maps.collectionToMap((Collection)userSource.getAllUsers(), (String)"login");
        this.usersMap.remove(this.user.getLogin());
        if (Strings.hasText((String)userSubstituteLogin)) {
            this.userSubstitute = this.usersMap.get(userSubstituteLogin);
        }
    }

    public void saveData(BpmTask task) {
        ProcessInstance pi = task.getProcessInstance();
        pi.setSimpleAttribute(USER_SUBSTITUTE_LOGIN, this.userSubstitute.getLogin());
        pi.setSimpleAttribute(DATE_FROM, UserSubstitutionRequestWidget.formatShortDate(this.dateFrom));
        pi.setSimpleAttribute(DATE_TO, UserSubstitutionRequestWidget.formatShortDate(this.dateTo));
    }

    public Collection<String> validateData(BpmTask task, boolean skipRequired) {
        logger.warning("validate!!");
        ArrayList<String> errors = new ArrayList<String>();
        if (this.userSubstitute == null) {
            errors.add(this.getMessage("usersubstitution.user.required"));
        }
        if (this.dateFrom == null) {
            errors.add(this.getMessage("usersubstitution.date.from.required"));
        }
        if (this.dateTo == null) {
            errors.add(this.getMessage("usersubstitution.date.to.required"));
        }
        if (this.requestMode && this.dateFrom != null && this.dateFrom.before(UserSubstitutionRequestWidget.parseShortDate(UserSubstitutionRequestWidget.formatShortDate(new Date())))) {
            errors.add(this.getMessage("usersubstitution.date.from.can.not.be.in.the.past"));
        }
        if (this.dateFrom != null && this.dateTo != null && !this.dateFrom.equals(this.dateTo) && !this.dateFrom.before(this.dateTo)) {
            errors.add(this.getMessage("usersubstitution.date.from.must.not.be.later.than.date.to"));
        }
        return errors;
    }

    public Component render() {
        boolean readonly = !this.hasPermission(new String[]{"EDIT"});
        FormLayout fl = new FormLayout();
        fl.addComponent((Component)this.createLabel(this.getMessage("usersubstitution.substituted.user"), this.user.getRealName()));
        if (!readonly) {
            fl.addComponent((Component)this.createUserSelectionBox());
        } else {
            fl.addComponent((Component)this.createLabel(this.getMessage("usersubstitution.substituting.user"), this.userSubstitute != null ? this.userSubstitute.getRealName() : null));
        }
        fl.addComponent((Component)this.createDateField(this.getMessage("usersubstitution.date.from"), DATE_FROM, readonly));
        fl.addComponent((Component)this.createDateField(this.getMessage("usersubstitution.date.to"), DATE_TO, readonly));
        return fl;
    }

    private Label createLabel(String caption, Object value) {
        Label label = new Label();
        label.setCaption(caption);
        label.setValue(value);
        return label;
    }

    private PopupDateField createDateField(String caption, String boundProperty, boolean readonly) {
        PopupDateField dateField = new PopupDateField(caption);
        dateField.setDateFormat("yyyy-MM-dd");
        dateField.setResolution(4);
        dateField.setRequired(true);
        dateField.setImmediate(true);
        dateField.setPropertyDataSource((Property)new MethodProperty((Object)this, boundProperty));
        dateField.setReadOnly(readonly);
        return dateField;
    }

    private ComboBox createUserSelectionBox() {
        final ComboBox userBox = new ComboBox(this.getMessage("usersubstitution.substituting.user"));
        userBox.setItemCaptionPropertyId((Object)"filteredName");
        userBox.setItemCaptionMode(6);
        userBox.setFilteringMode(2);
        userBox.setRequired(true);
        userBox.setImmediate(true);
        userBox.setNewItemsAllowed(false);
        BeanItemContainer usersBIC = new BeanItemContainer(UserData.class);
        usersBIC.addAll(this.usersMap.values());
        usersBIC.sort(new Object[]{"realName"}, new boolean[]{true});
        userBox.setContainerDataSource((Container)usersBIC);
        userBox.setValue((Object)this.userSubstitute);
        userBox.addListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent event) {
                UserSubstitutionRequestWidget.this.userSubstitute = (UserData)userBox.getValue();
            }
        });
        return userBox;
    }

    public void addChild(ProcessToolWidget child) {
        throw new IllegalArgumentException("Not supported!");
    }

    private static String formatShortDate(Date date) {
        return date != null ? Formats.formatShortDate((Date)date) : null;
    }

    private static Date parseShortDate(String date) {
        return date != null ? Formats.parseShortDate((String)date) : null;
    }

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    public Date getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }

    public boolean isRequestMode() {
        return this.requestMode;
    }

    public void setRequestMode(boolean requestMode) {
        this.requestMode = requestMode;
    }
}

