/*
 * Decompiled with CFR 0.152.
 */
package pl.net.bluesoft.rnd.pt.ext.deadline.step;

import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.beanutils.PropertyUtils;
import pl.net.bluesoft.rnd.processtool.ProcessToolContext;
import pl.net.bluesoft.rnd.processtool.bpm.exception.ProcessToolException;
import pl.net.bluesoft.rnd.processtool.model.BpmStep;
import pl.net.bluesoft.rnd.processtool.model.ProcessInstance;
import pl.net.bluesoft.rnd.processtool.model.ProcessInstanceAttribute;
import pl.net.bluesoft.rnd.processtool.model.processdata.ProcessDeadline;
import pl.net.bluesoft.rnd.processtool.steps.ProcessToolProcessStep;
import pl.net.bluesoft.rnd.processtool.ui.widgets.annotations.AliasName;
import pl.net.bluesoft.rnd.processtool.ui.widgets.annotations.AutoWiredProperty;
import pl.net.bluesoft.util.lang.Strings;

@AliasName(name="SetupDeadlineStep")
public class SetupDeadlineStep
implements ProcessToolProcessStep {
    public static final String DEFAULT_TEMPLATE_NAME = "deadlineEmailTemplate";
    private static final String DEFAULT_PROFILE_NAME = "DefaultDeadLineProfile";
    private final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final Logger logger = Logger.getLogger(SetupDeadlineStep.class.getName());
    @AutoWiredProperty
    private String taskName;
    @AutoWiredProperty
    private String profileName = "DefaultDeadLineProfile";
    @AutoWiredProperty
    private String templateName = "deadlineEmailTemplate";
    @AutoWiredProperty
    private String unit = "day";
    @AutoWiredProperty
    private String value;
    @AutoWiredProperty
    private String notifyUsersWithLogin;
    @AutoWiredProperty
    private String notifyUsersWithRole;
    @AutoWiredProperty
    private String skipAssignee;
    @AutoWiredProperty
    private String workingDays;

    public String invoke(BpmStep step, Map<String, String> params) throws Exception {
        ProcessInstance processInstance = step.getProcessInstance();
        ProcessToolContext ctx = ProcessToolContext.Util.getThreadProcessToolContext();
        List<String> taskNames = Strings.hasText((String)this.taskName) ? Arrays.asList(this.taskName.split(",")) : step.getOutgoingTransitions();
        Date dueDate = this.extractDate("dueDate", processInstance, params);
        if (dueDate == null) {
            Date baseDate = this.extractDate("baseDate", processInstance, params);
            if (!Strings.hasText((String)this.value)) {
                throw new ProcessToolException("Unable to calculate due date");
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(baseDate != null ? baseDate : new Date());
            if (this.useWorkingDays()) {
                int nv = Integer.valueOf(this.value);
                nv = SetupDeadlineStep.getWeekOffset(cal.getTime(), nv);
                cal.add(6, nv);
                dueDate = cal.getTime();
            } else {
                cal.add("min".equals(this.unit) ? 12 : 6, Integer.valueOf(this.value));
                cal.set(10, 0);
                cal.set(13, 0);
                if (!"min".equals(this.unit)) {
                    cal.set(12, 0);
                }
                dueDate = cal.getTime();
            }
        }
        for (String tn : taskNames) {
            String attrKey = "deadline_" + tn;
            ProcessDeadline pid = null;
            for (ProcessInstanceAttribute attr : processInstance.getProcessAttributes()) {
                if (attr.getKey() == null) {
                    logger.info("Attribute key is null! Process instance: " + processInstance.getInternalId());
                }
                if (!attrKey.equals(attr.getKey())) continue;
                pid = (ProcessDeadline)attr;
                break;
            }
            if (pid == null) {
                pid = new ProcessDeadline();
                pid.setKey("deadline_" + tn);
                pid.setProcessInstance(processInstance);
                processInstance.getProcessAttributes().add(pid);
            }
            pid.setProfileName(this.profileName);
            pid.setNotifyUsersWithLogin(this.notifyUsersWithLogin);
            pid.setNotifyUsersWithRole(this.notifyUsersWithRole);
            pid.setSkipAssignee("true".equalsIgnoreCase(this.skipAssignee));
            pid.setTemplateName(this.templateName);
            pid.setTaskName(tn);
            pid.setAlreadyNotified(false);
            pid.setDueDate(dueDate);
        }
        ctx.getProcessInstanceDAO().saveProcessInstance(processInstance);
        return "OK";
    }

    public static int getWeekOffset(Date start, int offset) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(start);
        int weekday = cal.get(7);
        int days = offset % 5;
        int fullweeks = (offset - days) / 5 * 7;
        int final_offset = 0;
        if (weekday == 0) {
            final_offset = 2;
            weekday = 2;
        } else if (weekday == 1) {
            final_offset = 1;
            weekday = 2;
        }
        if (weekday + days > 6) {
            final_offset += 2;
        }
        offset = final_offset + fullweeks + days;
        return offset;
    }

    private boolean useWorkingDays() {
        return Strings.hasText((String)this.workingDays) && this.workingDays.equals("true");
    }

    private Date extractDate(String prefix, ProcessInstance processInstance, Map<String, String> params) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, ParseException {
        Date date = null;
        if (params.containsKey(prefix)) {
            date = this.DATE_FORMAT.parse(params.get(prefix));
        } else if (params.containsKey(prefix + "Attribute")) {
            String[] paramValue = params.get(prefix + "Attribute").split("\\.", 2);
            for (ProcessInstanceAttribute attr : processInstance.getProcessAttributes()) {
                if (!attr.getKey().equals(paramValue[0])) continue;
                date = (Date)PropertyUtils.getProperty((Object)attr, (String)(paramValue.length > 1 ? paramValue[1] : "value"));
                break;
            }
        }
        return date;
    }
}

