/*
 * Decompiled with CFR 0.152.
 */
package pl.net.bluesoft.rnd.pt.ext.deadline;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.time.DateUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import pl.net.bluesoft.rnd.processtool.ProcessToolContext;
import pl.net.bluesoft.rnd.processtool.ProcessToolContextCallback;
import pl.net.bluesoft.rnd.processtool.ProcessToolContextFactory;
import pl.net.bluesoft.rnd.processtool.ReturningProcessToolContextCallback;
import pl.net.bluesoft.rnd.processtool.bpm.ProcessToolBpmSession;
import pl.net.bluesoft.rnd.processtool.bpm.exception.ProcessToolException;
import pl.net.bluesoft.rnd.processtool.di.ObjectFactory;
import pl.net.bluesoft.rnd.processtool.model.BpmTask;
import pl.net.bluesoft.rnd.processtool.model.ProcessInstance;
import pl.net.bluesoft.rnd.processtool.model.UserData;
import pl.net.bluesoft.rnd.processtool.model.processdata.ProcessDeadline;
import pl.net.bluesoft.rnd.processtool.plugins.ProcessToolRegistry;
import pl.net.bluesoft.rnd.processtool.roles.IUserRolesManager;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.EmailSender;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.IBpmNotificationService;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.NotificationData;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.TemplateData;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.TemplateDataProvider;
import pl.net.bluesoft.rnd.pt.ext.deadline.HandleDeadlineJob;
import pl.net.bluesoft.rnd.pt.ext.sched.service.ProcessToolSchedulerService;
import pl.net.bluesoft.rnd.util.i18n.I18NSource;
import pl.net.bluesoft.rnd.util.i18n.I18NSourceFactory;
import pl.net.bluesoft.util.lang.Collections;
import pl.net.bluesoft.util.lang.Predicate;
import pl.net.bluesoft.util.lang.Strings;

public class DeadlineEngine {
    private static final Logger logger = Logger.getLogger(DeadlineEngine.class.getName());
    private ProcessToolRegistry registry;
    private Properties pluginProperties;

    public DeadlineEngine(ProcessToolRegistry registry, Properties pluginProperties) throws SchedulerException {
        this.registry = registry;
        this.pluginProperties = pluginProperties;
    }

    public void init() {
        this.registry.getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                DeadlineEngine.this.registry.withProcessToolContext((ReturningProcessToolContextCallback)new ProcessToolContextCallback(){

                    public void withContext(ProcessToolContext ctx) {
                        ProcessToolBpmSession bpmSession = ProcessToolRegistry.Util.getRegistry().getProcessToolSessionFactory().createAutoSession();
                        Session session = ctx.getHibernateSession();
                        List instances = DeadlineEngine.this.loadProcessesWithDeadlines(session);
                        for (ProcessInstance pi : instances) {
                            if (!pi.isProcessRunning()) continue;
                            Set deadlines = pi.findAttributesByClass(ProcessDeadline.class);
                            List tasks = bpmSession.findProcessTasks(pi);
                            for (ProcessDeadline pd : deadlines) {
                                for (BpmTask task : tasks) {
                                    if (!task.getTaskName().equals(pd.getTaskName()) || task.getAssignee() == null) continue;
                                    DeadlineEngine.this.scheduleDeadline(pi.getInternalId(), pd);
                                }
                            }
                        }
                    }
                });
            }
        });
    }

    private List<ProcessInstance> loadProcessesWithDeadlines(Session session) {
        DetachedCriteria pdc = DetachedCriteria.forClass(ProcessDeadline.class).add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"alreadyNotified", (Object)Boolean.FALSE), (Criterion)Restrictions.isNull((String)"alreadyNotified"))).createAlias("processInstance", "pi").setProjection(Projections.distinct((Projection)Projections.property((String)"pi.id")));
        return session.createCriteria(ProcessInstance.class).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).add(Subqueries.propertyIn((String)"id", (DetachedCriteria)pdc)).list();
    }

    public void destroy() {
        ProcessToolSchedulerService service = this.getSchedulerService();
        service.cancelScheduledJobGroup(HandleDeadlineJob.class.getName());
    }

    private ProcessToolSchedulerService getSchedulerService() {
        return (ProcessToolSchedulerService)this.registry.getRegisteredService(ProcessToolSchedulerService.class);
    }

    private void scheduleDeadline(String processInternalId, ProcessDeadline pd) {
        ProcessToolSchedulerService service = this.getSchedulerService();
        Date currentDate = new Date();
        Date dueDate = pd.getDueDate();
        if (DateUtils.isSameDay((Date)dueDate, (Date)currentDate) || currentDate.before(dueDate) || !pd.isAlreadyNotified()) {
            JobDataMap dataMap = new JobDataMap();
            dataMap.put("processInstanceId", processInternalId);
            dataMap.put("deadlineAttribute", (Object)pd);
            dataMap.put("deadlineEngine", (Object)this);
            String taskName = pd.getTaskName();
            String identity = "pi:" + processInternalId + ";task:" + taskName;
            JobDetail jobDetail = JobBuilder.newJob(HandleDeadlineJob.class).withIdentity(identity, HandleDeadlineJob.class.getName()).usingJobData(dataMap).build();
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(identity, HandleDeadlineJob.class.getName()).startAt(dueDate).forJob(jobDetail).build();
            logger.info("Scheduling deadline job handler at: " + dueDate + " for process instance: " + processInternalId + " and task name: " + taskName);
            service.scheduleJob(jobDetail, new Trigger[]{trigger});
        }
    }

    public void onProcessStateChange(BpmTask task, ProcessInstance pi, boolean processInitiated) {
        if (pi == null || pi.getId() == null || task == null) {
            logger.info("Event contained no persistent process instance and task. Omitting.");
            return;
        }
        String internalId = pi.getInternalId();
        logger.info("Processing deadlines for process: " + internalId);
        ProcessToolContext ctx = ProcessToolContext.Util.getThreadProcessToolContext();
        pi = ctx.getProcessInstanceDAO().getProcessInstance(pi.getId().longValue());
        if (pi == null) {
            throw new ProcessToolException("Unable to find process instance by internal id: " + internalId);
        }
        Set deadlines = pi.findAttributesByClass(ProcessDeadline.class);
        for (ProcessDeadline da : deadlines) {
            if (!task.getTaskName().contains(da.getTaskName())) continue;
            this.scheduleDeadline(pi.getInternalId(), da);
        }
    }

    public void handleDeadlineJob(final String processInstanceId, final ProcessDeadline processDeadline) {
        this.registry.withProcessToolContext((ReturningProcessToolContextCallback)new ProcessToolContextCallback(){

            public void withContext(ProcessToolContext ctx) {
                try {
                    DeadlineEngine.this.signalDeadline(processInstanceId, processDeadline);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Exception while sending deadline notification", e);
                }
            }
        }, ProcessToolContextFactory.ExecutionType.TRANSACTION_SYNCH);
    }

    private void signalDeadline(String processInstanceId, ProcessDeadline processDeadline) throws Exception {
        ProcessToolContext ctx = ProcessToolContext.Util.getThreadProcessToolContext();
        ProcessInstance pi = ctx.getProcessInstanceDAO().getProcessInstanceByInternalId(processInstanceId);
        ProcessToolBpmSession bpmSession = ProcessToolRegistry.Util.getRegistry().getProcessToolSessionFactory().createAutoSession();
        List tasks = bpmSession.findProcessTasks(pi);
        TemplateDataProvider templateDataProvider = new TemplateDataProvider();
        for (BpmTask task : tasks) {
            if (!task.getTaskName().equals(processDeadline.getTaskName())) continue;
            String assigneeLogin = task.getAssignee();
            Map<String, UserData> notifyUsers = this.prepareUsersForNotification(assigneeLogin, processDeadline);
            for (UserData user : notifyUsers.values()) {
                if (processDeadline.isSkipAssignee() && user.getLogin().equals(assigneeLogin)) {
                    logger.info("Skipping deadline signal for assignee: " + assigneeLogin);
                    continue;
                }
                TemplateData templateData = templateDataProvider.createTemplateData(processDeadline.getTemplateName(), Locale.getDefault());
                templateDataProvider.addProcessData(templateData, pi).addTaskData(templateData, task).addUserToNotifyData(templateData, user);
                templateData.addEntry("notifiedUser", (Object)user);
                templateData.addEntry("assignedUser", (Object)notifyUsers.get(assigneeLogin));
                NotificationData notificationData = new NotificationData();
                notificationData.setProfileName("Default").setRecipient(user).setTemplateData(templateData);
                logger.info("Signaling deadline for task: " + task.getTaskName() + " owned by: " + assigneeLogin + ", mailed to: " + user.getLogin());
                EmailSender.sendEmail((IBpmNotificationService)this.getBpmNotifications(), (NotificationData)notificationData);
            }
            processDeadline.setAlreadyNotified(true);
            ctx.getHibernateSession().saveOrUpdate((Object)processDeadline);
        }
    }

    private IBpmNotificationService getBpmNotifications() {
        return (IBpmNotificationService)this.registry.getRegisteredService(IBpmNotificationService.class);
    }

    private I18NSource getI18NSource() {
        String defaultLocale = this.pluginProperties.getProperty("default.locale");
        Locale locale = Strings.hasText((String)defaultLocale) ? new Locale(defaultLocale) : Locale.getDefault();
        return I18NSourceFactory.createI18NSource((Locale)locale);
    }

    private Map<String, UserData> prepareUsersForNotification(String assigneeLogin, ProcessDeadline processDeadline) {
        Map<String, UserData> notifyUsers;
        ArrayList<String> userLogins = new ArrayList<String>();
        userLogins.add(assigneeLogin);
        if (Strings.hasText((String)processDeadline.getNotifyUsersWithLogin())) {
            for (String login : processDeadline.getNotifyUsersWithLogin().split(",")) {
                if (!Strings.hasText((String)login)) continue;
                userLogins.add(login);
            }
        }
        if (!(notifyUsers = this.loadUsersAsMap(userLogins)).containsKey(assigneeLogin)) {
            throw new ProcessToolException("Unable to find task assignee with login: " + assigneeLogin);
        }
        if (Strings.hasText((String)processDeadline.getNotifyUsersWithRole())) {
            for (String role : processDeadline.getNotifyUsersWithRole().split(",")) {
                if (!Strings.hasText((String)role)) continue;
                IUserRolesManager rolesManager = (IUserRolesManager)ObjectFactory.create(IUserRolesManager.class, (Object[])new Object[0]);
                for (UserData userWithRole : rolesManager.getUsersByRole(role)) {
                    notifyUsers.put(userWithRole.getLogin(), userWithRole);
                }
            }
        }
        return notifyUsers;
    }

    private Map<String, UserData> loadUsersAsMap(List<String> userLogins) {
        HashMap<String, UserData> users = new HashMap<String, UserData>();
        for (String login : userLogins) {
            if (users.get(login) != null) continue;
            UserData user = ProcessToolRegistry.Util.getRegistry().getUserSource().getUserByLogin(login);
            if (user == null) {
                logger.warning("Unable to find user by login: " + login);
                continue;
            }
            users.put(login, user);
        }
        return Collections.filterValues(users, (Predicate)new Predicate<UserData>(){

            public boolean apply(UserData input) {
                return input != null;
            }
        });
    }
}

