/*
 * Decompiled with CFR 0.152.
 */
package pl.net.bluesoft.rnd.pt.ext.deadline;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import pl.net.bluesoft.rnd.processtool.bpm.BpmEvent;
import pl.net.bluesoft.rnd.pt.ext.deadline.AbstractPluginActivator;
import pl.net.bluesoft.rnd.pt.ext.deadline.DeadlineEngine;
import pl.net.bluesoft.util.eventbus.EventListener;

public class DeadlineActivator
extends AbstractPluginActivator
implements EventListener<BpmEvent> {
    private DeadlineEngine engine;
    private Logger logger = Logger.getLogger(DeadlineActivator.class.getName());

    @Override
    protected void init() throws Exception {
        Properties pluginProperties = this.loadProperties("plugin.properties");
        this.engine = new DeadlineEngine(this.registry, pluginProperties);
        this.engine.init();
        this.registry.getEventBusManager().subscribe(BpmEvent.class, (EventListener)this);
    }

    @Override
    protected void destroy() throws Exception {
        this.registry.getEventBusManager().unsubscribe(BpmEvent.class, (EventListener)this);
        this.engine.destroy();
    }

    public void onEvent(BpmEvent event) {
        try {
            this.engine.onProcessStateChange(event.getTask(), event.getProcessInstance(), event.getEventType() == BpmEvent.Type.NEW_PROCESS);
        }
        catch (Throwable t) {
            this.logger.log(Level.WARNING, "Exception while processing deadline event " + event.toString(), t);
        }
    }
}

