/*
 * Decompiled with CFR 0.152.
 */
package pl.net.bluesoft.rnd.pt.ext.emailcapture;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;
import pl.net.bluesoft.rnd.processtool.ProcessToolContext;
import pl.net.bluesoft.rnd.processtool.bpm.BpmTask;
import pl.net.bluesoft.rnd.processtool.bpm.ProcessToolBpmSession;
import pl.net.bluesoft.rnd.processtool.model.ProcessInstance;
import pl.net.bluesoft.rnd.processtool.model.ProcessInstanceAttribute;
import pl.net.bluesoft.rnd.processtool.model.ProcessInstanceSimpleAttribute;
import pl.net.bluesoft.rnd.processtool.model.UserData;
import pl.net.bluesoft.rnd.processtool.model.config.ProcessStateAction;
import pl.net.bluesoft.rnd.pt.ext.emailcapture.model.EmailCheckerConfiguration;
import pl.net.bluesoft.rnd.pt.ext.emailcapture.model.EmailCheckerRuleConfiguration;
import pl.net.bluesoft.rnd.pt.utils.cmis.CmisAtomSessionFacade;
import pl.net.bluesoft.util.lang.FormatUtil;
import pl.net.bluesoft.util.lang.StringUtil;

public class EmailChecker {
    private static final Logger logger = Logger.getLogger(EmailChecker.class.getName());
    private ProcessToolContext context;

    public EmailChecker(ProcessToolContext context) {
        this.context = context;
    }

    public void run() {
        List configs = this.context.getHibernateSession().createCriteria(EmailCheckerConfiguration.class).list();
        for (EmailCheckerConfiguration cfg : configs) {
            try {
                this.execute(cfg);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public void execute(EmailCheckerConfiguration cfg) throws Exception {
        ProcessToolBpmSession toolBpmSession = this.context.getProcessToolSessionFactory().createSession(new UserData(cfg.getAutomaticUser(), cfg.getAutomaticUser(), cfg.getAutomaticUser()), new HashSet());
        ByteArrayInputStream bis = new ByteArrayInputStream(cfg.getMailSessionProperties().getBytes());
        final Properties cfgProperties = new Properties();
        cfgProperties.load(bis);
        final String protocol = cfgProperties.getProperty("mail.store.protocol");
        Session session = Session.getInstance((Properties)cfgProperties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(cfgProperties.getProperty("mail." + protocol + ".user"), cfgProperties.getProperty("mail." + protocol + ".password"));
            }
        });
        Store store = session.getStore();
        store.connect();
        logger.info("Connected to mail service using " + cfg.getMailSessionProperties());
        String searchDirectory = cfgProperties.getProperty("search.directory");
        Folder folder = StringUtil.hasText((String)searchDirectory) ? store.getFolder(searchDirectory) : store.getFolder("inbox");
        folder.open(2);
        logger.info("Folder " + searchDirectory + " opened successfully");
        Message[] messages = folder.search((SearchTerm)new FlagTerm(new Flags(Flags.Flag.SEEN), false));
        logger.info("Found " + messages.length + " messages in " + folder.getFullName());
        ArrayList<Message> processed = new ArrayList<Message>();
        for (Message msg : messages) {
            try {
                this.processMessage(msg, cfg, toolBpmSession);
                processed.add(msg);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        folder.setFlags(processed.toArray(new Message[processed.size()]), new Flags(Flags.Flag.SEEN), true);
        folder.close(false);
        store.close();
    }

    private void processMessage(Message msg, EmailCheckerConfiguration cfg, ProcessToolBpmSession toolBpmSession) throws MessagingException, IOException {
        String subject = msg.getSubject();
        String recipients = "";
        if (msg.getHeader("To") != null) {
            for (String h : msg.getHeader("To")) {
                recipients = recipients + h + ",";
            }
        }
        if (msg.getHeader("Cc") != null) {
            for (String h : msg.getHeader("Cc")) {
                recipients = recipients + h + ",";
            }
        }
        String sender = "";
        if (msg.getFrom() != null) {
            for (Address a : msg.getFrom()) {
                sender = sender + a.toString() + ",";
            }
        }
        String description = subject + ", from: " + recipients + ", sent by: " + sender;
        logger.fine("Processing message: " + description);
        for (EmailCheckerRuleConfiguration rule : cfg.getRules()) {
            org.apache.chemistry.opencmis.client.api.Folder mainFolder;
            Matcher m;
            logger.fine("Checking rule " + rule.getId() + " against message " + description);
            if (StringUtil.hasText((String)rule.getSubjectRegexp()) && (subject == null || !subject.matches(rule.getSubjectRegexp()))) continue;
            String preparedSubject = subject.toUpperCase();
            if (StringUtil.hasText((String)rule.getSubjectRemovables())) {
                for (String removable : rule.getSubjectRemovables().split("\\s")) {
                    preparedSubject = preparedSubject.replace(removable.toUpperCase(), "");
                }
            }
            preparedSubject = preparedSubject.replaceAll("[^A-Z0-9_\\-]*", "");
            logger.fine("Prepared subject: " + preparedSubject);
            ProcessInstance existingPi = null;
            if (rule.isLookupRunningProcesses()) {
                List instancesByExternalKey = this.context.getProcessInstanceDAO().findProcessInstancesByKeyword(preparedSubject, rule.getProcessCode());
                for (ProcessInstance pi : instancesByExternalKey) {
                    boolean running = toolBpmSession.isProcessRunning(pi.getInternalId(), this.context);
                    logger.fine("Found existing process for " + preparedSubject + ", ID: " + pi.getInternalId());
                    if (!running || !pi.getDefinition().getBpmDefinitionKey().equals(rule.getProcessCode())) continue;
                    logger.info("Found existing and RUNNING process for " + preparedSubject + ", ID: " + pi.getInternalId());
                    existingPi = pi;
                    break;
                }
            }
            if (existingPi == null && (StringUtil.hasText((String)rule.getRecipientRegexp()) && (recipients == null || !recipients.matches(rule.getRecipientRegexp())) || StringUtil.hasText((String)rule.getSenderRegexp()) && (sender == null || !sender.matches(rule.getSenderRegexp())))) continue;
            logger.fine("Rule " + rule.getId() + " has matched message " + description + ", existing process: " + existingPi);
            if (existingPi == null && StringUtil.hasText((String)rule.getProcessIdSubjectLookupRegexp()) && (m = Pattern.compile(rule.getProcessIdSubjectLookupRegexp()).matcher(subject)).matches()) {
                String processId = m.group(1);
                existingPi = (ProcessInstance)FormatUtil.nvl((Object)this.context.getProcessInstanceDAO().getProcessInstanceByExternalId(processId), (Object)this.context.getProcessInstanceDAO().getProcessInstanceByInternalId(processId));
                if (existingPi != null) {
                    logger.fine("Found existing process for " + processId + ", ID: " + existingPi.getInternalId());
                }
            }
            if (existingPi == null && rule.getStartNewProcesses().booleanValue()) {
                logger.fine("Starting new process for rule " + rule.getId() + " on matched message " + description + ", process code: " + rule.getProcessCode());
                existingPi = toolBpmSession.createProcessInstance(this.context.getProcessDefinitionDAO().getActiveConfigurationByKey(rule.getProcessCode()), null, this.context, subject, preparedSubject, "email");
                existingPi.addAttribute((ProcessInstanceAttribute)new ProcessInstanceSimpleAttribute("email_from", sender));
                existingPi.addAttribute((ProcessInstanceAttribute)new ProcessInstanceSimpleAttribute("email_subject", msg.getSubject()));
                if (msg.getContent() instanceof Multipart) {
                    Multipart multipart = (Multipart)msg.getContent();
                    for (int i = 0; i < multipart.getCount(); ++i) {
                        BodyPart part = multipart.getBodyPart(i);
                        if (part.getContentType() == null || part.getContentType().startsWith("text/")) {
                            logger.info("Skipping multipart attachment #" + i);
                            continue;
                        }
                        existingPi.addAttribute((ProcessInstanceAttribute)new ProcessInstanceSimpleAttribute("email_body", new String(this.toByteArray(part.getInputStream()))));
                    }
                } else {
                    existingPi.addAttribute((ProcessInstanceAttribute)new ProcessInstanceSimpleAttribute("email_body", new String(this.toByteArray(msg.getInputStream()))));
                }
                this.context.getProcessInstanceDAO().saveProcessInstance(existingPi);
                logger.info("Started new process for rule " + rule.getId() + " on matched message " + description + ", process code: " + rule.getProcessCode() + " new process id: " + existingPi.getInternalId());
            }
            if (existingPi != null && StringUtil.hasText((String)rule.getRunningProcessActionName())) {
                Collection taskList = toolBpmSession.getTaskList(existingPi, this.context);
                block7: for (BpmTask t : taskList) {
                    if (StringUtil.hasText((String)rule.getProcessTaskName()) && !rule.getProcessTaskName().equalsIgnoreCase(t.getTaskName())) continue;
                    Set actions = this.context.getProcessDefinitionDAO().getProcessStateConfiguration(existingPi).getActions();
                    for (ProcessStateAction a : actions) {
                        if (!rule.getRunningProcessActionName().equals(a.getBpmName())) continue;
                        toolBpmSession.performAction(a, existingPi, this.context, t);
                        logger.info("Performed action " + rule.getId() + " on matched message " + description + ", process code: " + rule.getProcessCode() + " process id: " + existingPi.getInternalId());
                        continue block7;
                    }
                }
            }
            if (existingPi == null || !StringUtil.hasText((String)rule.getRepositoryAtomUrl())) continue;
            logger.fine("Uploading CMIS documents, process ID: " + existingPi.getInternalId());
            CmisAtomSessionFacade sessionFacade = new CmisAtomSessionFacade(rule.getRepositoryUser(), rule.getRepositoryPassword(), rule.getRepositoryAtomUrl(), rule.getRepositoryId());
            String folderId = null;
            for (ProcessInstanceAttribute at : existingPi.getProcessAttributes()) {
                ProcessInstanceSimpleAttribute pisa;
                if (!(at instanceof ProcessInstanceSimpleAttribute) || !(pisa = (ProcessInstanceSimpleAttribute)at).getKey().equals(rule.getFolderAttributeName())) continue;
                folderId = pisa.getValue();
                break;
            }
            if (folderId == null) {
                mainFolder = sessionFacade.createFolderIfNecessary(FormatUtil.nvl((String)rule.getNewFolderPrefix(), (String)"") + existingPi.getInternalId(), rule.getRootFolderPath());
                if (StringUtil.hasText((String)rule.getSubFolder())) {
                    mainFolder = sessionFacade.createFolderIfNecessary(rule.getSubFolder(), mainFolder.getPath());
                }
                folderId = mainFolder.getId();
                ProcessInstanceSimpleAttribute attr = new ProcessInstanceSimpleAttribute();
                attr.setKey("emailSender");
                attr.setValue(sender);
                existingPi.addAttribute((ProcessInstanceAttribute)attr);
                attr = new ProcessInstanceSimpleAttribute();
                attr.setKey("emailSubject");
                attr.setValue(subject);
                existingPi.addAttribute((ProcessInstanceAttribute)attr);
                attr = new ProcessInstanceSimpleAttribute();
                attr.setKey(FormatUtil.nvl((String)rule.getFolderAttributeName(), (String)"emailFolderId"));
                attr.setValue(folderId);
                existingPi.addAttribute((ProcessInstanceAttribute)attr);
                this.context.getProcessInstanceDAO().saveProcessInstance(existingPi);
            } else {
                mainFolder = sessionFacade.getFolderById(folderId);
            }
            if (msg.getContent() instanceof Multipart) {
                Multipart multipart = (Multipart)msg.getContent();
                for (int i = 0; i < multipart.getCount(); ++i) {
                    BodyPart part = multipart.getBodyPart(i);
                    if (rule.isOmitTextAttachments() && (part.getContentType() == null || part.getContentType().startsWith("text/"))) {
                        logger.info("Skipping multipart attachment #" + i);
                        continue;
                    }
                    sessionFacade.uploadDocument(StringUtil.hasText((String)part.getFileName()) ? part.getFileName() : "part_" + i, mainFolder, this.toByteArray(part.getInputStream()), part.getContentType(), null);
                }
                continue;
            }
            if (rule.isOmitTextAttachments()) continue;
            sessionFacade.uploadDocument("message", mainFolder, this.toByteArray(msg.getInputStream()), msg.getContentType(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] toByteArray(InputStream inputStream) throws IOException {
        try {
            int c;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((c = inputStream.read()) >= 0) {
                bos.write(c);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            inputStream.close();
        }
    }
}

