/*
 * Decompiled with CFR 0.152.
 */
package org.aperteworkflow.help.impl;

import com.vaadin.Application;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import org.apache.commons.lang3.StringEscapeUtils;
import org.vaadin.jonatan.contexthelp.ContextHelp;
import org.vaadin.jonatan.contexthelp.Placement;
import pl.net.bluesoft.rnd.processtool.ProcessToolContext;
import pl.net.bluesoft.rnd.processtool.dict.ProcessDictionaryRegistry;
import pl.net.bluesoft.rnd.processtool.model.UserData;
import pl.net.bluesoft.rnd.processtool.model.dict.ProcessDictionary;
import pl.net.bluesoft.rnd.processtool.model.dict.ProcessDictionaryItem;
import pl.net.bluesoft.rnd.util.i18n.I18NSource;

public class HelpUtility {
    public static Component helpIcon(Application application, I18NSource i18NSource, ContextHelp contextHelp, String dictionary, String key, Boolean showDebugKey, Component optionalComponent, Placement popupPlacement) {
        ProcessToolContext ctx = ProcessToolContext.Util.getThreadProcessToolContext();
        ProcessDictionaryRegistry processDictionaryRegistry = ctx.getProcessDictionaryRegistry();
        ProcessDictionary dict = processDictionaryRegistry.getDictionary(dictionary);
        return HelpUtility.helpIcon(dict, application, i18NSource, contextHelp, key, showDebugKey, optionalComponent, popupPlacement);
    }

    public static Button helpIcon(ProcessDictionary dict, Application application, I18NSource i18NSource, final ContextHelp contextHelp, String key, Boolean showDebugKey, final Component optionalComponent, Placement popupPlacement) {
        String message = HelpUtility.getMessageFromDictionary(dict, i18NSource, key, HelpUtility.canUserEditDictionaries(application), showDebugKey);
        if (popupPlacement == null) {
            popupPlacement = Placement.RIGHT;
        }
        final Button icon = HelpUtility.helpIconButton(application);
        icon.setWidth(20.0f, 0);
        icon.setHeight(20.0f, 0);
        if (optionalComponent != null) {
            contextHelp.addHelpForComponent(optionalComponent, message, popupPlacement);
        } else {
            contextHelp.addHelpForComponent((Component)icon, message, popupPlacement);
        }
        icon.addListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                if (optionalComponent != null) {
                    contextHelp.showHelpFor(optionalComponent);
                } else {
                    contextHelp.showHelpFor((Component)icon);
                }
            }
        });
        return icon;
    }

    private static String getMessageFromDictionary(ProcessDictionary dict, I18NSource i18NSource, String key, boolean showEditButton, boolean showDebugKey) {
        ProcessDictionaryItem dictItem = dict.lookup(key);
        String languageCode = i18NSource.getLocale().toString();
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("<div id=\"editor1\">");
        if (dictItem == null) {
            messageBuilder.append(i18NSource.getMessage("help.empty").replaceAll("\\{0\\}", key));
        } else {
            messageBuilder.append(dictItem.getValueForCurrentDate().getValue(languageCode));
        }
        messageBuilder.append("</div>");
        if (showEditButton) {
            String dictionaryId = dict.getDictionaryId();
            String dictionaryItemValue = dictItem == null ? "" : dictItem.getValueForCurrentDate().getValue(languageCode);
            String escapedValue = StringEscapeUtils.escapeHtml4((String)dictionaryItemValue);
            messageBuilder.append("<br/>");
            messageBuilder.append("<input type=\"button\" value=\"").append(i18NSource.getMessage("help.popup.edit")).append("\" name=\"editButton\" onClick=\"showEditHelpContextPopup('");
            messageBuilder.append((String)null);
            messageBuilder.append("','");
            messageBuilder.append(dictionaryId);
            messageBuilder.append("','");
            messageBuilder.append(languageCode);
            messageBuilder.append("','");
            messageBuilder.append(key);
            messageBuilder.append("','");
            messageBuilder.append(escapedValue);
            messageBuilder.append("')\" />");
        }
        if (showDebugKey) {
            messageBuilder.append("<br/><br/><small>");
            messageBuilder.append(i18NSource.getMessage("help.dictionary"));
            messageBuilder.append(": ");
            messageBuilder.append(dict.getDefaultName());
            messageBuilder.append("</small><br/><small>");
            messageBuilder.append(i18NSource.getMessage("help.key"));
            messageBuilder.append(": ");
            messageBuilder.append(key);
            messageBuilder.append("</small>");
        }
        return messageBuilder.toString();
    }

    private static Button helpIconButton(Application application) {
        Button b = new Button();
        b.addStyleName("link");
        b.addStyleName("help_button");
        b.setWidth(12.0f, 0);
        b.setHeight(12.0f, 0);
        b.setImmediate(true);
        return b;
    }

    public static void showHelpFor(ProcessDictionary dict, Application application, I18NSource i18NSource, ContextHelp contextHelp, String key, Boolean showDebugKey, Component component, Placement placement) {
        if (placement == null) {
            placement = Placement.RIGHT;
        }
        String message = HelpUtility.getMessageFromDictionary(dict, i18NSource, key, HelpUtility.canUserEditDictionaries(application), showDebugKey);
        contextHelp.addHelpForComponent(component, message, placement);
        contextHelp.showHelpFor(component);
    }

    private static boolean canUserEditDictionaries(Application application) {
        UserData user = (UserData)application.getUser();
        boolean canEdit = user.getRoles().contains("CHANGE_HELP_TOOLTIPS");
        return canEdit;
    }
}

