/*
 * Decompiled with CFR 0.152.
 */
package org.aperteworkflow.help.impl;

import com.vaadin.Application;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Table;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aperteworkflow.help.impl.FieldWithHelp;
import org.aperteworkflow.help.impl.HelpFactory;
import org.aperteworkflow.ui.help.HelpProvider;
import org.vaadin.jonatan.contexthelp.ContextHelp;
import org.vaadin.jonatan.contexthelp.Placement;
import pl.net.bluesoft.rnd.processtool.model.config.ProcessDefinitionConfig;
import pl.net.bluesoft.rnd.pt.utils.lang.Lang2;
import pl.net.bluesoft.rnd.util.i18n.I18NSource;

public class HelpProviderImpl
implements HelpProvider {
    private HelpFactory helpFactory;
    private boolean canEdit;

    public void prepare(Application application, List<ProcessDefinitionConfig> cfgs, boolean canEdit, String helpDictionaryName) {
        ContextHelp contextHelp = new ContextHelp();
        this.canEdit = canEdit;
        application.getMainWindow().getContent().addComponent((Component)contextHelp);
        this.helpFactory = new HelpFactory(application, I18NSource.ThreadUtil.getThreadI18nSource(), helpDictionaryName, contextHelp);
    }

    public Component helpIcon(String taskName, String s) {
        return this.helpFactory.helpIcon(taskName, s);
    }

    public Component getHelpIcon(String key) {
        if (this.cannotEdit()) {
            return new Label("");
        }
        return this.helpFactory.helpIcon(key);
    }

    private boolean cannotEdit() {
        return !this.canEdit;
    }

    public Component getHelpIcon(String key, String message) {
        if (this.cannotEdit()) {
            return new Label("");
        }
        return this.helpFactory.helpIcon(key, message);
    }

    public Field wrapFieldWithHelp(Field field, String key) {
        if (this.cannotEdit()) {
            return field;
        }
        return this.helpFactory.wrapField(field, key);
    }

    public Component wrapComponentWithHelp(Component component, String key) {
        if (this.cannotEdit()) {
            return component;
        }
        return this.helpFactory.wrapComponentWithHelp(component, key);
    }

    public Component wrapComponentWithHelp(Component component, String key, String iconPlacement, String popupPlacement) {
        if (this.cannotEdit()) {
            return component;
        }
        return this.helpFactory.wrapComponentWithHelp(component, key, Placement.valueOf((String)iconPlacement), Placement.valueOf((String)popupPlacement));
    }

    public void attachToLayout(Layout layout) {
        layout.addComponent((Component)this.helpFactory.getContextHelp());
    }

    public void showHelpFor(Component component) {
        this.helpFactory.getContextHelp().showHelpFor(component);
    }

    public Field getFieldWithHelp(Field wrappedField, Component helpButton) {
        return new FieldWithHelp(wrappedField, helpButton);
    }

    public void makeTableHelpEnabled(Table t) {
        this.makeTableHelpEnabled(t, (Component)t);
    }

    public void makeTableHelpEnabled(final Table t, final Component helpPosition) {
        t.setSortDisabled(true);
        t.setData(new HashMap());
        this.helpFactory.getContextHelp().addHelpForComponent(helpPosition, "help.empty", Placement.ABOVE);
        t.addListener(new Table.HeaderClickListener(){

            public void headerClick(Table.HeaderClickEvent event) {
                Object propertyId;
                Map helpMap = (Map)t.getData();
                if (helpMap.containsKey(propertyId = event.getPropertyId())) {
                    HelpProviderImpl.this.helpFactory.showHelp(helpPosition, (String)helpMap.get(propertyId), Placement.ABOVE);
                }
            }
        });
    }

    public void addHelpForColumn(Table t, Object propertyId, String key) {
        Map helpMap = (Map)t.getData();
        t.setColumnIcon(propertyId, this.helpFactory.helpIcon(8));
        this.helpFactory.logHelpKey(key);
        helpMap.put(propertyId, key);
    }

    public Field stripFieldFromHelp(Field f) {
        if (this.isFieldWithHelp(f)) {
            return ((FieldWithHelp)((Object)Lang2.assumeType((Object)f, FieldWithHelp.class))).getField();
        }
        return f;
    }

    public boolean isFieldWithHelp(Field f) {
        return f instanceof FieldWithHelp;
    }
}

