/*
 * Decompiled with CFR 0.152.
 */
package org.aperteworkflow.help.impl;

import com.vaadin.Application;
import com.vaadin.terminal.ClassResource;
import com.vaadin.terminal.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.Field;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.VerticalLayout;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.aperteworkflow.help.impl.FieldWithHelp;
import org.aperteworkflow.help.impl.HelpUtility;
import org.aperteworkflow.util.vaadin.GenericVaadinPortlet2BpmApplication;
import org.vaadin.jonatan.contexthelp.ContextHelp;
import org.vaadin.jonatan.contexthelp.Placement;
import pl.net.bluesoft.rnd.processtool.ProcessToolContext;
import pl.net.bluesoft.rnd.processtool.dict.ProcessDictionaryRegistry;
import pl.net.bluesoft.rnd.processtool.model.dict.MultiLevelDictionary;
import pl.net.bluesoft.rnd.processtool.model.dict.ProcessDictionary;
import pl.net.bluesoft.rnd.util.i18n.I18NSource;
import pl.net.bluesoft.rnd.util.i18n.I18NSourceFactory;

public class HelpFactory {
    private Application application;
    private I18NSource i18NSource;
    private ProcessDictionary dict;
    private ContextHelp contextHelp;
    private boolean showKeys;
    private String helpKeysOutputFileName = "keys.txt";
    private BufferedWriter helpKeysOutputFileStream;
    private Map<Integer, Resource> helpIcons = new HashMap<Integer, Resource>();
    private String dictionaryName;

    public HelpFactory(Application application, I18NSource i18NSource, String dictionary, ContextHelp contextHelp) {
        this.application = application;
        this.contextHelp = contextHelp;
        this.dictionaryName = dictionary;
        if (i18NSource == null) {
            i18NSource = I18NSourceFactory.createI18NSource((Locale)application.getLocale());
        }
        this.i18NSource = i18NSource;
        if (application instanceof GenericVaadinPortlet2BpmApplication) {
            GenericVaadinPortlet2BpmApplication o = (GenericVaadinPortlet2BpmApplication)application;
            this.showKeys = o.showKeys();
        }
        ProcessToolContext ctx = ProcessToolContext.Util.getThreadProcessToolContext();
        ProcessDictionaryRegistry registry = ctx.getProcessDictionaryRegistry();
        ArrayList<ProcessDictionary> dictionaries = new ArrayList<ProcessDictionary>();
        ProcessDictionary dictGlobal = registry.getDictionary(dictionary);
        if (dictGlobal != null) {
            dictionaries.add(dictGlobal);
        }
        this.dict = this.createDict(registry, dictionaries);
    }

    private ProcessDictionary createDict(ProcessDictionaryRegistry registry, List<ProcessDictionary> dictionaries) {
        if (dictionaries.isEmpty()) {
            return registry.getEmptyDictionary();
        }
        if (dictionaries.size() == 1) {
            return dictionaries.get(0);
        }
        return new MultiLevelDictionary(dictionaries);
    }

    public Field wrapField(Field field, String key) {
        Button icon = this.helpIcon(key, (Component)field);
        return new FieldWithHelp(field, (Component)icon);
    }

    public Resource helpIcon(Integer i) {
        if (!this.helpIcons.containsKey(i)) {
            this.helpIcons.put(i, (Resource)new ClassResource(HelpUtility.class, "/img/help" + (i == null ? "" : i) + ".png", this.application));
        }
        return this.helpIcons.get(i);
    }

    public Button helpIcon(String key, String message) {
        Button button = this.helpIcon(key);
        button.setCaption(this.i18NSource.getMessage(message));
        button.setWidth("");
        button.addStyleName("with_message");
        return button;
    }

    public Button helpIcon(String key) {
        return this.helpIcon(key, (Component)null);
    }

    public Button helpIcon(String key, Component component) {
        this.logHelpKey(key);
        return HelpUtility.helpIcon(this.dict, this.application, this.i18NSource, this.contextHelp, key, (Boolean)this.showKeys, component, Placement.RIGHT);
    }

    public void showHelp(Component component, String key, Placement placement) {
        this.logHelpKey(key);
        HelpUtility.showHelpFor(this.dict, this.application, this.i18NSource, this.contextHelp, key, this.showKeys, component, placement);
    }

    public ComponentContainer wrapComponentWithHelp(Component component, String key) {
        return this.wrapComponentWithHelp(component, key, Placement.RIGHT, Placement.RIGHT);
    }

    public ComponentContainer wrapComponentWithHelp(Component component, String key, Placement iconPlacement, Placement popupPlacement) {
        this.logHelpKey(key);
        Button icon = HelpUtility.helpIcon(this.dict, this.application, this.i18NSource, this.contextHelp, key, (Boolean)this.showKeys, component, popupPlacement == null ? Placement.RIGHT : popupPlacement);
        Object container = iconPlacement == Placement.ABOVE || iconPlacement == Placement.BELOW ? new VerticalLayout() : new HorizontalLayout();
        container.addStyleName("help-wrapper");
        if (iconPlacement == Placement.ABOVE || iconPlacement == Placement.LEFT) {
            container.addComponent((Component)icon);
            container.addComponent(component);
        } else {
            container.addComponent(component);
            container.addComponent((Component)icon);
        }
        container.setExpandRatio((Component)icon, 0.0f);
        container.setExpandRatio(component, 1.0f);
        return container;
    }

    public ContextHelp getContextHelp() {
        return this.contextHelp;
    }

    public boolean isShowKeys() {
        return this.showKeys;
    }

    public void logHelpKey(String key) {
        this.logHelpKey(this.dictionaryName, key);
    }

    public void logHelpKey(String dictionary, String key) {
        if (this.isShowKeys()) {
            this.initializeLogger();
            try {
                this.helpKeysOutputFileStream.append(dictionary).append(";").append(key).append("\r\n");
                this.helpKeysOutputFileStream.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void initializeLogger() {
        if (this.helpKeysOutputFileStream == null) {
            try {
                this.helpKeysOutputFileStream = new BufferedWriter(new FileWriter(this.helpKeysOutputFileName, true));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        try {
            this.helpKeysOutputFileStream.flush();
            this.helpKeysOutputFileStream.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }
}

