/*
 * Decompiled with CFR 0.152.
 */
package pl.net.bluesoft.rnd.pt.ext.bpmnotifications.templates;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.hibernate.Criteria;
import org.hibernate.Session;
import pl.net.bluesoft.rnd.processtool.ProcessToolContext;
import pl.net.bluesoft.rnd.processtool.template.ProcessToolTemplateErrorException;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.model.BpmNotificationTemplate;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.TemplateData;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.templates.IMailTemplateLoader;

public class MailTemplateProvider
implements IMailTemplateLoader {
    private static final String SUBJECT_TEMPLATE_SUFFIX = "_subject";
    private static final String SENDER_TEMPLATE_SUFFIX = "_sender";
    private Logger logger = Logger.getLogger(MailTemplateProvider.class.getName());
    private Configuration freemarkerConfiguration;
    private Map<String, BpmNotificationTemplate> templateMap = new HashMap<String, BpmNotificationTemplate>();
    private Map<String, String> templateCache = new HashMap<String, String>();

    @Override
    public void refreshConfig() {
        Session session = ProcessToolContext.Util.getThreadProcessToolContext().getHibernateSession();
        List templates = session.createCriteria(BpmNotificationTemplate.class).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).list();
        for (BpmNotificationTemplate t : templates) {
            this.templateMap.put(t.getTemplateName(), t);
            this.templateCache.put(t.getTemplateName(), t.getTemplateBody() != null ? t.getTemplateBody().replaceAll("\\\\u", "\\u") : "");
            this.templateCache.put(t.getTemplateName() + SUBJECT_TEMPLATE_SUFFIX, t.getSubjectTemplate() != null ? t.getSubjectTemplate().replaceAll("\\\\u", "\\u") : "");
            this.templateCache.put(t.getTemplateName() + SENDER_TEMPLATE_SUFFIX, t.getSender());
        }
        this.freemarkerConfiguration = new Configuration();
        this.freemarkerConfiguration.setTemplateLoader((TemplateLoader)this);
    }

    @Override
    public String findTemplate(String templateName) {
        try {
            return (String)this.findTemplateSource(templateName);
        }
        catch (IOException e) {
            throw new ProcessToolTemplateErrorException((Throwable)e);
        }
    }

    @Override
    public BpmNotificationTemplate getBpmNotificationTemplate(String templateName) {
        return this.templateMap.get(templateName);
    }

    @Override
    public String processTemplate(String templateName, TemplateData templateData) throws ProcessToolTemplateErrorException {
        this.logger.info("Using template " + templateName);
        StringWriter sw = new StringWriter();
        try {
            Template template = this.freemarkerConfiguration.getTemplate(templateName);
            template.process(templateData.getData() != null ? templateData.getData() : new HashMap(), (Writer)sw);
        }
        catch (Exception e) {
            throw new ProcessToolTemplateErrorException((Throwable)e);
        }
        sw.flush();
        return sw.toString();
    }

    public Object findTemplateSource(String templateName) throws IOException {
        return this.templateCache.containsKey(templateName) ? this.templateCache.get(templateName) : null;
    }

    public long getLastModified(Object templateSource) {
        return 0L;
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        if (templateSource == null) {
            return null;
        }
        return new StringReader((String)templateSource);
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
    }
}

