/*
 * Decompiled with CFR 0.152.
 */
package pl.net.bluesoft.rnd.pt.ext.bpmnotifications.step;

import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import pl.net.bluesoft.rnd.processtool.model.BpmStep;
import pl.net.bluesoft.rnd.processtool.model.ProcessInstance;
import pl.net.bluesoft.rnd.processtool.model.UserData;
import pl.net.bluesoft.rnd.processtool.model.processdata.ProcessComment;
import pl.net.bluesoft.rnd.processtool.model.processdata.ProcessComments;
import pl.net.bluesoft.rnd.processtool.plugins.ProcessToolRegistry;
import pl.net.bluesoft.rnd.processtool.steps.ProcessToolProcessStep;
import pl.net.bluesoft.rnd.processtool.ui.widgets.annotations.AliasName;
import pl.net.bluesoft.rnd.processtool.ui.widgets.annotations.AutoWiredProperty;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.EmailSender;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.IBpmNotificationService;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.NotificationData;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.TemplateData;
import pl.net.bluesoft.util.lang.cquery.CQuery;
import pl.net.bluesoft.util.lang.cquery.func.F;

@AliasName(name="SendMailStep")
public class SendMailStep
implements ProcessToolProcessStep {
    @AutoWiredProperty
    private String recipient;
    @AutoWiredProperty
    private String profileName = "Default";
    @AutoWiredProperty
    private String template;
    private static final Logger logger = Logger.getLogger(SendMailStep.class.getName());

    public String invoke(BpmStep step, Map<String, String> params) throws Exception {
        IBpmNotificationService service = (IBpmNotificationService)ProcessToolRegistry.Util.getRegistry().getRegisteredService(IBpmNotificationService.class);
        UserData user = this.findUser(this.recipient, step.getProcessInstance());
        TemplateData templateData = service.createTemplateData(this.template, Locale.getDefault());
        service.getTemplateDataProvider().addProcessData(templateData, step.getProcessInstance()).addUserToNotifyData(templateData, user);
        templateData.addEntry("latestComment", this.getLatestComment(step.getProcessInstance()));
        NotificationData notificationData = new NotificationData().setProfileName("Default").setRecipient(user).setTemplateData(templateData);
        EmailSender.sendEmail(service, notificationData);
        try {
            EmailSender.sendEmail(service, notificationData);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error sending email", e);
            return "ERROR";
        }
        return "OK";
    }

    private Object getLatestComment(ProcessInstance processInstance) {
        ProcessComments comments = (ProcessComments)processInstance.findAttributeByClass(ProcessComments.class);
        if (comments != null && !comments.getComments().isEmpty()) {
            ProcessComment comment = (ProcessComment)CQuery.from((Set)comments.getComments()).orderByDescending((F)new F<ProcessComment, Date>(){

                public Date invoke(ProcessComment x) {
                    return x.getCreateTime();
                }
            }).first();
            return comment.getBody();
        }
        return null;
    }

    private UserData findUser(String recipient, ProcessInstance pi) {
        String loginKey;
        if (recipient == null) {
            return null;
        }
        if ((recipient = recipient.trim()).matches("#\\{.*\\}") && (recipient = pi.getSimpleAttributeValue(loginKey = recipient.replaceAll("#\\{(.*)\\}", "$1"))) == null && (recipient = pi.getSimpleAttributeValue(loginKey)) == null) {
            return null;
        }
        return ProcessToolRegistry.Util.getRegistry().getUserSource().getUserByLogin(recipient);
    }
}

