/*
 * Decompiled with CFR 0.152.
 */
package pl.net.bluesoft.rnd.pt.ext.bpmnotifications.sessions;

import java.util.Properties;
import java.util.logging.Logger;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.sessions.IMailSessionProvider;

public class JndiMailSessionProvider
implements IMailSessionProvider {
    private Logger logger = Logger.getLogger(JndiMailSessionProvider.class.getName());

    @Override
    public Session getSession(String profileName) {
        Session mailSession = this.tryLookupForSession("mail/" + profileName);
        if (mailSession == null) {
            mailSession = this.tryLookupForSession("java:comp/env/mail/" + profileName);
        }
        if (mailSession == null) {
            this.logger.severe("Connection name for jndi resource not found: " + profileName);
            throw new IllegalArgumentException("Connection name for jndi resource not found: " + profileName);
        }
        String userName = mailSession.getProperties().getProperty("mail.smtp.user");
        String userPassword = mailSession.getProperties().getProperty("mail.smtp.password");
        String isDebug = mailSession.getProperties().getProperty("mail.debug");
        if (isDebug != null && isDebug.equals("true")) {
            for (Object property : mailSession.getProperties().keySet()) {
                Object value = mailSession.getProperties().get(property);
                this.logger.info("Property " + property + " = " + value);
            }
        }
        if (userPassword == null) {
            userPassword = mailSession.getProperties().getProperty("password");
        }
        JndiAuthenticator authenticator = new JndiAuthenticator(userName, userPassword);
        Session.getInstance((Properties)mailSession.getProperties(), (Authenticator)authenticator);
        return mailSession;
    }

    private Session tryLookupForSession(String profileName) {
        try {
            return (Session)new InitialContext().lookup(profileName);
        }
        catch (NamingException e) {
            this.logger.fine("Connection name for jndi resource not found: " + profileName);
            return null;
        }
    }

    @Override
    public void refreshConfig() {
    }

    private class JndiAuthenticator
    extends Authenticator {
        String userName;
        String userPassword;

        public JndiAuthenticator(String userName, String userPassword) {
            this.userName = userName;
            this.userPassword = userPassword;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.userName, this.userPassword);
        }
    }
}

