/*
 * Decompiled with CFR 0.152.
 */
package pl.net.bluesoft.rnd.pt.ext.bpmnotifications.sessions;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.facade.NotificationsFacade;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.model.BpmNotificationMailProperties;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.sessions.IMailSessionProvider;
import pl.net.bluesoft.util.lang.Strings;

public class DatabaseMailSessionProvider
implements IMailSessionProvider {
    private Logger logger = Logger.getLogger(DatabaseMailSessionProvider.class.getName());
    private Map<String, Properties> persistentMailProperties = new HashMap<String, Properties>();
    private Properties mailProperties;

    @Override
    public Session getSession(String profileName) {
        Properties properties;
        Boolean profileExists = Strings.hasText((String)profileName) && this.getPersistentMailProperties().containsKey(profileName);
        if (profileExists.booleanValue()) {
            properties = this.getPersistentMailProperties().get(profileName);
        } else {
            properties = this.getMailProperties();
            this.logger.warning("Warning, profile " + profileName + " doesn't exist in configuration, using default from mail.properties!");
        }
        String userName = properties.getProperty("mail.smtp.user");
        String userPassword = properties.getProperty("mail.smtp.password");
        String isDebug = properties.getProperty("mail.debug");
        final PasswordAuthentication authentication = new PasswordAuthentication(userName, userPassword);
        Session mailSession = Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return authentication;
            }
        });
        if (isDebug != null && isDebug.equals("true")) {
            mailSession.setDebug(true);
        }
        return mailSession;
    }

    @Override
    public synchronized void refreshConfig() {
        Properties p = new Properties();
        try {
            p.load(this.getClass().getResourceAsStream("/pl/net/bluesoft/rnd/pt/ext/bpmnotifications/mail.properties"));
            this.mailProperties = p;
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e);
        }
        this.persistentMailProperties = new HashMap<String, Properties>();
        Collection<BpmNotificationMailProperties> properties = NotificationsFacade.getNotificationMailProperties();
        for (BpmNotificationMailProperties bnmp : properties) {
            if (Strings.hasText((String)bnmp.getProfileName())) {
                Properties prop = new Properties();
                if (bnmp.isDebug()) {
                    this.logger.info(" mail.smtp.host = " + bnmp.getSmtpHost() + "\n mail.smtp.socketFactory.port = " + bnmp.getSmtpSocketFactoryPort() + "\n mail.smtp.socketFactory.class = " + bnmp.getSmtpSocketFactoryClass() + "\n mail.smtp.auth = " + bnmp.isSmtpAuth() + "\n mail.smtp.port = " + bnmp.getSmtpPort() + "\n mail.smtp.user = " + bnmp.getSmtpUser() + "\n mail.debug = " + bnmp.isDebug() + "\n mail.transport.protocol = " + bnmp.getTransportProtocol() + "\n ssl.SocketFactory.provider = " + bnmp.getSslSocketFactoryClass() + "\n mail.smtp.auth.plain.disable = " + bnmp.isDisablePlainAuth() + "\n mail.smtp.starttls.enable = " + bnmp.isStarttls());
                }
                if (bnmp.getSmtpHost() != null) {
                    prop.put("mail.smtp.host", bnmp.getSmtpHost());
                }
                if (bnmp.getSmtpSocketFactoryPort() != null) {
                    prop.put("mail.smtp.socketFactory.port", bnmp.getSmtpSocketFactoryPort());
                }
                if (bnmp.getSmtpSocketFactoryClass() != null) {
                    prop.put("mail.smtp.socketFactory.class", bnmp.getSmtpSocketFactoryClass());
                }
                if (bnmp.getSmtpPort() != null) {
                    prop.put("mail.smtp.port", bnmp.getSmtpPort());
                }
                if (bnmp.getSmtpUser() != null) {
                    prop.put("mail.smtp.user", bnmp.getSmtpUser());
                }
                if (bnmp.getTransportProtocol() != null) {
                    prop.put("mail.transport.protocol", bnmp.getTransportProtocol());
                }
                if (bnmp.getSslSocketFactoryClass() != null) {
                    prop.put("ssl.SocketFactory.provider", bnmp.getSslSocketFactoryClass());
                }
                if (bnmp.getSmtpPassword() != null) {
                    prop.put("mail.smtp.password", bnmp.getSmtpPassword());
                }
                prop.put("mail.debug", this.getStringValueFromBoolean(bnmp.isDebug()));
                prop.put("mail.smtp.auth", this.getStringValueFromBoolean(bnmp.isSmtpAuth()));
                prop.put("mail.smtp.starttls.enable", this.getStringValueFromBoolean(bnmp.isStarttls()));
                prop.put("mail.smtp.auth.plain.disable", this.getStringValueFromBoolean(bnmp.isDisablePlainAuth()));
                this.persistentMailProperties.put(bnmp.getProfileName(), prop);
                continue;
            }
            this.logger.log(Level.WARNING, "Unable to determine profile name for mail config with id: " + bnmp.getId());
        }
    }

    private synchronized Map<String, Properties> getPersistentMailProperties() {
        return this.persistentMailProperties;
    }

    private synchronized Properties getMailProperties() {
        return this.mailProperties;
    }

    private String getStringValueFromBoolean(Boolean value) {
        if (value == null) {
            return "false";
        }
        if (value.booleanValue()) {
            return "true";
        }
        return "false";
    }
}

