/*
 * Decompiled with CFR 0.152.
 */
package pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import pl.net.bluesoft.rnd.processtool.ProcessToolContext;
import pl.net.bluesoft.rnd.processtool.bpm.ProcessToolBpmSession;
import pl.net.bluesoft.rnd.processtool.di.ObjectFactory;
import pl.net.bluesoft.rnd.processtool.model.BpmTask;
import pl.net.bluesoft.rnd.processtool.model.ProcessInstance;
import pl.net.bluesoft.rnd.processtool.model.UserData;
import pl.net.bluesoft.rnd.processtool.model.config.ProcessStateConfiguration;
import pl.net.bluesoft.rnd.processtool.plugins.ProcessToolRegistry;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.addons.INotificationsAddonsManager;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.model.BpmNotificationConfig;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.ITemplateDataProvider;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.TemplateArgumentDescription;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.TemplateArgumentProvider;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.TemplateArgumentProviderParams;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.TemplateData;
import pl.net.bluesoft.rnd.util.TaskUtil;
import pl.net.bluesoft.rnd.util.i18n.I18NSource;
import pl.net.bluesoft.rnd.util.i18n.I18NSourceFactory;
import pl.net.bluesoft.util.lang.Strings;

public class TemplateDataProvider
implements ITemplateDataProvider {
    private final Set<TemplateArgumentProvider> argumentProviders = new HashSet<TemplateArgumentProvider>();

    @Override
    public TemplateData createTemplateData(String templateName, Locale locale) {
        I18NSource messageSource = I18NSourceFactory.createI18NSource((Locale)locale);
        return new TemplateData(templateName, locale, messageSource);
    }

    @Override
    public ITemplateDataProvider addTaskData(TemplateData templateData, BpmTask task) {
        if (task == null) {
            return this;
        }
        ProcessToolContext ctx = ProcessToolContext.Util.getThreadProcessToolContext();
        ProcessInstance pi = task.getProcessInstance();
        templateData.addEntry("task", task);
        pi = (ProcessInstance)ctx.getProcessInstanceDAO().refresh((Object)pi);
        for (ProcessStateConfiguration st : pi.getDefinition().getStates()) {
            if (!task.getTaskName().equals(st.getName())) continue;
            templateData.addEntry("taskName", templateData.getMessageSource().getMessage(st.getDescription()));
            break;
        }
        templateData.addEntry("taskUrl", TaskUtil.getTaskLink((BpmTask)task, (ProcessToolContext)ctx));
        templateData.addEntry("taskLink", TaskUtil.getTaskLink((BpmTask)task, (ProcessToolContext)ctx));
        templateData.addEntry("assignee", task.getAssignee());
        this.addTaskDataFromAddonManager(templateData, task, ctx);
        return this;
    }

    private void addTaskDataFromAddonManager(TemplateData templateData, BpmTask task, ProcessToolContext ctx) {
        INotificationsAddonsManager addonsManager = (INotificationsAddonsManager)ObjectFactory.create(INotificationsAddonsManager.class, (Object[])new Object[0]);
        addonsManager.addData(templateData, task, ctx);
    }

    @Override
    public TemplateDataProvider addProcessData(TemplateData templateData, ProcessInstance pi) {
        templateData.addEntry("processVisibleId", Strings.hasText((String)pi.getExternalKey()) ? pi.getExternalKey() : pi.getInternalId());
        templateData.addEntry("processId", Strings.hasText((String)pi.getExternalKey()) ? pi.getExternalKey() : pi.getInternalId());
        templateData.addEntry("process", pi);
        templateData.addEntry("creator", ProcessToolRegistry.Util.getRegistry().getUserSource().getUserByLogin(pi.getCreatorLogin()));
        return this;
    }

    @Override
    public TemplateDataProvider addUserToNotifyData(TemplateData templateData, UserData userToNotify) {
        templateData.addEntry("user", userToNotify);
        return this;
    }

    @Override
    public TemplateDataProvider addContextAdditionalData(TemplateData templateData, BpmNotificationConfig cfg, ProcessToolBpmSession bpmSession) {
        ProcessToolContext ctx = ProcessToolContext.Util.getThreadProcessToolContext();
        templateData.addEntry("session", bpmSession);
        templateData.addEntry("context", ctx);
        templateData.addEntry("config", (Object)cfg);
        return this;
    }

    @Override
    public TemplateDataProvider addArgumentProvidersData(TemplateData templateData, BpmNotificationConfig cfg, ProcessInstance pi) {
        if (Strings.hasText((String)cfg.getTemplateArgumentProvider())) {
            for (TemplateArgumentProvider argumentProvider : this.argumentProviders) {
                if (!cfg.getTemplateArgumentProvider().equalsIgnoreCase(argumentProvider.getName())) continue;
                TemplateArgumentProviderParams params = new TemplateArgumentProviderParams();
                params.setProcessInstance(pi);
                argumentProvider.addData(templateData, params);
                break;
            }
        }
        return this;
    }

    @Override
    public void registerTemplateArgumentProvider(TemplateArgumentProvider provider) {
        this.argumentProviders.add(provider);
    }

    @Override
    public void unregisterTemplateArgumentProvider(TemplateArgumentProvider provider) {
        this.argumentProviders.add(provider);
    }

    @Override
    public Collection<TemplateArgumentProvider> getTemplateArgumentProviders() {
        return new ArrayList<TemplateArgumentProvider>(this.argumentProviders);
    }

    @Override
    public List<TemplateArgumentDescription> getDefaultArgumentDescriptions(I18NSource i18NSource) {
        return Arrays.asList(this.descr("processVisibleId", "Process visible id, external process key or internal id if external doesn't exist", i18NSource), this.descr("processId", "Process id in database", i18NSource), this.descr("process", "Process instance, you can access all process properties if seperatre by dot", i18NSource), this.descr("user", "Current assignee instance (UserData), you can access all process properties if seperatre by dot.", i18NSource), this.descr("assignee", "Current assignee instance (UserData), you can access all process properties if seperatre by dot.", i18NSource), this.descr("creator", "Process creator instance (UserData), you can access all process properties if seperatre by dot.", i18NSource), this.descr("session", "Current session instance, do not use in template", i18NSource), this.descr("context", "Current context instance, do not use in template", i18NSource), this.descr("config", "Current template config instance, do not use in template ", i18NSource), this.descr("task", "If task exists, this is instance of current BpmTask", i18NSource), this.descr("taskName", "If task exists, this is the name of current BpmTask", i18NSource), this.descr("taskUrl", "If task exists, this is url link for webbrowser to this task", i18NSource), this.descr("taskLink", "If task exists, this is url link for webbrowser to this task", i18NSource));
    }

    private TemplateArgumentDescription descr(String name, String i18NKey, I18NSource i18NSource) {
        return new TemplateArgumentDescription(name, i18NSource.getMessage(i18NKey));
    }
}

