/*
 * Decompiled with CFR 0.152.
 */
package pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.model.BpmNotification;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.NotificationHistoryEntry;

public class NotificationHistory {
    private final LinkedList<NotificationHistoryEntry> entries = new LinkedList();
    private final Map<Long, NotificationHistoryEntry> entriesByNotificationId = new HashMap<Long, NotificationHistoryEntry>();
    private final int maxEntries;

    public NotificationHistory(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    public synchronized void notificationEnqueued(BpmNotification notification) {
        this.getEntry(notification).setEnqueueDate(new Date());
    }

    public synchronized void notificationSent(BpmNotification notification) {
        this.getEntry(notification).setSendDate(new Date());
    }

    public synchronized void errorWhileSendingNotification(BpmNotification notification, Exception e) {
        NotificationHistoryEntry entry = this.getEntry(notification);
        entry.setSendDate(new Date());
        entry.setSendingException(e);
    }

    public synchronized List<NotificationHistoryEntry> getRecentEntries() {
        return new ArrayList<NotificationHistoryEntry>(this.entries);
    }

    private NotificationHistoryEntry getEntry(BpmNotification notification) {
        NotificationHistoryEntry entry = this.entriesByNotificationId.get(notification.getId());
        if (entry != null) {
            return entry;
        }
        entry = new NotificationHistoryEntry();
        entry.setBpmNotificationId(notification.getId());
        entry.setSender(notification.getSender());
        entry.setRecipient(notification.getRecipient());
        entry.setSubject(notification.getSubject());
        entry.setBody(notification.getBody());
        entry.setAsHtml(notification.getSendAsHtml());
        this.entries.add(entry);
        this.entriesByNotificationId.put(notification.getId(), entry);
        if (this.maxEntries > 0 && this.entries.size() > this.maxEntries) {
            NotificationHistoryEntry removedEntry = this.entries.removeFirst();
            this.entriesByNotificationId.remove(removedEntry.getBpmNotificationId());
        }
        return entry;
    }
}

