/*
 * Decompiled with CFR 0.152.
 */
package pl.net.bluesoft.rnd.pt.ext.bpmnotifications;

import java.util.logging.Logger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import pl.net.bluesoft.rnd.processtool.plugins.ProcessToolRegistry;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.BpmNotificationEngine;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.HandleEmailsJob;
import pl.net.bluesoft.rnd.pt.ext.sched.service.ProcessToolSchedulerService;

public class SchedulersActivator {
    private static final Logger logger = Logger.getLogger(SchedulersActivator.class.getName());
    private ProcessToolRegistry registry;

    public SchedulersActivator(ProcessToolRegistry registry) {
        this.registry = registry;
    }

    public void scheduleNotificationsSend(BpmNotificationEngine engine) {
        ProcessToolSchedulerService service = this.getSchedulerService();
        JobDataMap dataMap = new JobDataMap();
        dataMap.put("bpmNotificationEngine", (Object)engine);
        String identity = "engine_notifications";
        JobDetail jobDetail = JobBuilder.newJob(HandleEmailsJob.class).withIdentity(identity, HandleEmailsJob.class.getName()).usingJobData(dataMap).build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(identity, HandleEmailsJob.class.getName()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(30).repeatForever()).forJob(jobDetail).build();
        logger.info("Scheduling notifications job handler");
        service.scheduleJob(jobDetail, new Trigger[]{trigger});
    }

    private ProcessToolSchedulerService getSchedulerService() {
        return (ProcessToolSchedulerService)this.registry.getRegisteredService(ProcessToolSchedulerService.class);
    }
}

