/*
 * Decompiled with CFR 0.152.
 */
package pl.net.bluesoft.rnd.pt.ext.bpmnotifications;

import java.net.ConnectException;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.exception.LockAcquisitionException;
import pl.net.bluesoft.rnd.processtool.ProcessToolContext;
import pl.net.bluesoft.rnd.processtool.ProcessToolContextCallback;
import pl.net.bluesoft.rnd.processtool.ReturningProcessToolContextCallback;
import pl.net.bluesoft.rnd.processtool.bpm.ProcessToolBpmSession;
import pl.net.bluesoft.rnd.processtool.di.ObjectFactory;
import pl.net.bluesoft.rnd.processtool.di.annotations.AutoInject;
import pl.net.bluesoft.rnd.processtool.model.BpmTask;
import pl.net.bluesoft.rnd.processtool.model.ProcessInstance;
import pl.net.bluesoft.rnd.processtool.model.UserData;
import pl.net.bluesoft.rnd.processtool.plugins.ProcessToolRegistry;
import pl.net.bluesoft.rnd.processtool.template.ProcessToolTemplateErrorException;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.facade.NotificationsFacade;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.model.BpmNotification;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.model.BpmNotificationConfig;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.IBpmNotificationService;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.ITemplateDataProvider;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.NotificationData;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.NotificationHistory;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.NotificationHistoryEntry;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.ProcessedNotificationData;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.TemplateArgumentDescription;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.TemplateArgumentProvider;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.TemplateData;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.sessions.IMailSessionProvider;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.settings.NotificationsSettingsProvider;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.templates.IMailTemplateLoader;
import pl.net.bluesoft.rnd.util.i18n.I18NSource;
import pl.net.bluesoft.util.lang.Strings;

public class BpmNotificationEngine
implements IBpmNotificationService {
    private static final long CONFIG_DEFAULT_CACHE_REFRESH_INTERVAL = 5000L;
    private static final String SUBJECT_TEMPLATE_SUFFIX = "_subject";
    private static final String SENDER_TEMPLATE_SUFFIX = "_sender";
    private static final String DEFAULT_PROFILE_NAME = "Default";
    private static final String REFRESH_INTERVAL = "mail.settings.refresh.interval";
    private static final String MAIL_ENCODING = "UTF-8";
    private static final Logger logger = Logger.getLogger(BpmNotificationEngine.class.getName());
    private Collection<BpmNotificationConfig> configCache = new HashSet<BpmNotificationConfig>();
    private long cacheUpdateTime;
    private long refrshInterval;
    private ProcessToolBpmSession bpmSession;
    @AutoInject
    private ITemplateDataProvider templateDataProvider;
    private ProcessToolRegistry registry;
    @AutoInject
    private IMailSessionProvider mailSessionProvider;
    @AutoInject
    private IMailTemplateLoader templateProvider;
    private NotificationHistory history = new NotificationHistory(1000);

    public BpmNotificationEngine(ProcessToolRegistry registry) {
        this.registry = registry;
        try {
            this.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void init() {
        if (ProcessToolContext.Util.getThreadProcessToolContext() != null) {
            this.initComponents();
        } else {
            this.registry.withProcessToolContext((ReturningProcessToolContextCallback)new ProcessToolContextCallback(){

                public void withContext(ProcessToolContext ctx) {
                    BpmNotificationEngine.this.initComponents();
                }
            });
        }
    }

    private void initComponents() {
        ObjectFactory.inject((Object)this);
        this.readRefreshIntervalFromSettings();
        this.templateProvider.refreshConfig();
        this.mailSessionProvider.refreshConfig();
        logger.info("[NOTIFICATIONS] Notifications engine initialized");
    }

    public void handleNotifications() {
        this.registry.withProcessToolContext((ReturningProcessToolContextCallback)new ProcessToolContextCallback(){

            public void withContext(ProcessToolContext ctx) {
                BpmNotificationEngine.this.handleNotificationsWithContext();
            }
        });
    }

    public void handleNotificationsWithContext() {
        logger.info("[NOTIFICATIONS JOB] Checking awaiting notifications... ");
        try {
            Collection<BpmNotification> notificationsToSend = NotificationsFacade.getNotificationsToSend();
            logger.info("[NOTIFICATIONS JOB] " + notificationsToSend.size() + " notifications waiting to be sent...");
            for (BpmNotification notification : notificationsToSend) {
                try {
                    this.sendNotification(notification);
                    NotificationsFacade.removeNotification(notification);
                }
                catch (ConnectException ex) {
                    logger.log(Level.SEVERE, "[NOTIFICATIONS JOB] Could not connect to server", ex);
                    this.history.errorWhileSendingNotification(notification, ex);
                    break;
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "[NOTIFICATIONS JOB] Problem during notification sending", ex);
                    this.history.errorWhileSendingNotification(notification, ex);
                }
            }
        }
        catch (LockAcquisitionException lockAcquisitionException) {
            // empty catch block
        }
    }

    public void onProcessStateChange(BpmTask task, ProcessInstance pi, String userLogin, boolean processStarted, boolean processEnded, boolean enteringStep) {
        this.refreshConfigIfNecessary();
        ProcessToolContext ctx = ProcessToolContext.Util.getThreadProcessToolContext();
        for (BpmNotificationConfig cfg : this.configCache) {
            try {
                String lastAction;
                if (enteringStep != cfg.isOnEnteringStep() || processStarted != cfg.isNotifyOnProcessStart() || processEnded != cfg.isNotifyOnProcessEnd() || cfg.isNotifyOnProcessEnd() && task.getProcessInstance().getParent() != null || Strings.hasText((String)cfg.getProcessTypeRegex()) && !pi.getDefinitionName().toLowerCase().matches(cfg.getProcessTypeRegex().toLowerCase()) || Strings.hasText((String)cfg.getStateRegex()) && (task == null || !task.getTaskName().toLowerCase().matches(cfg.getStateRegex().toLowerCase())) || Strings.hasText((String)cfg.getLastActionRegex()) && ((lastAction = pi.getSimpleAttributeValue("ACTION")) == null || !lastAction.toLowerCase().matches(cfg.getLastActionRegex().toLowerCase()))) continue;
                logger.info("Matched notification #" + cfg.getId() + " for process state change #" + pi.getInternalId());
                LinkedList<UserData> recipients = new LinkedList<UserData>();
                if (task != null && cfg.isNotifyTaskAssignee()) {
                    UserData assignee = ProcessToolRegistry.Util.getRegistry().getUserSource().getUserByLogin(task.getAssignee());
                    if (cfg.isSkipNotificationWhenTriggeredByAssignee() && assignee != null && assignee.getLogin() != null && assignee.getLogin().equals(userLogin)) {
                        logger.info("Not notifying user " + assignee.getLogin() + " - this user has initiated processed action");
                        continue;
                    }
                    if (assignee != null && Strings.hasText((String)assignee.getEmail())) {
                        recipients.add(assignee);
                        logger.info("Notification will be sent to " + assignee.getEmail());
                    }
                }
                if (Strings.hasText((String)cfg.getNotifyEmailAddresses())) {
                    for (String userEmail : cfg.getNotifyEmailAddresses().split(",")) {
                        UserData recipient = ProcessToolRegistry.Util.getRegistry().getUserSource().getUserByEmail(userEmail);
                        recipients.add(recipient);
                    }
                }
                if (Strings.hasText((String)cfg.getNotifyUserAttributes())) {
                    recipients.addAll(this.extractUsers(cfg.getNotifyUserAttributes(), ctx, pi));
                }
                if (recipients.isEmpty()) {
                    logger.info("Despite matched rules, no emails qualify to notify for cfg #" + cfg.getId());
                    continue;
                }
                String templateName = cfg.getTemplateName();
                Locale locale = cfg.getLocale() != null ? new Locale(cfg.getLocale()) : Locale.getDefault();
                for (UserData recipient : recipients) {
                    TemplateData templateData = this.createTemplateData(templateName, locale);
                    this.templateDataProvider.addTaskData(templateData, task).addProcessData(templateData, pi).addUserToNotifyData(templateData, ProcessToolRegistry.Util.getRegistry().getUserSource().getUserByLogin(userLogin)).addArgumentProvidersData(templateData, cfg, pi).addContextAdditionalData(templateData, cfg, this.bpmSession);
                    NotificationData notificationData = new NotificationData();
                    notificationData.setProfileName(DEFAULT_PROFILE_NAME).setTemplateData(templateData).setRecipient(recipient);
                    this.addNotificationToSend(notificationData);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    private void readRefreshIntervalFromSettings() {
        String refreshIntervalString = NotificationsSettingsProvider.getRefreshInterval();
        this.refrshInterval = refreshIntervalString == null ? 5000L : Long.parseLong(refreshIntervalString);
    }

    private Collection<UserData> extractUsers(String notifyUserAttributes, ProcessToolContext ctx, ProcessInstance pi) {
        pi = (ProcessInstance)ctx.getProcessInstanceDAO().refresh((Object)pi);
        HashSet<UserData> users = new HashSet<UserData>();
        for (String attribute : notifyUserAttributes.split(",")) {
            String loginKey;
            if ((attribute = attribute.trim()).matches("#\\{.*\\}") && (attribute = pi.getInheritedSimpleAttributeValue(loginKey = attribute.replaceAll("#\\{(.*)\\}", "$1"))) != null && attribute.matches("#\\{.*\\}") || !Strings.hasText((String)attribute)) continue;
            UserData user = ProcessToolRegistry.Util.getRegistry().getUserSource().getUserByLogin(attribute);
            users.add(user);
        }
        return users;
    }

    @Override
    public void registerTemplateArgumentProvider(TemplateArgumentProvider provider) {
        this.templateDataProvider.registerTemplateArgumentProvider(provider);
    }

    @Override
    public void unregisterTemplateArgumentProvider(TemplateArgumentProvider provider) {
        this.templateDataProvider.unregisterTemplateArgumentProvider(provider);
    }

    @Override
    public Collection<TemplateArgumentProvider> getTemplateArgumentProviders() {
        return this.templateDataProvider.getTemplateArgumentProviders();
    }

    @Override
    public List<TemplateArgumentDescription> getDefaultArgumentDescriptions(I18NSource i18NSource) {
        return this.templateDataProvider.getDefaultArgumentDescriptions(i18NSource);
    }

    @Override
    public List<NotificationHistoryEntry> getNotificationHistoryEntries() {
        return this.history.getRecentEntries();
    }

    @Override
    public synchronized void invalidateCache() {
        this.cacheUpdateTime = 0L;
    }

    public synchronized void refreshConfigIfNecessary() {
        if (this.cacheUpdateTime + this.refrshInterval < System.currentTimeMillis()) {
            org.hibernate.Session session = ProcessToolContext.Util.getThreadProcessToolContext().getHibernateSession();
            this.configCache = session.createCriteria(BpmNotificationConfig.class).add((Criterion)Restrictions.eq((String)"active", (Object)true)).addOrder(Order.asc((String)"id")).list();
            this.cacheUpdateTime = System.currentTimeMillis();
            this.readRefreshIntervalFromSettings();
            ObjectFactory.inject((Object)this);
            this.templateProvider.refreshConfig();
            this.mailSessionProvider.refreshConfig();
            this.bpmSession = ProcessToolRegistry.Util.getRegistry().getProcessToolSessionFactory().createAutoSession();
            logger.info("Mail configuration updated. Interval is set to " + this.refrshInterval);
        }
    }

    @Override
    public void addNotificationToSend(NotificationData notificationData) throws Exception {
        ProcessedNotificationData processedNotificationData = this.processNotificationData(notificationData);
        this.addNotificationToSend(processedNotificationData);
    }

    @Override
    public void addNotificationToSend(ProcessedNotificationData processedNotificationData) throws Exception {
        if (!processedNotificationData.hasSender()) {
            UserData autoUser = ProcessToolRegistry.Util.getRegistry().getAutoUser();
            processedNotificationData.setSender(autoUser.getEmail());
        }
        if (processedNotificationData.getRecipient() == null) {
            throw new IllegalArgumentException("Cannot send email: Recipient is null!");
        }
        BpmNotification notification = new BpmNotification();
        notification.setSender(processedNotificationData.getSender());
        notification.setSubject(processedNotificationData.getSubject());
        notification.setBody(processedNotificationData.getBody());
        notification.setRecipient(processedNotificationData.getRecipient().getEmail());
        notification.setSendAsHtml(processedNotificationData.isSendAsHtml());
        notification.setProfileName(processedNotificationData.getProfileName());
        StringBuilder attachmentsString = new StringBuilder();
        int attachmentsSize = processedNotificationData.getAttachments().size();
        for (String attachment : processedNotificationData.getAttachments()) {
            attachmentsString.append(attachment);
            if (--attachmentsSize <= 0) continue;
            attachmentsString.append(",");
        }
        notification.setAttachments(attachmentsString.toString());
        NotificationsFacade.addNotificationToBeSent(notification);
        this.history.notificationEnqueued(notification);
        logger.info("EmailSender email sent: sender=" + processedNotificationData.getSender() + "\n recipientEmail=" + processedNotificationData.getRecipient().getEmail() + "\n subject=" + processedNotificationData.getSubject() + "\n body=" + processedNotificationData.getBody());
    }

    private void sendNotification(BpmNotification notification) throws Exception {
        Session mailSession = this.mailSessionProvider.getSession(notification.getProfileName());
        Message message = BpmNotificationEngine.createMessageFromNotification(notification, mailSession);
        try {
            if (this.isSmtpsRequired(mailSession)) {
                Properties emailPrtoperties = mailSession.getProperties();
                String secureHost = emailPrtoperties.getProperty("mail.smtp.host");
                String securePort = emailPrtoperties.getProperty("mail.smtp.port");
                String userName = emailPrtoperties.getProperty("mail.smtp.user");
                String userPassword = emailPrtoperties.getProperty("mail.smtp.password");
                Transport transport = mailSession.getTransport("smtps");
                transport.connect(secureHost, Integer.parseInt(securePort), userName, userPassword);
                transport.sendMessage(message, message.getAllRecipients());
                transport.close();
            } else {
                Transport.send((Message)message);
            }
            this.history.notificationSent(notification);
            logger.info("Emails sent");
        }
        catch (Exception e) {
            this.history.errorWhileSendingNotification(notification, e);
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public static Message createMessageFromNotification(BpmNotification notification, Session mailSession) throws Exception {
        MimeMessage message = new MimeMessage(mailSession);
        message.setFrom((Address)new InternetAddress(notification.getSender()));
        message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)notification.getRecipient()));
        message.setSubject(notification.getSubject());
        message.setSentDate(new Date());
        MimeBodyPart messagePart = new MimeBodyPart();
        messagePart.setContent((Object)notification.getBody(), (notification.getSendAsHtml() != false ? "text/html" : "text/plain") + "; charset=\"" + MAIL_ENCODING + "\"");
        MimeMultipart multipart = new MimeMultipart("alternative");
        multipart.addBodyPart((BodyPart)messagePart);
        int counter = 0;
        if (notification.getAttachments() != null && !notification.getAttachments().isEmpty()) {
            String[] attachments;
            for (String u : attachments = notification.getAttachments().split(",")) {
                if (!Strings.hasText((String)u)) continue;
                URL url = new URL(u);
                MimeBodyPart attachmentPart = new MimeBodyPart();
                URLDataSource urlDs = new URLDataSource(url);
                attachmentPart.setDataHandler(new DataHandler((DataSource)urlDs));
                attachmentPart.setFileName("file" + counter++);
                multipart.addBodyPart((BodyPart)attachmentPart);
                logger.info("Added attachment " + u);
            }
        }
        message.setContent((Multipart)multipart);
        message.setSentDate(new Date());
        return message;
    }

    private boolean isSmtpsRequired(Session mailSession) {
        Properties emailPrtoperties = mailSession.getProperties();
        String transportProtocol = emailPrtoperties.getProperty("mail.transport.protocol");
        return "smtps".equals(transportProtocol);
    }

    @Override
    public String findTemplate(String templateName) {
        this.refreshConfigIfNecessary();
        return this.templateProvider.findTemplate(templateName);
    }

    @Override
    public String processTemplate(String templateName, TemplateData templateData) {
        this.refreshConfigIfNecessary();
        try {
            String messageBody = this.templateProvider.processTemplate(templateName, templateData);
            return messageBody;
        }
        catch (ProcessToolTemplateErrorException ex) {
            return "[ERROR] There was a problem with message template! <br>Plase contact administrator and send him following error message: <br>" + ex.getMessage();
        }
    }

    @Override
    public TemplateData createTemplateData(String templateName, Locale locale) {
        return this.templateDataProvider.createTemplateData(templateName, locale);
    }

    @Override
    public ProcessedNotificationData processNotificationData(NotificationData notificationData) throws Exception {
        String body = this.processTemplate(notificationData.getTemplateData().getTemplateName(), notificationData.getTemplateData());
        String topic = this.processTemplate(notificationData.getTemplateData().getTemplateName() + SUBJECT_TEMPLATE_SUFFIX, notificationData.getTemplateData());
        String sender = this.findTemplate(notificationData.getTemplateData().getTemplateName() + SENDER_TEMPLATE_SUFFIX);
        if (body == null || topic == null || sender == null) {
            throw new Exception("Error sending email. Cannot find valid template configuration");
        }
        ProcessedNotificationData processedNotificationData = new ProcessedNotificationData(notificationData);
        processedNotificationData.setBody(body).setSubject(topic).setSender(sender);
        return processedNotificationData;
    }

    @Override
    public ITemplateDataProvider getTemplateDataProvider() {
        return this.templateDataProvider;
    }
}

