/*
 * Decompiled with CFR 0.152.
 */
package pl.net.bluesoft.rnd.pt.ext.bpmnotifications;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aperteworkflow.ui.view.GenericPortletViewRenderer;
import org.aperteworkflow.ui.view.IViewRegistry;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import pl.net.bluesoft.rnd.processtool.ProcessToolContext;
import pl.net.bluesoft.rnd.processtool.ProcessToolContextCallback;
import pl.net.bluesoft.rnd.processtool.ReturningProcessToolContextCallback;
import pl.net.bluesoft.rnd.processtool.bpm.BpmEvent;
import pl.net.bluesoft.rnd.processtool.di.ClassDependencyManager;
import pl.net.bluesoft.rnd.processtool.plugins.ProcessToolRegistry;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.BpmNotificationEngine;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.NotificationsConstants;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.SchedulersActivator;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.addons.INotificationsAddonsManager;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.addons.mock.impl.NotificationAddonsMockManager;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.event.MailEvent;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.event.MailEventListener;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.portlet.BpmAdminPortletRender;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.IBpmNotificationService;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.ITemplateDataProvider;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.service.TemplateDataProvider;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.sessions.DatabaseMailSessionProvider;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.sessions.IMailSessionProvider;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.sessions.JndiMailSessionProvider;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.settings.NotificationsSettingsProvider;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.templates.IMailTemplateLoader;
import pl.net.bluesoft.rnd.pt.ext.bpmnotifications.templates.MailTemplateProvider;
import pl.net.bluesoft.util.eventbus.EventListener;

public class Activator
implements BundleActivator,
EventListener<BpmEvent> {
    private Logger logger = Logger.getLogger(Activator.class.getName());
    private BpmNotificationEngine engine;
    MailEventListener mailEventListener;
    private SchedulersActivator schedulerActivator;

    public void start(BundleContext context) throws Exception {
        final ProcessToolRegistry registry = this.getRegistry(context);
        registry.withProcessToolContext((ReturningProcessToolContextCallback)new ProcessToolContextCallback(){

            public void withContext(ProcessToolContext ctx) {
                Activator.this.injectImplementation();
                Activator.this.engine = new BpmNotificationEngine(registry);
            }
        });
        this.schedulerActivator = new SchedulersActivator(registry);
        registry.registerService(IBpmNotificationService.class, (Object)this.engine, new Properties());
        registry.getEventBusManager().subscribe(BpmEvent.class, (EventListener)this);
        this.mailEventListener = new MailEventListener(this.engine);
        registry.getEventBusManager().subscribe(MailEvent.class, (EventListener)this.mailEventListener);
        this.schedulerActivator.scheduleNotificationsSend(this.engine);
        this.getViewRegistry(registry).registerGenericPortletViewRenderer("admin", (GenericPortletViewRenderer)BpmAdminPortletRender.INSTANCE);
        this.getViewRegistry(registry).registerGenericPortletViewRenderer("user", (GenericPortletViewRenderer)BpmAdminPortletRender.INSTANCE);
    }

    private void injectImplementation() {
        this.logger.info("Injecting Liferay dependencies...");
        String providerName = NotificationsSettingsProvider.getProviderType();
        if (providerName == null) {
            this.logger.info("Mail session provider set to database");
            ClassDependencyManager.getInstance().injectImplementation(IMailSessionProvider.class, DatabaseMailSessionProvider.class, 1);
        } else if (providerName.equals(NotificationsConstants.ProviderType.JNDI.getParamterName())) {
            this.logger.info("Mail session provider set to jndi resources");
            ClassDependencyManager.getInstance().injectImplementation(IMailSessionProvider.class, JndiMailSessionProvider.class, 1);
        } else if (providerName.equals(NotificationsConstants.ProviderType.DATABASE.getParamterName())) {
            this.logger.info("Mail session provider set to database");
            ClassDependencyManager.getInstance().injectImplementation(IMailSessionProvider.class, DatabaseMailSessionProvider.class, 1);
        } else {
            this.logger.severe("Unknown provider [" + providerName + "]!");
            ClassDependencyManager.getInstance().injectImplementation(IMailSessionProvider.class, DatabaseMailSessionProvider.class, 1);
        }
        ClassDependencyManager.getInstance().injectImplementation(ITemplateDataProvider.class, TemplateDataProvider.class, 1);
        ClassDependencyManager.getInstance().injectImplementation(IMailTemplateLoader.class, MailTemplateProvider.class, 1);
        ClassDependencyManager.getInstance().injectImplementation(INotificationsAddonsManager.class, NotificationAddonsMockManager.class);
    }

    public void stop(BundleContext context) throws Exception {
        ProcessToolRegistry registry = this.getRegistry(context);
        registry.removeRegisteredService(IBpmNotificationService.class);
        registry.getEventBusManager().unsubscribe(BpmEvent.class, (EventListener)this);
        registry.getEventBusManager().unsubscribe(MailEvent.class, (EventListener)this.mailEventListener);
        this.mailEventListener = null;
        this.getViewRegistry(registry).unregisterGenericPortletViewRenderer("admin", (GenericPortletViewRenderer)BpmAdminPortletRender.INSTANCE);
        this.getViewRegistry(registry).unregisterGenericPortletViewRenderer("user", (GenericPortletViewRenderer)BpmAdminPortletRender.INSTANCE);
    }

    private ProcessToolRegistry getRegistry(BundleContext context) {
        ServiceReference ref = context.getServiceReference(ProcessToolRegistry.class.getName());
        return (ProcessToolRegistry)context.getService(ref);
    }

    public void onEvent(BpmEvent e) {
        if (BpmEvent.Type.NEW_PROCESS == e.getEventType() || BpmEvent.Type.END_PROCESS == e.getEventType()) {
            this.logger.log(Level.INFO, "Received event " + e.getEventType() + " for process " + e.getProcessInstance().getId());
        } else if (BpmEvent.Type.ASSIGN_TASK == e.getEventType() || BpmEvent.Type.SIGNAL_PROCESS == e.getEventType()) {
            this.logger.log(Level.INFO, "Received event " + e.getEventType() + " for task " + e.getProcessInstance().getExternalKey() + "/" + e.getTask().getTaskName());
        }
        if (BpmEvent.Type.ASSIGN_TASK == e.getEventType() || BpmEvent.Type.NEW_PROCESS == e.getEventType() || BpmEvent.Type.SIGNAL_PROCESS == e.getEventType() || BpmEvent.Type.END_PROCESS == e.getEventType()) {
            boolean processStarted = BpmEvent.Type.NEW_PROCESS == e.getEventType();
            boolean processEnded = BpmEvent.Type.END_PROCESS == e.getEventType();
            boolean enteringStep = BpmEvent.Type.ASSIGN_TASK == e.getEventType() || BpmEvent.Type.NEW_PROCESS == e.getEventType();
            this.engine.onProcessStateChange(e.getTask(), e.getProcessInstance(), e.getUserLogin(), processStarted, processEnded, enteringStep);
        }
    }

    private IViewRegistry getViewRegistry(ProcessToolRegistry registry) {
        return (IViewRegistry)registry.getRegisteredService(IViewRegistry.class);
    }
}

