/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.inspektr.audit.support;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.audit.AuditTrailManager;

public abstract class AbstractStringAuditTrailManager
implements AuditTrailManager {
    private AuditTrailManager.AuditFormats auditFormat = AuditTrailManager.AuditFormats.DEFAULT;
    private boolean useSingleLine = false;
    private String entrySeparator = ",";
    private List<AuditTrailManager.AuditableFields> auditableFields = new ArrayList<AuditTrailManager.AuditableFields>();

    public void setUseSingleLine(boolean useSingleLine) {
        this.useSingleLine = useSingleLine;
    }

    @Override
    public void setAuditFormat(AuditTrailManager.AuditFormats auditFormat) {
        this.auditFormat = auditFormat;
    }

    public void setAuditableFields(List<AuditTrailManager.AuditableFields> auditableFields) {
        this.auditableFields = auditableFields;
    }

    @Override
    public Set<? extends AuditActionContext> getAuditRecords(Map<AuditTrailManager.WhereClauseFields, Object> whereClause) {
        return new HashSet();
    }

    protected String getEntrySeparator() {
        return this.entrySeparator;
    }

    public void setEntrySeparator(String separator) {
        this.entrySeparator = separator;
    }

    protected String toString(AuditActionContext auditActionContext) {
        if (this.auditFormat == AuditTrailManager.AuditFormats.JSON) {
            StringBuilder builder = new StringBuilder();
            try {
                if (this.useSingleLine) {
                    ObjectWriter writer = MAPPER.writer((PrettyPrinter)new MinimalPrettyPrinter());
                    builder.append(writer.writeValueAsString((Object)this.getMappedAuditActionContext(auditActionContext)));
                } else {
                    builder.append(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.getMappedAuditActionContext(auditActionContext)));
                    builder.append("\n");
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            return builder.toString();
        }
        return this.getAuditLineString(auditActionContext);
    }

    protected String getAuditLineString(AuditActionContext auditActionContext) {
        StringBuilder builder = new StringBuilder();
        if (!this.useSingleLine) {
            builder.append("Audit trail record BEGIN\n");
            builder.append("=============================================================\n");
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains((Object)AuditTrailManager.AuditableFields.WHEN)) {
            if (this.useSingleLine) {
                builder.append(auditActionContext.getWhenActionWasPerformed());
                builder.append(this.getEntrySeparator());
            } else {
                builder.append("WHEN: ");
                builder.append(auditActionContext.getWhenActionWasPerformed());
                builder.append("\n");
            }
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains((Object)AuditTrailManager.AuditableFields.WHO)) {
            if (this.useSingleLine) {
                builder.append(auditActionContext.getPrincipal());
                builder.append(this.getEntrySeparator());
            } else {
                builder.append("WHO: ");
                builder.append(auditActionContext.getPrincipal());
                builder.append("\n");
            }
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains((Object)AuditTrailManager.AuditableFields.WHAT)) {
            if (this.useSingleLine) {
                builder.append(auditActionContext.getResourceOperatedUpon());
                builder.append(this.getEntrySeparator());
            } else {
                builder.append("WHAT: ");
                builder.append(auditActionContext.getResourceOperatedUpon());
                builder.append("\n");
            }
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains((Object)AuditTrailManager.AuditableFields.ACTION)) {
            if (this.useSingleLine) {
                builder.append(auditActionContext.getActionPerformed());
                builder.append(this.getEntrySeparator());
            } else {
                builder.append("ACTION: ");
                builder.append(auditActionContext.getActionPerformed());
                builder.append("\n");
            }
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains((Object)AuditTrailManager.AuditableFields.APPLICATION)) {
            if (this.useSingleLine) {
                builder.append(auditActionContext.getApplicationCode());
                builder.append(this.getEntrySeparator());
            } else {
                builder.append("APPLICATION: ");
                builder.append(auditActionContext.getApplicationCode());
                builder.append("\n");
            }
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains((Object)AuditTrailManager.AuditableFields.USER_AGENT)) {
            if (this.useSingleLine) {
                builder.append(auditActionContext.getUserAgent());
                builder.append(this.getEntrySeparator());
            } else {
                builder.append("USER-AGENT: ");
                builder.append(auditActionContext.getUserAgent());
                builder.append("\n");
            }
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains((Object)AuditTrailManager.AuditableFields.CLIENT_IP)) {
            if (this.useSingleLine) {
                builder.append(auditActionContext.getClientIpAddress());
                builder.append(this.getEntrySeparator());
            } else {
                builder.append("CLIENT IP ADDRESS: ");
                builder.append(auditActionContext.getClientIpAddress());
                builder.append("\n");
            }
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains((Object)AuditTrailManager.AuditableFields.SERVER_IP)) {
            if (this.useSingleLine) {
                builder.append(auditActionContext.getServerIpAddress());
                builder.append(this.getEntrySeparator());
            } else {
                builder.append("SERVER IP ADDRESS: ");
                builder.append(auditActionContext.getServerIpAddress());
                builder.append("\n");
            }
        }
        if (!this.useSingleLine) {
            builder.append("=============================================================");
            builder.append("\n\n");
        }
        return builder.toString();
    }

    protected Map getMappedAuditActionContext(AuditActionContext auditActionContext) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.auditableFields.isEmpty() || this.auditableFields.contains((Object)AuditTrailManager.AuditableFields.WHO)) {
            map.put("who", auditActionContext.getPrincipal());
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains((Object)AuditTrailManager.AuditableFields.WHAT)) {
            map.put("what", auditActionContext.getResourceOperatedUpon());
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains((Object)AuditTrailManager.AuditableFields.ACTION)) {
            map.put("action", auditActionContext.getActionPerformed());
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains((Object)AuditTrailManager.AuditableFields.APPLICATION)) {
            map.put("application", auditActionContext.getApplicationCode());
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains((Object)AuditTrailManager.AuditableFields.WHEN)) {
            map.put("when", auditActionContext.getWhenActionWasPerformed().toString());
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains((Object)AuditTrailManager.AuditableFields.CLIENT_IP)) {
            map.put("clientIpAddress", auditActionContext.getClientIpAddress());
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains((Object)AuditTrailManager.AuditableFields.SERVER_IP)) {
            map.put("serverIpAddress", auditActionContext.getServerIpAddress());
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains((Object)AuditTrailManager.AuditableFields.USER_AGENT)) {
            map.put("userAgent", auditActionContext.getUserAgent());
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains((Object)AuditTrailManager.AuditableFields.HEADERS)) {
            map.put("headers", auditActionContext.getHeaders());
        }
        return map;
    }
}

