/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.util.NoOpCipherExecutor;
import org.apereo.cas.web.support.CookieValueManager;
import org.apereo.cas.web.support.DefaultCasCookieValueManager$AjcClosure1;
import org.apereo.cas.web.support.DefaultCasCookieValueManager$AjcClosure3;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.aspect.TraceLogAspect;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@RefreshScope
@Component(value="defaultCookieValueManager")
public class DefaultCasCookieValueManager
implements CookieValueManager {
    private static final Logger LOGGER;
    private static final char COOKIE_FIELD_SEPARATOR = '@';
    private static final int COOKIE_FIELDS_LENGTH = 3;
    private CipherExecutor<String, String> cipherExecutor;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        DefaultCasCookieValueManager.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(DefaultCasCookieValueManager.class);
    }

    public DefaultCasCookieValueManager() {
        this((CipherExecutor<String, String>)new NoOpCipherExecutor());
    }

    @Autowired
    public DefaultCasCookieValueManager(@Qualifier(value="cookieCipherExecutor") CipherExecutor<String, String> cipherExecutor) {
        this.cipherExecutor = cipherExecutor;
        LOGGER.debug("Using cipher [{} to encrypt and decode the cookie", this.cipherExecutor.getClass());
    }

    @Override
    public String buildCookieValue(String givenCookieValue, HttpServletRequest request) {
        String string = givenCookieValue;
        HttpServletRequest httpServletRequest = request;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string, (Object)httpServletRequest);
        Object[] objectArray = new Object[]{this, string, httpServletRequest, joinPoint};
        return (String)TraceLogAspect.aspectOf().traceMethod(new DefaultCasCookieValueManager$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public String obtainCookieValue(Cookie cookie, HttpServletRequest request) {
        Cookie cookie2 = cookie;
        HttpServletRequest httpServletRequest = request;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)cookie2, (Object)httpServletRequest);
        Object[] objectArray = new Object[]{this, cookie2, httpServletRequest, joinPoint};
        return (String)TraceLogAspect.aspectOf().traceMethod(new DefaultCasCookieValueManager$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    static final /* synthetic */ String buildCookieValue_aroundBody0(DefaultCasCookieValueManager ajc$this, String givenCookieValue, HttpServletRequest request, JoinPoint joinPoint) {
        StringBuilder builder = new StringBuilder(givenCookieValue);
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        builder.append('@');
        builder.append(clientInfo.getClientIpAddress());
        String userAgent = WebUtils.getHttpServletRequestUserAgent((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userAgent)) {
            throw new IllegalStateException("Request does not specify a user-agent");
        }
        builder.append('@');
        builder.append(userAgent);
        String res = builder.toString();
        LOGGER.debug("Encoding cookie value [{}]", (Object)res);
        return (String)ajc$this.cipherExecutor.encode((Object)res);
    }

    static final /* synthetic */ String obtainCookieValue_aroundBody2(DefaultCasCookieValueManager ajc$this, Cookie cookie, HttpServletRequest request, JoinPoint joinPoint) {
        String cookieValue = (String)ajc$this.cipherExecutor.decode((Object)cookie.getValue());
        LOGGER.debug("Decoded cookie value is [{}]", (Object)cookieValue);
        if (StringUtils.isBlank((CharSequence)cookieValue)) {
            LOGGER.debug("Retrieved decoded cookie value is blank. Failed to decode cookie [{}]", (Object)cookie.getName());
            return null;
        }
        String[] cookieParts = cookieValue.split(String.valueOf('@'));
        if (cookieParts.length != 3) {
            throw new IllegalStateException("Invalid cookie. Required fields are missing");
        }
        String value = cookieParts[0];
        String remoteAddr = cookieParts[1];
        String userAgent = cookieParts[2];
        if (StringUtils.isBlank((CharSequence)value) || StringUtils.isBlank((CharSequence)remoteAddr) || StringUtils.isBlank((CharSequence)userAgent)) {
            throw new IllegalStateException("Invalid cookie. Required fields are empty");
        }
        if (!remoteAddr.equals(request.getRemoteAddr())) {
            throw new IllegalStateException("Invalid cookie. Required remote address does not match " + request.getRemoteAddr());
        }
        String agent = WebUtils.getHttpServletRequestUserAgent((HttpServletRequest)request);
        if (!userAgent.equals(agent)) {
            throw new IllegalStateException("Invalid cookie. Required user-agent does not match " + agent);
        }
        return value;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DefaultCasCookieValueManager.java", DefaultCasCookieValueManager.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildCookieValue", "org.apereo.cas.web.support.DefaultCasCookieValueManager", "java.lang.String:javax.servlet.http.HttpServletRequest", "givenCookieValue:request", "", "java.lang.String"), 57);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "obtainCookieValue", "org.apereo.cas.web.support.DefaultCasCookieValueManager", "javax.servlet.http.Cookie:javax.servlet.http.HttpServletRequest", "cookie:request", "", "java.lang.String"), 77);
    }
}

