/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support;

import java.lang.reflect.Method;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator$AjcClosure1;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator$AjcClosure3;
import org.apereo.cas.web.support.CookieValueManager;
import org.apereo.cas.web.support.NoOpCookieValueManager;
import org.apereo.inspektr.aspect.TraceLogAspect;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.util.CookieGenerator;
import org.springframework.web.util.WebUtils;

public class CookieRetrievingCookieGenerator
extends CookieGenerator {
    private static final int DEFAULT_REMEMBER_ME_MAX_AGE = 7889231;
    private int rememberMeMaxAge = 7889231;
    private CookieValueManager casCookieValueManager;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public CookieRetrievingCookieGenerator() {
        this(new NoOpCookieValueManager());
    }

    public CookieRetrievingCookieGenerator(CookieValueManager casCookieValueManager) {
        this.casCookieValueManager = casCookieValueManager;
    }

    public void addCookie(HttpServletRequest request, HttpServletResponse response, String cookieValue) {
        HttpServletRequest httpServletRequest = request;
        HttpServletResponse httpServletResponse = response;
        String string = cookieValue;
        Object[] objectArray = new Object[]{httpServletRequest, httpServletResponse, string};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, httpServletRequest, httpServletResponse, string, joinPoint};
        TraceLogAspect.aspectOf().traceMethod(new CookieRetrievingCookieGenerator$AjcClosure1(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public String retrieveCookieValue(HttpServletRequest request) {
        HttpServletRequest httpServletRequest = request;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)httpServletRequest);
        Object[] objectArray = new Object[]{this, httpServletRequest, joinPoint};
        return (String)TraceLogAspect.aspectOf().traceMethod(new CookieRetrievingCookieGenerator$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void setRememberMeMaxAge(int maxAge) {
        this.rememberMeMaxAge = maxAge;
    }

    public void setCookieDomain(String cookieDomain) {
        super.setCookieDomain((String)StringUtils.defaultIfEmpty((CharSequence)cookieDomain, null));
    }

    static {
        CookieRetrievingCookieGenerator.ajc$preClinit();
    }

    static final /* synthetic */ void addCookie_aroundBody0(CookieRetrievingCookieGenerator ajc$this, HttpServletRequest request, HttpServletResponse response, String cookieValue, JoinPoint joinPoint) {
        String theCookieValue = ajc$this.casCookieValueManager.buildCookieValue(cookieValue, request);
        if (StringUtils.isNotBlank((CharSequence)request.getParameter("rememberMe"))) {
            super.addCookie(response, theCookieValue);
        } else {
            Cookie cookie = ajc$this.createCookie(theCookieValue);
            cookie.setMaxAge(ajc$this.rememberMeMaxAge);
            if (ajc$this.isCookieSecure()) {
                cookie.setSecure(true);
            }
            if (ajc$this.isCookieHttpOnly()) {
                Method setHttpOnlyMethod = ReflectionUtils.findMethod(Cookie.class, (String)"setHttpOnly", (Class[])new Class[]{Boolean.TYPE});
                if (setHttpOnlyMethod != null) {
                    cookie.setHttpOnly(true);
                } else {
                    ajc$this.logger.debug((Object)"Cookie cannot be marked as HttpOnly; container is not using servlet 3.0.");
                }
            }
            response.addCookie(cookie);
        }
    }

    static final /* synthetic */ String retrieveCookieValue_aroundBody2(CookieRetrievingCookieGenerator ajc$this, HttpServletRequest request, JoinPoint joinPoint) {
        try {
            Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)ajc$this.getCookieName());
            return cookie == null ? null : ajc$this.casCookieValueManager.obtainCookieValue(cookie, request);
        }
        catch (Exception e) {
            ajc$this.logger.debug((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CookieRetrievingCookieGenerator.java", CookieRetrievingCookieGenerator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addCookie", "org.apereo.cas.web.support.CookieRetrievingCookieGenerator", "javax.servlet.http.HttpServletRequest:javax.servlet.http.HttpServletResponse:java.lang.String", "request:response:cookieValue", "", "void"), 61);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "retrieveCookieValue", "org.apereo.cas.web.support.CookieRetrievingCookieGenerator", "javax.servlet.http.HttpServletRequest", "request", "", "java.lang.String"), 90);
    }
}

